/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.web.ajax.RequestHandler;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONString;
import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.DefaultThreadGenerator;
import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.ThreadGenerator;
import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.ThreadSchedulerConfig;
import com.kingdee.bos.ctrl.analysis.web.ajax.threadscheduler.ThreadSchedulerImpl;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class ServletHelper {
    private static final Logger logger = CommonLogger.getLogger(ServletHelper.class);
    private static ThreadGenerator tg = new DefaultThreadGenerator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleJSONRPC(final HttpServletRequest request, final HttpServletResponse response, final RequestHandler handler) throws ServletException, IOException {
        String ret;
        block11: {
            ServletHelper.adjustRequestResponse(request, response);
            ret = null;
            Context ctx = Context.enter();
            try {
                final Scriptable scope = ctx.initStandardObjects(null);
                final Scriptable json = (Scriptable)ctx.evaluateString(scope, "json = (" + request.getParameter("json") + ")", "JSON", 1, null);
                if ("Object".equals(json.getClassName())) {
                    HttpServletRequest req = ServletHelper.createProxy(request, scope, json, true);
                    ret = ServletHelper.wrapNormal(handler.handle(req, response));
                    break block11;
                }
                if ("Array".equals(json.getClassName())) {
                    final Map resultMap = Collections.synchronizedMap(new HashMap());
                    final int requestCount = ((Double)json.get("length", json)).intValue() - 1;
                    final String pattern = ServletHelper.getPattern(ctx, scope);
                    ThreadSchedulerConfig config = new ThreadSchedulerConfig(){

                        @Override
                        public void done(Object id) {
                            try {
                                HttpServletRequest req = ServletHelper.createProxy(request, scope, (Scriptable)json.get(Integer.parseInt(id + ""), scope), false);
                                resultMap.put(id, handler.handle(req, response));
                            }
                            catch (BIReportException e) {
                                logger.error((Object)("handleJSONRPC: " + e.getMessage()), (Throwable)e);
                                resultMap.put(id, ServletHelper.wrapErrorJSON(e.getMessage()));
                            }
                            catch (Throwable e) {
                                logger.error((Object)("handleJSONRPC: " + e.getMessage()), e);
                                resultMap.put(id, ServletHelper.wrapErrorJSON(e.getMessage()));
                            }
                        }

                        @Override
                        public String getPattern() {
                            return pattern;
                        }

                        @Override
                        public boolean isAsynchronous() {
                            return false;
                        }

                        @Override
                        public int getSemaphore() {
                            return requestCount;
                        }
                    };
                    ThreadSchedulerImpl scheduler = new ThreadSchedulerImpl(config, tg);
                    scheduler.run();
                    ret = ServletHelper.wrapNormal(new JSONMap(resultMap));
                    break block11;
                }
                throw new JavaScriptException((Object)"\u9047\u5230\u5947\u602a\u7684JSON\u7c7b\u578b\uff0c\u5ba2\u6237\u7aef\u4ee3\u7801\u53ef\u80fd\u7f16\u5199\u9519\u8bef");
            }
            catch (JavaScriptException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                ret = ServletHelper.wrapError(new JSONString("\u670d\u52a1\u7aef\u53d1\u751fJavaScript\u9519\u8bef\uff1a" + e.getMessage()));
            }
            catch (BIReportException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                ret = ServletHelper.wrapError(new JSONString(e.getMessage()));
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
                ret = ServletHelper.wrapError(new JSONString(e.getMessage()));
            }
            finally {
                Context.exit();
            }
        }
        ServletHelper.writeOut(response, ret);
    }

    private static HttpServletRequest createProxy(final HttpServletRequest request, final Scriptable scope, final Scriptable json, final boolean wrap) {
        return (HttpServletRequest)Proxy.newProxyInstance(HttpServletRequest.class.getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String name = method.getName();
                if ("getParameter".equals(name)) {
                    String arg0 = (String)args[0];
                    if ("$wrap".equals(arg0)) {
                        return Boolean.toString(wrap);
                    }
                    Object str = json.get(arg0, scope);
                    return str == null || Context.getUndefinedValue().equals(str) || Scriptable.NOT_FOUND.equals(str) ? null : str + "";
                }
                if ("getParameterValues".equals(name)) {
                    Object o = json.get((String)args[0], scope);
                    if (o == null || Context.getUndefinedValue().equals(o) || Scriptable.NOT_FOUND.equals(o)) {
                        return null;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    Scriptable s = (Scriptable)o;
                    int i = 0;
                    while (s.has(i, scope)) {
                        list.add(s.get(i, scope) + "");
                        ++i;
                    }
                    return list.toArray(new String[0]);
                }
                return method.invoke((Object)request, args);
            }
        });
    }

    public static HttpServletRequest createProxy(HttpServletRequest request) throws ServletException {
        Context ctx = Context.enter();
        try {
            Scriptable scope = ctx.initStandardObjects(null);
            Scriptable json = (Scriptable)ctx.evaluateString(scope, "json = (" + request.getParameter("json") + ")", "JSON", 1, null);
            if ("Object".equals(json.getClassName())) {
                HttpServletRequest httpServletRequest = ServletHelper.createProxy(request, scope, json, true);
                return httpServletRequest;
            }
            if ("Array".equals(json.getClassName())) {
                HttpServletRequest httpServletRequest = ServletHelper.createProxy(request, scope, json, false);
                return httpServletRequest;
            }
            try {
                throw new JavaScriptException((Object)"\u9047\u5230\u5947\u602a\u7684JSON\u7c7b\u578b\uff0c\u5ba2\u6237\u7aef\u4ee3\u7801\u53ef\u80fd\u7f16\u5199\u9519\u8bef");
            }
            catch (JavaScriptException e) {
                throw new ServletException((Throwable)e);
            }
        }
        finally {
            Context.exit();
        }
    }

    private static String getPattern(Context ctx, Scriptable scope) throws JavaScriptException {
        return (String)ctx.evaluateString(scope, new StringBuffer().append("var pattern = json[0];\n").append("if ( pattern.indexOf( '*' ) != -1 ) {\n").append("    var a = [];\n").append("    for( var i = 1; i < json.length; i++ ) {\n").append("        if ( pattern.indexOf( '' + i ) == -1 ) a.push( i );\n").append("    }\n").append("    pattern = pattern.replace( /\\*./, a.join( pattern.match( /\\*(.)/ )[1] ) );\n").append("}\n").append("pattern;").toString(), "", 1, null);
    }

    public static String wrapNormal(JSON json) {
        return "{result:" + json + "}";
    }

    public static String wrapError(JSON json) {
        return "{error:{message:" + json + "}}";
    }

    public static JSON wrapErrorJSON(String errorMessage) {
        HashMap map = new HashMap(2);
        HashMap<String, String> map2 = new HashMap<String, String>(2);
        map2.put("message", errorMessage);
        map.put("error", map2);
        return new JSONMap(map);
    }

    static void adjustRequestResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setCharacterEncoding("utf-8");
        response.setContentType("text/html;charset=UTF-8");
    }

    public static void writeOut(HttpServletResponse response, String ret) throws IOException {
        PrintWriter out = response.getWriter();
        out.print(ret);
        out.flush();
    }
}

