/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.web.ajax.RequestHandler;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONString;
import com.kingdee.bos.ctrl.analysis.web.export.DashboardExportImport;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;

public class UploadHandler
implements RequestHandler {
    public static final String MultipartFileName = "MultipartFileName";
    public static final String MultipartByte = "MultipartByte";

    @Override
    public JSON handle(HttpServletRequest request, HttpServletResponse response) throws BIReportException {
        DiskFileUpload dfu = new DiskFileUpload();
        dfu.setHeaderEncoding("utf-8");
        try (Repository rep = null;){
            JSON jSON;
            request.setCharacterEncoding("utf-8");
            response.setContentType("text/html;charset=UTF-8");
            List items = dfu.parseRequest(request);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (FileItem item : items) {
                if (item.isFormField()) {
                    map.put(item.getFieldName(), item.getString("utf-8"));
                    continue;
                }
                map.put(MultipartFileName, item.getName());
                map.put(MultipartByte, item.get());
            }
            if (map.containsKey("isDashboardImport")) {
                jSON = DashboardExportImport.importDashboard(map, request);
                return jSON;
            }
            jSON = this.uploadImage(map, request);
            return jSON;
        }
    }

    private JSON uploadImage(HashMap map, HttpServletRequest request) throws BIReportException {
        String parent = (String)map.get("savePath");
        String caption = (String)map.get("caption");
        String overwrite = (String)map.get("isOverwrite");
        String filename = (String)map.get(MultipartFileName);
        String imageType = filename.substring(filename.lastIndexOf(".") + 1);
        String resName = "RESOURCE" + IDGenerator.getUUID();
        byte[] data = (byte[])map.get(MultipartByte);
        Repository rep = BISystem.getRepository(request);
        String id = rep.saveResource("true".equalsIgnoreCase(overwrite), parent, caption, resName, data, imageType);
        StringBuffer sb = new StringBuffer();
        sb.append(caption);
        sb.append(",");
        sb.append(id);
        sb.append(",");
        sb.append(parent + "/" + resName);
        sb.append(",");
        sb.append("false");
        return new JSONString(sb.toString());
    }
}

