/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.appmodel;

import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractMainModel;
import java.io.Serializable;
import java.util.ArrayList;

public class AbstractTreeNode
implements Serializable,
Comparable {
    private static final long serialVersionUID = -6346467998604601450L;
    private AbstractMainModel _model;
    private AbstractTreeNode _parentNode;
    private ArrayList _children;
    private boolean _canSelect = true;
    private int _order;

    public void setModel(AbstractMainModel model) {
        this._model = model;
    }

    public AbstractMainModel getModel() {
        return this._model;
    }

    public boolean canSelect() {
        return this._canSelect;
    }

    public void setCanSelect(boolean canSelect) {
        this._canSelect = canSelect;
    }

    public void setOrder(int order) {
        this._order = order;
    }

    public int getOrder() {
        return this._order;
    }

    protected void setParentNode(AbstractTreeNode parent) {
        this._parentNode = parent;
    }

    public AbstractTreeNode getParentNode() {
        return this._parentNode;
    }

    private ArrayList getChildren() {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        return this._children;
    }

    public void addChildNode(AbstractTreeNode child) {
        child.setParentNode(this);
        this.getChildren().add(child);
    }

    public int getChildCount() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public AbstractTreeNode getChildNode(int idx) {
        return (AbstractTreeNode)this.getChildren().get(idx);
    }

    public void removeAllChildren() {
        if (this._children != null) {
            this._children.clear();
        }
    }

    public boolean equals(Object node) {
        if (node instanceof AbstractTreeNode) {
            AbstractTreeNode o = (AbstractTreeNode)node;
            AbstractMainModel m = o.getModel();
            if (m.getNumber() != null) {
                return m.getNumber().equals(this._model.getNumber());
            }
            return this._model.getNumber() == null;
        }
        return false;
    }

    public int compareTo(Object anotherNode) {
        if (anotherNode instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)anotherNode;
            return this._model.compareTo(node.getModel());
        }
        return 0;
    }

    public int getIndex(AbstractTreeNode node) {
        if (this.isLeaf() || node == null) {
            return -1;
        }
        int len = this.getChildCount();
        for (int i = 0; i < len; ++i) {
            if (!node.equals(this.getChildNode(i))) continue;
            return i;
        }
        return -1;
    }
}

