/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.analysis.web.chart.EASConstant;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.freechart.chart.JFreeChart;
import com.kingdee.bos.ctrl.freechart.chart.axis.CategoryAxis;
import com.kingdee.bos.ctrl.freechart.chart.axis.CategoryAxis3D;
import com.kingdee.bos.ctrl.freechart.chart.axis.CategoryLabelPositions;
import com.kingdee.bos.ctrl.freechart.chart.axis.DateAxis;
import com.kingdee.bos.ctrl.freechart.chart.axis.NumberAxis;
import com.kingdee.bos.ctrl.freechart.chart.axis.NumberAxis3D;
import com.kingdee.bos.ctrl.freechart.chart.axis.ValueAxis;
import com.kingdee.bos.ctrl.freechart.chart.labels.CategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.CategoryToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.ItemLabelAnchor;
import com.kingdee.bos.ctrl.freechart.chart.labels.ItemLabelPosition;
import com.kingdee.bos.ctrl.freechart.chart.labels.PieSectionLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.PieToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardCategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardCategoryToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardPieSectionLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardPieToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardXYToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.XYToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.plot.CategoryPlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.CombinedDomainCategoryPlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.DatasetRenderingOrder;
import com.kingdee.bos.ctrl.freechart.chart.plot.MultiplePiePlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PiePlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PiePlot3D;
import com.kingdee.bos.ctrl.freechart.chart.plot.Plot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PlotOrientation;
import com.kingdee.bos.ctrl.freechart.chart.plot.RadarPlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.RadarPlot2;
import com.kingdee.bos.ctrl.freechart.chart.plot.TreePlot;
import com.kingdee.bos.ctrl.freechart.chart.plot.XYPlot;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.AreaRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.BarRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.BarRenderer3D;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.CategoryItemRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.LineAndShapeRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.StackedAreaRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.StackedBarRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.StackedBarRenderer3D;
import com.kingdee.bos.ctrl.freechart.chart.renderer.xy.StandardXYItemRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.xy.XYItemRenderer;
import com.kingdee.bos.ctrl.freechart.chart.title.TextTitle;
import com.kingdee.bos.ctrl.freechart.chart.urls.CategoryURLGenerator;
import com.kingdee.bos.ctrl.freechart.chart.urls.PieURLGenerator;
import com.kingdee.bos.ctrl.freechart.chart.urls.StandardPieURLGenerator;
import com.kingdee.bos.ctrl.freechart.chart.urls.StandardXYURLGenerator;
import com.kingdee.bos.ctrl.freechart.chart.urls.XYURLGenerator;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.general.DefaultTreeDataset;
import com.kingdee.bos.ctrl.freechart.data.general.PieDataset;
import com.kingdee.bos.ctrl.freechart.data.xy.XYDataset;
import com.kingdee.bos.ctrl.freechart.ui.RectangleInsets;
import com.kingdee.bos.ctrl.freechart.ui.TextAnchor;
import com.kingdee.bos.ctrl.freechart.util.TableOrder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ChartFactory {
    static String urlPrefix = "";

    public static JFreeChart createPieChart(String title, Font titleFont, PieDataset dataset, boolean legend, boolean tooltips, boolean urls) {
        PiePlot plot = new PiePlot(dataset);
        plot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        plot.setCircular(true);
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}({2})", EASConstant.NUMBERFORMAT, NumberFormat.getPercentInstance()));
        if (tooltips) {
            plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("({0},{1}) = {2}", EASConstant.NUMBERFORMAT, NumberFormat.getPercentInstance()));
        }
        if (urls) {
            plot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator());
        }
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createMultiplePieChart(String title, Font titleFont, CategoryDataset data, TableOrder order, boolean legend, boolean tooltips, boolean urls, PieURLGenerator urlGenerator) {
        MultiplePiePlot plot = new MultiplePiePlot(data);
        plot.setDataExtractOrder(order);
        PiePlot pp = (PiePlot)plot.getPieChart().getPlot();
        pp.setBackgroundPaint(null);
        pp.setOutlineStroke(null);
        pp.setSectionOutlineStroke(EASConstant.STOKE_PIESECTIONOUTLINE);
        StandardPieToolTipGenerator tooltipGenerator = null;
        if (tooltips) {
            tooltipGenerator = new StandardPieToolTipGenerator("({0},{1}) = {2}", EASConstant.NUMBERFORMAT, EASConstant.PERCENT_NUMBERFORMAT);
        }
        if (!urls) {
            urlGenerator = null;
        }
        pp.setToolTipGenerator(tooltipGenerator);
        pp.setURLGenerator(urlGenerator);
        pp.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{2}", (NumberFormat)new DecimalFormat("###0.##;-###0.##"), EASConstant.PERCENT_NUMBERFORMAT));
        pp.setLabelBackgroundPaint((Paint)new Color(220, 220, 220));
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart create3DPieChart(String title, Font titleFont, PieDataset dataset, boolean legend, boolean tooltips, boolean urls) {
        PiePlot3D plot = new PiePlot3D(dataset);
        plot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        plot.setCircular(true);
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}({2})", EASConstant.NUMBERFORMAT, NumberFormat.getPercentInstance()));
        if (tooltips) {
            plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator("{0} = {1}", EASConstant.NUMBERFORMAT, NumberFormat.getPercentInstance()));
        }
        if (urls) {
            plot.setURLGenerator((PieURLGenerator)new StandardPieURLGenerator());
        }
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createBarChart(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean percentForTooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        ItemLabelPosition position2;
        ItemLabelPosition position1;
        BarRenderer renderer = EASConstant.getSingleSeriesBarRenderer(data);
        if (legend && data.getRowCount() == 1) {
            categoryAxisLabel = data.getRowKey(0).toString();
            legend = false;
        }
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        if (orientation == PlotOrientation.HORIZONTAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            renderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            renderer.setNegativeItemLabelPosition(position2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            renderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            renderer.setNegativeItemLabelPosition(position2);
        }
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(percentForTooltips));
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        valueAxis.setUpperMargin(0.15);
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        renderer.setDrawBarOutline(true);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createBarChart3D(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean percentForTooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        ItemLabelPosition position2;
        ItemLabelPosition position1;
        if (legend && data.getRowCount() == 1) {
            categoryAxisLabel = data.getRowKey(0).toString();
            legend = false;
        }
        CategoryAxis3D categoryAxis = new CategoryAxis3D(categoryAxisLabel);
        NumberAxis3D valueAxis = new NumberAxis3D(valueAxisLabel);
        valueAxis.setUpperMargin(0.15);
        BarRenderer3D renderer = EASConstant.getSingleSeriesBarRenderer3D(data);
        if (orientation == PlotOrientation.HORIZONTAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            renderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            renderer.setNegativeItemLabelPosition(position2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            renderer.setPositiveItemLabelPosition(position1);
            position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            renderer.setNegativeItemLabelPosition(position2);
        }
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(percentForTooltips));
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        plot.setForegroundAlpha(0.75f);
        renderer.setDrawBarOutline(true);
        renderer.setItemLabelsVisible(true);
        renderer.setBaseItemLabelsVisible(true);
        renderer.setItemLabelAnchorOffset(10.0);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createStackedBarChart(String title, Font titleFont, String domainAxisLabel, String rangeAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean percentForTooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        if (legend && data.getRowCount() == 1) {
            domainAxisLabel = data.getRowKey(0).toString();
            legend = false;
        }
        CategoryAxis categoryAxis = new CategoryAxis(domainAxisLabel);
        NumberAxis valueAxis = new NumberAxis(rangeAxisLabel);
        StackedBarRenderer renderer = new StackedBarRenderer();
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(percentForTooltips));
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createStackedBarChart3D(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean percentForTooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        if (legend && data.getRowCount() == 1) {
            categoryAxisLabel = data.getRowKey(0).toString();
            legend = false;
        }
        CategoryAxis3D categoryAxis = new CategoryAxis3D(categoryAxisLabel);
        NumberAxis3D valueAxis = new NumberAxis3D(valueAxisLabel);
        StackedBarRenderer3D renderer = new StackedBarRenderer3D();
        StandardCategoryToolTipGenerator toolTipGenerator = null;
        if (tooltips) {
            toolTipGenerator = EASConstant.getDefaultCategoryTooltipGenerator(percentForTooltips);
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        renderer.setToolTipGenerator((CategoryToolTipGenerator)toolTipGenerator);
        CategoryPlot plot = new CategoryPlot(data, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createLineChart(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean percentForTooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        renderer.setShapesVisible(true);
        renderer.setDrawOutlines(true);
        renderer.setUseFillPaint(true);
        renderer.setFillPaint((Paint)Color.white);
        int serierCount = data.getRowCount();
        for (int i = 0; i < serierCount; ++i) {
            renderer.setSeriesStroke(i, (Stroke)new BasicStroke(3.0f));
            renderer.setSeriesOutlineStroke(i, (Stroke)new BasicStroke(2.0f));
            renderer.setSeriesShape(i, (Shape)new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
        }
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(percentForTooltips));
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        int categoryCount = data.getColumnCount();
        if (categoryCount > 4) {
            categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        }
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createAreaChart(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean percentForTooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        AreaRenderer renderer = new AreaRenderer();
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(percentForTooltips));
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createStackedAreaChart(String title, Font titleFont, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean percentForTooltips, boolean urls, CategoryURLGenerator urlGenerator) {
        CategoryAxis categoryAxis = new CategoryAxis(categoryAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        StackedAreaRenderer renderer = new StackedAreaRenderer();
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(percentForTooltips));
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CategoryPlot plot = new CategoryPlot(data, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createTimeSeriesChart(String title, Font titleFont, String timeAxisLabel, String valueAxisLabel, XYDataset data, boolean legend, boolean tooltips, boolean urls) {
        DateAxis timeAxis = new DateAxis(timeAxisLabel);
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(data, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
        StandardXYToolTipGenerator tooltipGenerator = null;
        if (tooltips) {
            tooltipGenerator = StandardXYToolTipGenerator.getTimeSeriesInstance();
        }
        StandardXYURLGenerator urlGenerator = null;
        if (urls) {
            urlGenerator = new StandardXYURLGenerator();
        }
        plot.setRenderer((XYItemRenderer)new StandardXYItemRenderer(2, (XYToolTipGenerator)tooltipGenerator, (XYURLGenerator)urlGenerator));
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createRadarChart(String title, Font titleFont, CategoryDataset dataset, boolean legend) {
        RadarPlot plot = new RadarPlot(dataset);
        plot.setStartAngle(0.0);
        plot.setInteriorGap(0.2);
        plot.setLabelFont(titleFont.deriveFont(1, 10.0f));
        plot.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator());
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        plot.setCircleBackgroundPaint(EASConstant.PAINT_RADAR_BACKGROUPD);
        plot.setAxisLinePaint(EASConstant.PAINT_RADAR_OUTLINE);
        plot.setAxisLineStroke((Stroke)new BasicStroke(1.5f));
        return chart;
    }

    public static JFreeChart createRadarChart2(String title, Font titleFont, CategoryDataset dataset, int minIndex, int maxIndex, boolean legend, boolean isDisplayName, boolean isDisplayValue, boolean isFillBackground, boolean isShowPercentFormatForValue, boolean isShowPercentFormatForTooltip) throws BIReportException {
        RadarPlot2 plot = new RadarPlot2(dataset, minIndex, maxIndex, isShowPercentFormatForValue, isShowPercentFormatForTooltip);
        if (dataset != null) {
            int rowLength = dataset.getRowCount();
            if (minIndex < 0 || minIndex >= rowLength || maxIndex < 0 || maxIndex >= rowLength) {
                plot.setWrongDataMessage("\u62a5\u8868\u5217\u7ef4\u6570\u636e\u4e0d\u8db3\uff0c\u96f7\u8fbe\u56fe\u4e0d\u80fd\u663e\u793a\u3002\u8bf7\u786e\u4fdd\u5217\u7ef4\u81f3\u5c11\u67092\u5217\u6570\u636e");
                title = null;
                legend = false;
            }
        }
        plot.setNoDataMessage("\u6ca1\u6709\u53ef\u4f9b\u96f7\u8fbe\u56fe\u663e\u793a\u7684\u6570\u636e");
        plot.setWebFilled(isFillBackground);
        plot.setShowCategoryName(isDisplayName);
        plot.setShowStandardValue(isDisplayValue);
        plot.setStartAngle(0.0);
        plot.setInteriorGap(0.2);
        plot.setLabelFont(titleFont.deriveFont(1, 10.0f));
        JFreeChart chart = new JFreeChart(title, TextTitle.DEFAULT_FONT, (Plot)plot, legend);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        return chart;
    }

    public static JFreeChart createBarLineChart(String title, Font titleFont, String domainAxisName, boolean tooltips, boolean urls, CategoryURLGenerator urlGenerator, boolean legend, CategoryDataset barDataset, String rangeAxisNameforBar, CategoryDataset lineDataset, String rangeAxisNameforLine) {
        CategoryPlot plot = new CategoryPlot();
        StandardCategoryItemLabelGenerator generator = new StandardCategoryItemLabelGenerator();
        BarRenderer renderer = new BarRenderer();
        renderer.setItemLabelGenerator((CategoryItemLabelGenerator)generator);
        LineAndShapeRenderer lsrenderer = new LineAndShapeRenderer();
        lsrenderer.setShapesVisible(true);
        lsrenderer.setDrawOutlines(true);
        lsrenderer.setUseFillPaint(true);
        lsrenderer.setFillPaint((Paint)Color.white);
        int serierCount = lineDataset.getRowCount();
        for (int i = 0; i < serierCount; ++i) {
            lsrenderer.setSeriesStroke(i, (Stroke)new BasicStroke(3.0f));
            lsrenderer.setSeriesOutlineStroke(i, (Stroke)new BasicStroke(2.0f));
            lsrenderer.setSeriesShape(i, (Shape)new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
        }
        plot.setDataset(barDataset);
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.setDataset(1, lineDataset);
        plot.setRenderer(1, (CategoryItemRenderer)lsrenderer);
        plot.setDomainAxis(new CategoryAxis(domainAxisName));
        plot.setRangeAxis((ValueAxis)new NumberAxis(rangeAxisNameforBar));
        plot.setRangeAxis(1, (ValueAxis)new NumberAxis(rangeAxisNameforLine));
        plot.mapDatasetToRangeAxis(1, 1);
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
            lsrenderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
            lsrenderer.setItemURLGenerator(urlGenerator);
        }
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setRangeGridlinesVisible(true);
        plot.setDomainGridlinesVisible(true);
        plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createCombineBarLineChart(String title, Font titleFont, String domainAxisName, boolean tooltips, boolean urls, CategoryURLGenerator urlGenerator, boolean legend, CategoryDataset barDataset, String rangeAxisNameforBar, CategoryDataset lineDataset, String rangeAxisNameforLine) {
        CategoryPlot plot1 = new CategoryPlot();
        StandardCategoryItemLabelGenerator generator = new StandardCategoryItemLabelGenerator();
        BarRenderer renderer = new BarRenderer();
        renderer.setItemLabelGenerator((CategoryItemLabelGenerator)generator);
        CategoryAxis domainAxis = new CategoryAxis(domainAxisName);
        plot1.setDataset(barDataset);
        plot1.setRenderer((CategoryItemRenderer)renderer);
        plot1.setDomainAxis(domainAxis);
        plot1.setRangeAxis((ValueAxis)new NumberAxis(rangeAxisNameforBar));
        plot1.setOrientation(PlotOrientation.VERTICAL);
        plot1.setRangeGridlinesVisible(true);
        plot1.setDomainGridlinesVisible(true);
        plot1.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        LineAndShapeRenderer lsrenderer = new LineAndShapeRenderer();
        CategoryPlot plot2 = new CategoryPlot();
        plot2.setDataset(lineDataset);
        plot2.setRenderer((CategoryItemRenderer)lsrenderer);
        lsrenderer.setShapesVisible(true);
        lsrenderer.setDrawOutlines(true);
        lsrenderer.setUseFillPaint(true);
        lsrenderer.setFillPaint((Paint)Color.white);
        int serierCount = lineDataset.getRowCount();
        for (int i = 0; i < serierCount; ++i) {
            lsrenderer.setSeriesStroke(i, (Stroke)new BasicStroke(3.0f));
            lsrenderer.setSeriesOutlineStroke(i, (Stroke)new BasicStroke(2.0f));
            lsrenderer.setSeriesShape(i, (Shape)new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
        }
        plot2.setDomainAxis(domainAxis);
        plot2.setRangeAxis((ValueAxis)new NumberAxis(rangeAxisNameforLine));
        plot2.setOrientation(PlotOrientation.VERTICAL);
        plot2.setRangeGridlinesVisible(true);
        plot2.setDomainGridlinesVisible(true);
        plot2.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        if (tooltips) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)EASConstant.getDefaultCategoryTooltipGenerator(false));
        }
        if (urls) {
            renderer.setItemURLGenerator(urlGenerator);
        }
        CombinedDomainCategoryPlot plot = new CombinedDomainCategoryPlot(domainAxis);
        plot.add(plot2, 1);
        plot.add(plot1, 1);
        JFreeChart chart = new JFreeChart(title, titleFont, (Plot)plot, legend);
        return chart;
    }

    public static JFreeChart createTreeChart(String title, DefaultTreeDataset dataset) {
        TreePlot plot = new TreePlot(dataset);
        plot.setTextOrder(1);
        JFreeChart chart = new JFreeChart(title, TextTitle.DEFAULT_FONT, (Plot)plot, false);
        return chart;
    }
}

