/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.analysis.web.chart.EasGradientPaintFactory;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardCategoryToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.BarRenderer;
import com.kingdee.bos.ctrl.freechart.chart.renderer.category.BarRenderer3D;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class EASConstant {
    public static final NumberFormat NUMBERFORMAT = new DecimalFormat("#,##0.##;-#,##0.##");
    public static final NumberFormat PERCENT_NUMBERFORMAT = new DecimalFormat("#,##0.##%;-#,##0.##%");
    public static final String DEFAULT_TOOL_TIP_FORMAT_STRING = "({0},{1}) = {2}";
    public static final Stroke STOKE_PIESECTIONOUTLINE = new BasicStroke(1.5f);
    public static final Paint PAINT_SHADOW = new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.4f), 0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.0f));
    public static final Paint PAINT_RADAR_BACKGROUPD = new GradientPaint(0.0f, 0.0f, new Color(16776675), 0.0f, 0.0f, new Color(0xE4FEFE));
    public static final Paint PAINT_RADAR_OUTLINE = new Color(0x366396);

    public static final StandardCategoryToolTipGenerator getDefaultCategoryTooltipGenerator() {
        return EASConstant.getDefaultCategoryTooltipGenerator(false);
    }

    public static final StandardCategoryToolTipGenerator getDefaultCategoryTooltipGenerator(boolean percent) {
        return new StandardCategoryToolTipGenerator(DEFAULT_TOOL_TIP_FORMAT_STRING, percent ? PERCENT_NUMBERFORMAT : NUMBERFORMAT);
    }

    public static final BarRenderer getSingleSeriesBarRenderer(CategoryDataset data) {
        if (data.getRowCount() == 1) {
            return new SingleSeriesBarRenderer();
        }
        return new BarRenderer();
    }

    public static final BarRenderer3D getSingleSeriesBarRenderer3D(CategoryDataset data) {
        if (data.getRowCount() == 1) {
            return new SingleSeriesBarRenderer3D();
        }
        return new BarRenderer3D();
    }

    public static class SingleSeriesBarRenderer3D
    extends BarRenderer3D {
        Paint[] colors = EasGradientPaintFactory.getPaints();
        Paint[] reverseColors = EasGradientPaintFactory.getReversePaints();

        public Paint getItemPaint(int row, int column) {
            return this.colors[column % this.colors.length];
        }

        public Paint getItemOutlinePaint(int row, int column) {
            return this.reverseColors[column % this.reverseColors.length];
        }
    }

    public static class SingleSeriesBarRenderer
    extends BarRenderer {
        Paint[] colors = EasGradientPaintFactory.getPaints();
        Paint[] reverseColors = EasGradientPaintFactory.getReversePaints();

        public Paint getItemPaint(int row, int column) {
            return this.colors[column % this.colors.length];
        }

        public Paint getItemOutlinePaint(int row, int column) {
            return this.reverseColors[column % this.reverseColors.length];
        }
    }
}

