/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard.authorized;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONArray;
import com.kingdee.bos.ctrl.analysis.web.permission.MetaData_EAS;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bosbi.mapping.vo.DashBoard;
import com.kingdee.bosbi.mapping.vo.ItemTreeNode;
import com.kingdee.bosbi.mapping.vo.ItemTypeVo;
import com.kingdee.bosbi.mapping.vo.ItemVo;
import com.kingdee.bosbi.mapping.vo.Role;
import com.kingdee.bosbi.mapping.vo.RolePermissions_dg;
import com.kingdee.bosbi.mapping.vo.User;
import com.kingdee.bosbi.mapping.vo.UserPermissions_dg;
import com.kingdee.eas.base.permission.DiscretePermCollection;
import com.kingdee.eas.base.permission.DiscretePermInfo;
import com.kingdee.eas.base.permission.DiscretePermissionFactory;
import com.kingdee.eas.base.permission.IDiscretePermission;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.BIDashboardTreeCollection;
import com.kingdee.eas.framework.bireport.BIDashboardTreeFactory;
import com.kingdee.eas.framework.bireport.BIDashboardTreeInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class DashBoardAuthorized {
    public static String getAllUsers(Context ctx) {
        String users = "null";
        ArrayList<User> l = new ArrayList<User>();
        try {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sc = view.getSelector();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("CU.*"));
            sc.add(new SelectorItemInfo("group.name"));
            SorterItemInfo sorterInfo = new SorterItemInfo("number");
            sorterInfo.setSortType(SortType.ASCEND);
            view.getSorter().add(sorterInfo);
            UserCollection uc = UserFactory.getLocalInstance((Context)ctx).getUserCollection(view);
            if (uc == null) {
                return users;
            }
            for (int i = 0; i < uc.size(); ++i) {
                UserInfo ui = uc.get(i);
                User u = new User();
                int no = i + 1;
                u.setNo(no + "");
                u.setUserId(ui.getId().toString());
                u.setUserAccount(DashBoardAuthorized.checkAndReplace(ui.getNumber()));
                if (ui.getType() != null) {
                    u.setType(DashBoardAuthorized.checkAndReplace(ui.getType().toString()));
                } else {
                    u.setType("");
                }
                if (ui.getName() != null) {
                    u.setUserRealName(DashBoardAuthorized.checkAndReplace(ui.getName()));
                } else {
                    u.setUserRealName("");
                }
                if (ui.getCU() != null) {
                    u.setManagementUnitBelongs(DashBoardAuthorized.checkAndReplace(ui.getCU().getName()));
                } else {
                    u.setManagementUnitBelongs("");
                }
                if (ui.getGroup() != null) {
                    u.setUserGroups(DashBoardAuthorized.checkAndReplace(ui.getGroup().toString()));
                } else {
                    u.setUserGroups("");
                }
                u.setBusinessAdministrator(ui.isBizAdmin());
                l.add(u);
            }
            users = JSONArray.fromObject(l);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return users;
    }

    public static String getAllRoles(Context ctx) {
        String roles = "null";
        ArrayList<Role> l = new ArrayList<Role>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("CU.*"));
        SorterItemInfo sorterInfo = new SorterItemInfo("number");
        sorterInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterInfo);
        RoleCollection rc = null;
        try {
            rc = RoleFactory.getLocalInstance((Context)ctx).getRoleCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (rc == null) {
            return roles;
        }
        for (int i = 0; i < rc.size(); ++i) {
            RoleInfo ri = rc.get(i);
            Role r = new Role();
            int no = i + 1;
            r.setNo(no + "");
            r.setRoleId(ri.getId().toString());
            r.setOrgNumber(DashBoardAuthorized.checkAndReplace(ri.getCU().getNumber()));
            r.setName(DashBoardAuthorized.checkAndReplace(ri.getName()));
            r.setNumber(DashBoardAuthorized.checkAndReplace(ri.getNumber()));
            if (ri.getCU() != null && ri.getCU().getNumber() != null) {
                r.setOrgNumber(DashBoardAuthorized.checkAndReplace(ri.getCU().getNumber()));
            } else {
                r.setOrgNumber("");
            }
            r.setExplain(DashBoardAuthorized.checkAndReplace(ri.getDescription()));
            if (ri.getType() != null) {
                r.setRoleType(DashBoardAuthorized.checkAndReplace(ri.getType().toString()));
            }
            l.add(r);
        }
        roles = JSONArray.fromObject(l);
        return roles;
    }

    public static String getFirsOrgLevel(Context ctx) {
        String trees = "null";
        FullOrgUnitCollection firstOrg = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", null));
        filter.getFilterItems().add(new FilterItemInfo("isadminorgunit", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        try {
            firstOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (firstOrg == null) {
            return trees;
        }
        FullOrgUnitInfo firstOrgInfo = firstOrg.get(0);
        ArrayList<ItemTreeNode> list = new ArrayList<ItemTreeNode>();
        ItemTypeVo itemTypeVo = new ItemTypeVo();
        itemTypeVo.setName(firstOrgInfo.getName());
        ItemVo itemVo = new ItemVo();
        itemVo.setId(firstOrgInfo.getId().toString());
        itemVo.setName(firstOrgInfo.getName());
        itemVo.setLevel(new Integer(firstOrgInfo.getLevel()));
        ItemTreeNode itemTreeNode = new ItemTreeNode();
        itemTreeNode.setItemTypeVo(itemTypeVo);
        itemTreeNode.setItemVo(itemVo);
        itemTreeNode.setLeaf(false);
        list.add(itemTreeNode);
        trees = JSONArray.fromObject(list);
        return trees;
    }

    public static String getOrgByOrgID(Context ctx, String orgId) {
        String trees = "null";
        FullOrgUnitCollection children = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)orgId));
        filter.getFilterItems().add(new FilterItemInfo("isadminorgunit", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        try {
            children = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        ArrayList<ItemTreeNode> list = new ArrayList<ItemTreeNode>();
        for (int i = children.size() - 1; i >= 0; --i) {
            FullOrgUnitInfo child = children.get(i);
            ItemTypeVo itemTypeVo = new ItemTypeVo();
            itemTypeVo.setName(child.getName());
            ItemVo itemVo = new ItemVo();
            itemVo.setId(child.getId().toString());
            itemVo.setName(child.getName());
            itemVo.setLevel(new Integer(child.getLevel()));
            ItemTreeNode itemTreeNode = new ItemTreeNode();
            itemTreeNode.setItemTypeVo(itemTypeVo);
            itemTreeNode.setItemVo(itemVo);
            itemTreeNode.setLeaf(child.isIsLeaf());
            list.add(itemTreeNode);
        }
        trees = JSONArray.fromObject(list);
        return trees;
    }

    public static String getAllDashBoards(Context ctx, HttpServletRequest request) {
        BIDashboardTreeCollection dashBoardInfos = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        String dashBoards = "null";
        ArrayList<DashBoard> l = new ArrayList<DashBoard>();
        try {
            Repository rep = BISystem.getRepository(request);
            dashBoardInfos = BIDashboardTreeFactory.getLocalInstance((Context)ctx).getBIDashboardTreeCollection(view);
            for (int i = 0; i < dashBoardInfos.size(); ++i) {
                DashBoard d = new DashBoard();
                d.setNo(dashBoardInfos.get(i).getNumber());
                d.setDashboardId(dashBoardInfos.get(i).getId().toString());
                d.setDashboardName(dashBoardInfos.get(i).getName());
                d.setCreator(MetaData_EAS.getTree_Creator(5, rep, dashBoardInfos.get(i).getId().toString()));
                d.setModifiedBy(dashBoardInfos.get(i).getLastUpdateUser().getName());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:ss a");
                d.setCreatoDate(df.format(dashBoardInfos.get(i).getCreateTime()));
                d.setModifiedDate(df.format(dashBoardInfos.get(i).getLastUpdateTime()));
                l.add(d);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dashBoards = JSONArray.fromObject(l);
        return dashBoards;
    }

    public static String getDashBoardsByDiretoryID(Context ctx, String DiretoryID, HttpServletRequest request) {
        BIDashboardTreeCollection dashBoardInfos = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        if (DiretoryID.equalsIgnoreCase("dashboard_tree")) {
            DiretoryID = null;
        }
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)DiretoryID));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        String dashBoards = "null";
        ArrayList<DashBoard> l = new ArrayList<DashBoard>();
        try {
            Repository rep = BISystem.getRepository(request);
            dashBoardInfos = BIDashboardTreeFactory.getLocalInstance((Context)ctx).getBIDashboardTreeCollection(view);
            if (dashBoardInfos != null) {
                for (int i = 0; i < dashBoardInfos.size(); ++i) {
                    DashBoard d = new DashBoard();
                    BIDashboardTreeInfo dashBoardTreeInfo = new BIDashboardTreeInfo();
                    dashBoardTreeInfo = dashBoardInfos.get(i);
                    d.setDashboardId(dashBoardTreeInfo.getId().toString());
                    d.setDashboardName(dashBoardTreeInfo.getName());
                    d.setCreator(MetaData_EAS.getTree_Creator(5, rep, dashBoardTreeInfo.getId().toString()));
                    d.setModifiedBy(MetaData_EAS.getTree_LastUpdateUser(5, rep, dashBoardTreeInfo.getId().toString()));
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:ss a");
                    d.setCreatoDate(df.format(dashBoardTreeInfo.getCreateTime()));
                    d.setModifiedDate(df.format(dashBoardTreeInfo.getLastUpdateTime()));
                    l.add(d);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dashBoards = JSONArray.fromObject(l);
        return dashBoards;
    }

    public static String getFirsLevelDiretory() {
        String trees = "null";
        ArrayList<ItemTreeNode> list = new ArrayList<ItemTreeNode>();
        for (int i = 0; i < 1; ++i) {
            ItemTypeVo itemTypeVo = new ItemTypeVo();
            itemTypeVo.setName("\u4eea\u8868\u677f\u6587\u4ef6");
            ItemVo itemVo = new ItemVo();
            itemVo.setId("dashboard_tree");
            itemVo.setName("\u4eea\u8868\u677f\u6587\u4ef6");
            itemVo.setLevel(new Integer("0"));
            ItemTreeNode itemTreeNode = new ItemTreeNode();
            itemTreeNode.setItemTypeVo(itemTypeVo);
            itemTreeNode.setItemVo(itemVo);
            itemTreeNode.setLeaf(false);
            list.add(itemTreeNode);
        }
        trees = JSONArray.fromObject(list);
        return trees;
    }

    public static String getDashboardDiretoryByDiretoryID(Context ctx, String DiretoryID) {
        BIDashboardTreeCollection dashBoardDiretorys = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        if (DiretoryID.equalsIgnoreCase("dashboard_tree")) {
            DiretoryID = null;
        }
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)DiretoryID));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"0", CompareType.EQUALS));
        view.setFilter(filter);
        try {
            dashBoardDiretorys = BIDashboardTreeFactory.getLocalInstance((Context)ctx).getBIDashboardTreeCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        String trees = "null";
        ArrayList<ItemTreeNode> list = new ArrayList<ItemTreeNode>();
        if (dashBoardDiretorys != null) {
            for (int i = 0; i < dashBoardDiretorys.size(); ++i) {
                ItemTypeVo itemTypeVo = new ItemTypeVo();
                itemTypeVo.setName(dashBoardDiretorys.get(i).getName());
                ItemVo itemVo = new ItemVo();
                itemVo.setId(dashBoardDiretorys.get(i).getId().toString());
                itemVo.setName(dashBoardDiretorys.get(i).getName());
                itemVo.setLevel(new Integer(dashBoardDiretorys.get(i).getLevel()));
                ItemTreeNode itemTreeNode = new ItemTreeNode();
                itemTreeNode.setItemTypeVo(itemTypeVo);
                itemTreeNode.setItemVo(itemVo);
                itemTreeNode.setLeaf(false);
                list.add(itemTreeNode);
            }
        }
        trees = JSONArray.fromObject(list);
        return trees;
    }

    public static String getUserPermissions_dg(Context ctx, HttpServletRequest request, String userIds, String dashboardIds, String orgId) {
        ArrayList<UserPermissions_dg> list = new ArrayList<UserPermissions_dg>();
        int start = 0;
        int length = 1000;
        String retConditionStr = "fRoleid is null";
        String[] userIdArray = userIds.split("#");
        String[] dashBoardIdArray = dashboardIds.split("#");
        MetaDataPK mPK = new MetaDataPK("com.kingdee.eas.framework.bireport.app.BIDashboardQuery");
        BOSObjectType bosBizType = new BIDashboardTreeInfo().getBOSType();
        ObjectStringPK orgPK = new ObjectStringPK(orgId);
        try {
            IDiscretePermission iDiscretePerm = DiscretePermissionFactory.getLocalInstance((Context)ctx);
            IPermItem ipermItem = PermItemFactory.getLocalInstance((Context)ctx);
            int n = 1;
            for (int i = 0; i < userIdArray.length; ++i) {
                ObjectStringPK userPK = new ObjectStringPK(userIdArray[i]);
                for (int j = 0; j < dashBoardIdArray.length; ++j) {
                    ObjectStringPK dashBoardPK = new ObjectStringPK(dashBoardIdArray[j]);
                    IRowSet rows = iDiscretePerm.getUserDiscretePermByQuery((IMetaDataPK)mPK, bosBizType, (IObjectPK)userPK, (IObjectPK)orgPK, null, null, (IObjectPK)dashBoardPK, start, length, retConditionStr, true);
                    UserPermissions_dg oldUserPermission_dg = null;
                    while (rows.next()) {
                        int no = n;
                        String creatorName = rows.getString("CREATOR.NAME");
                        String userNumber = rows.getString("FUSERNUMBER");
                        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(userNumber);
                        String userId = userInfo.getId().toString();
                        String dashBoardId = rows.getString("ID");
                        String dashBoardName = rows.getString("NAME");
                        String adminOrgId = rows.getString("FDORGID");
                        String adminOrgName = rows.getString("FORGNAME");
                        String permissionId = rows.getString("FDPERMITEMID");
                        PermItemInfo permItemInfo = ipermItem.getPermItemInfo((IObjectPK)new ObjectStringPK(permissionId));
                        String createTime = rows.getString("CREATETIME").substring(0, 16);
                        String lastUpdateTime = rows.getString("LASTUPDATETIME").substring(0, 16);
                        UserPermissions_dg userPermission_dg = new UserPermissions_dg();
                        if (oldUserPermission_dg != null && oldUserPermission_dg.getCreator().equals(creatorName) && oldUserPermission_dg.getUserId().equals(userId) && oldUserPermission_dg.getDashboardId().equals(dashBoardId) && oldUserPermission_dg.getAdminOrgId().equals(adminOrgId) && oldUserPermission_dg.getCreatoDate().equals(createTime) && oldUserPermission_dg.getModifiedDate().equals(lastUpdateTime)) {
                            if (permItemInfo.getNumber().equals("bi_dashboard_config")) {
                                oldUserPermission_dg.setSelectedView(true);
                            } else if (permItemInfo.getNumber().equals("bi_dashboard_design")) {
                                oldUserPermission_dg.setSelectedEdit(true);
                            }
                            list.remove(list.size() - 1);
                            list.add(oldUserPermission_dg);
                            continue;
                        }
                        userPermission_dg.setNo(no + "");
                        userPermission_dg.setUserId(userId);
                        userPermission_dg.setUser(DashBoardAuthorized.checkAndReplace(userNumber));
                        userPermission_dg.setDashboardId(dashBoardId);
                        userPermission_dg.setDashboard(DashBoardAuthorized.checkAndReplace(dashBoardName));
                        userPermission_dg.setAdminOrgId(adminOrgId);
                        userPermission_dg.setAdminOrg(DashBoardAuthorized.checkAndReplace(adminOrgName));
                        userPermission_dg.setCreator(DashBoardAuthorized.checkAndReplace(creatorName));
                        userPermission_dg.setCreatoDate(createTime);
                        userPermission_dg.setModifiedDate(lastUpdateTime);
                        if (permItemInfo.getNumber().equals("bi_dashboard_config")) {
                            userPermission_dg.setSelectedView(true);
                        } else if (permItemInfo.getNumber().equals("bi_dashboard_design")) {
                            userPermission_dg.setSelectedEdit(true);
                        }
                        list.add(userPermission_dg);
                        oldUserPermission_dg = userPermission_dg;
                        ++n;
                    }
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return "\u83b7\u53d6\u7528\u6237\u6743\u9650\u51fa\u9519\uff01" + e.getMessage();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return "\u83b7\u53d6\u7528\u6237\u6743\u9650\u51fa\u9519\uff01" + e.getMessage();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "\u83b7\u53d6\u7528\u6237\u6743\u9650\u51fa\u9519\uff01" + e.getMessage();
        }
        return JSONArray.fromObject(list);
    }

    public static String getRolePermissions_dg(Context ctx, HttpServletRequest request, String roleIds, String dashboardIds) {
        ArrayList<RolePermissions_dg> list = new ArrayList<RolePermissions_dg>();
        int start = 0;
        int length = 1000;
        String retConditionStr = "fRoleid is not null";
        String[] roleIdArray = roleIds.split("#");
        String[] dashBoardIdArray = dashboardIds.split("#");
        MetaDataPK mPK = new MetaDataPK("com.kingdee.eas.framework.bireport.app.BIDashboardQuery");
        BOSObjectType bosBizType = new BIDashboardTreeInfo().getBOSType();
        try {
            IDiscretePermission iDiscretePerm = DiscretePermissionFactory.getLocalInstance((Context)ctx);
            IPermItem ipermItem = PermItemFactory.getLocalInstance((Context)ctx);
            int n = 1;
            for (int i = 0; i < roleIdArray.length; ++i) {
                ObjectStringPK rolePK = new ObjectStringPK(roleIdArray[i]);
                for (int j = 0; j < dashBoardIdArray.length; ++j) {
                    ObjectStringPK dashBoardPK = new ObjectStringPK(dashBoardIdArray[j]);
                    IRowSet rows = iDiscretePerm.getUserDiscretePermByQuery((IMetaDataPK)mPK, bosBizType, null, null, (IObjectPK)rolePK, null, (IObjectPK)dashBoardPK, start, length, retConditionStr, true);
                    RolePermissions_dg oldRolePermission_dg = null;
                    while (rows.next()) {
                        int no = n;
                        String creatorName = rows.getString("CREATOR.NAME");
                        String roleId = rows.getString("FDROELID");
                        String roleName = rows.getString("FDROELNAME");
                        String dashBoardId = rows.getString("ID");
                        String dashBoardName = rows.getString("NAME");
                        String permissionId = rows.getString("FDPERMITEMID");
                        PermItemInfo permItemInfo = ipermItem.getPermItemInfo((IObjectPK)new ObjectStringPK(permissionId));
                        String createTime = rows.getString("CREATETIME").substring(0, 16);
                        String lastUpdateTime = rows.getString("LASTUPDATETIME").substring(0, 16);
                        RolePermissions_dg rolePermission_dg = new RolePermissions_dg();
                        if (oldRolePermission_dg != null && oldRolePermission_dg.getCreator().equals(creatorName) && oldRolePermission_dg.getRoleId().equals(roleId) && oldRolePermission_dg.getDashboardId().equals(dashBoardId) && oldRolePermission_dg.getCreatoDate().equals(createTime) && oldRolePermission_dg.getModifiedDate().equals(lastUpdateTime)) {
                            if (permItemInfo.getNumber().equals("bi_dashboard_config")) {
                                oldRolePermission_dg.setSelectedView(true);
                            } else if (permItemInfo.getNumber().equals("bi_dashboard_design")) {
                                oldRolePermission_dg.setSelectedEdit(true);
                            }
                            list.remove(list.size() - 1);
                            list.add(oldRolePermission_dg);
                            continue;
                        }
                        rolePermission_dg.setNo(no + "");
                        rolePermission_dg.setRoleId(roleId);
                        rolePermission_dg.setRole(DashBoardAuthorized.checkAndReplace(roleName));
                        rolePermission_dg.setDashboardId(dashBoardId);
                        rolePermission_dg.setDashboard(DashBoardAuthorized.checkAndReplace(dashBoardName));
                        rolePermission_dg.setCreator(DashBoardAuthorized.checkAndReplace(creatorName));
                        rolePermission_dg.setCreatoDate(createTime);
                        rolePermission_dg.setModifiedDate(lastUpdateTime);
                        if (permItemInfo.getNumber().equals("bi_dashboard_config")) {
                            rolePermission_dg.setSelectedView(true);
                        } else if (permItemInfo.getNumber().equals("bi_dashboard_design")) {
                            rolePermission_dg.setSelectedEdit(true);
                        }
                        list.add(rolePermission_dg);
                        oldRolePermission_dg = rolePermission_dg;
                        ++n;
                    }
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return "\u83b7\u53d6\u89d2\u8272\u6743\u9650\u51fa\u9519\uff01" + e.getMessage();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return "\u83b7\u53d6\u89d2\u8272\u6743\u9650\u51fa\u9519\uff01" + e.getMessage();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return "\u83b7\u53d6\u89d2\u8272\u6743\u9650\u51fa\u9519\uff01" + e.getMessage();
        }
        return JSONArray.fromObject(list);
    }

    public static String saveUserAuthorized(String allParams, Context ctx) {
        if (allParams != null && !allParams.trim().equals("")) {
            HashMap addDiscretePerms = new HashMap();
            HashMap removeDiscretePerms = new HashMap();
            HashMap<String, DiscretePermCollection> updateDiscretePerms = new HashMap<String, DiscretePermCollection>();
            IDiscretePermission idiscretePermission = null;
            try {
                idiscretePermission = DiscretePermissionFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            String[] userPerm = allParams.split("@");
            String[] dashBoardIds = userPerm[0].split("#");
            String[] userIds = userPerm[1].split("#");
            String orgId = userPerm[2];
            String view = userPerm[3];
            String edit = userPerm[4];
            FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
            fullOrgUnitInfo.setId(BOSUuid.read((String)orgId));
            BOSObjectType bizObjectType = new BIDashboardTreeInfo().getBOSType();
            for (int i = 0; i < dashBoardIds.length; ++i) {
                String dashBoardId = dashBoardIds[i];
                for (int j = 0; j < userIds.length; ++j) {
                    String userId = userIds[j];
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)userId));
                    DiscretePermCollection updatePerms = new DiscretePermCollection();
                    PermItemCollection permItems = DashBoardAuthorized.getDashBoardPermission(ctx);
                    for (int k = 0; k < permItems.size(); ++k) {
                        PermItemInfo permItemInfo = permItems.get(k);
                        DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                        discretePermInfo.setUser(userInfo);
                        discretePermInfo.setOrg(fullOrgUnitInfo);
                        discretePermInfo.setBizDataID(BOSUuid.read((String)dashBoardId));
                        if (view.equals("true") && permItemInfo.getNumber().equals("bi_dashboard_config")) {
                            discretePermInfo.setPermItemInfo(permItemInfo);
                            updatePerms.add(discretePermInfo);
                        }
                        if (!edit.equals("true") || !permItemInfo.getNumber().equals("bi_dashboard_design")) continue;
                        discretePermInfo.setPermItemInfo(permItemInfo);
                        updatePerms.add(discretePermInfo);
                    }
                    updateDiscretePerms.put(dashBoardId, updatePerms);
                    DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                    discretePermInfo.setUser(userInfo);
                    discretePermInfo.setOrg(fullOrgUnitInfo);
                    DiscretePermCollection[] ddps = DashBoardAuthorized.getDPResult(addDiscretePerms, removeDiscretePerms, updateDiscretePerms, discretePermInfo);
                    try {
                        idiscretePermission.saveDiscretePerms(bizObjectType, ddps);
                        continue;
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                        return "\u4fdd\u5b58\u6743\u9650\u51fa\u9519:" + e.getMessage();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                        return "\u4fdd\u5b58\u6743\u9650\u51fa\u9519:" + e.getMessage();
                    }
                }
            }
            return "\u4fdd\u5b58\u6743\u9650\u6210\u529f\uff01";
        }
        return "\u524d\u6bb5\u4f20\u56de\u6570\u636e\u4e3a\u7a7a\uff01";
    }

    public static String saveRoleAuthorized(String allParams, Context ctx) {
        if (allParams != null && !allParams.trim().equals("")) {
            HashMap addDiscretePerms = new HashMap();
            HashMap removeDiscretePerms = new HashMap();
            HashMap<String, DiscretePermCollection> updateDiscretePerms = new HashMap<String, DiscretePermCollection>();
            IDiscretePermission idiscretePermission = null;
            try {
                idiscretePermission = DiscretePermissionFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            String[] rolePerm = allParams.split("@");
            String[] dashBoardIds = rolePerm[0].split("#");
            String[] roleIds = rolePerm[1].split("#");
            String view = rolePerm[2];
            String edit = rolePerm[3];
            BOSObjectType bizObjectType = new BIDashboardTreeInfo().getBOSType();
            for (int i = 0; i < dashBoardIds.length; ++i) {
                String dashBoardId = dashBoardIds[i];
                for (int j = 0; j < roleIds.length; ++j) {
                    String roleId = roleIds[j];
                    RoleInfo roleInfo = new RoleInfo();
                    roleInfo.setId(BOSUuid.read((String)roleId));
                    DiscretePermCollection updatePerms = new DiscretePermCollection();
                    PermItemCollection permItems = DashBoardAuthorized.getDashBoardPermission(ctx);
                    for (int k = 0; k < permItems.size(); ++k) {
                        PermItemInfo permItemInfo = permItems.get(k);
                        DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                        discretePermInfo.setRole(roleInfo);
                        discretePermInfo.setBizDataID(BOSUuid.read((String)dashBoardId));
                        if (view.equals("true") && permItemInfo.getNumber().equals("bi_dashboard_config")) {
                            discretePermInfo.setPermItemInfo(permItemInfo);
                            updatePerms.add(discretePermInfo);
                        }
                        if (!edit.equals("true") || !permItemInfo.getNumber().equals("bi_dashboard_design")) continue;
                        discretePermInfo.setPermItemInfo(permItemInfo);
                        updatePerms.add(discretePermInfo);
                    }
                    updateDiscretePerms.put(dashBoardId, updatePerms);
                    DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                    discretePermInfo.setRole(roleInfo);
                    DiscretePermCollection[] ddps = DashBoardAuthorized.getDPResult(addDiscretePerms, removeDiscretePerms, updateDiscretePerms, discretePermInfo);
                    try {
                        idiscretePermission.saveDiscretePerms(bizObjectType, ddps);
                        continue;
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                        return "\u4fdd\u5b58\u6743\u9650\u51fa\u9519:" + e.getMessage();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                        return "\u4fdd\u5b58\u6743\u9650\u51fa\u9519:" + e.getMessage();
                    }
                }
            }
            return "\u4fdd\u5b58\u6743\u9650\u6210\u529f\uff01";
        }
        return "\u524d\u7aef\u4f20\u56de\u6570\u636e\u4e3a\u7a7a\uff01";
    }

    public static String saveRightsManagement(String userPermissionDatas, String rolePermissionDatas, Context ctx) {
        int i;
        HashMap addDiscretePerms = new HashMap();
        HashMap<String, DiscretePermCollection> removeDiscretePerms = new HashMap<String, DiscretePermCollection>();
        HashMap<String, DiscretePermCollection> updateDiscretePerms = new HashMap<String, DiscretePermCollection>();
        IDiscretePermission idiscretePermission = null;
        try {
            idiscretePermission = DiscretePermissionFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        BOSObjectType bizObjectType = new BIDashboardTreeInfo().getBOSType();
        PermItemCollection permItems = DashBoardAuthorized.getDashBoardPermission(ctx);
        if (!userPermissionDatas.equals("") && userPermissionDatas != null) {
            String[] userPermDatas = userPermissionDatas.split("@");
            for (i = 0; i < userPermDatas.length; ++i) {
                try {
                    String[] userPerms = userPermDatas[i].split("#");
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)userPerms[0]));
                    FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                    fullOrgUnitInfo.setId(BOSUuid.read((String)userPerms[2]));
                    String dashBoardId = userPerms[1];
                    String view = userPerms[3];
                    String edit = userPerms[4];
                    DiscretePermCollection userUpdatePerms = new DiscretePermCollection();
                    DiscretePermCollection userDeletePerms = new DiscretePermCollection();
                    for (int k = 0; k < permItems.size(); ++k) {
                        PermItemInfo permItemInfo = permItems.get(k);
                        DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                        discretePermInfo.setUser(userInfo);
                        discretePermInfo.setOrg(fullOrgUnitInfo);
                        discretePermInfo.setBizDataID(BOSUuid.read((String)dashBoardId));
                        if (view.equals("false") && edit.equals("false")) {
                            discretePermInfo.setPermItemInfo(permItemInfo);
                            userDeletePerms.add(discretePermInfo);
                            continue;
                        }
                        if (view.equals("true") && permItemInfo.getNumber().equals("bi_dashboard_config")) {
                            discretePermInfo.setPermItemInfo(permItemInfo);
                            userUpdatePerms.add(discretePermInfo);
                            continue;
                        }
                        if (!edit.equals("true") || !permItemInfo.getNumber().equals("bi_dashboard_design")) continue;
                        discretePermInfo.setPermItemInfo(permItemInfo);
                        userUpdatePerms.add(discretePermInfo);
                    }
                    updateDiscretePerms.put(dashBoardId, userUpdatePerms);
                    removeDiscretePerms.put(dashBoardId, userDeletePerms);
                    DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                    discretePermInfo.setUser(userInfo);
                    discretePermInfo.setOrg(fullOrgUnitInfo);
                    DiscretePermCollection[] userDdps = DashBoardAuthorized.getDPResult(addDiscretePerms, removeDiscretePerms, updateDiscretePerms, discretePermInfo);
                    idiscretePermission.saveDiscretePerms(bizObjectType, userDdps);
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    return "\u7528\u6237\u4fdd\u5b58\u6743\u9650\u51fa\u9519:" + e.getMessage();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    return "\u7528\u6237\u4fdd\u5b58\u6743\u9650\u51fa\u9519:" + e.getMessage();
                }
            }
        }
        if (!rolePermissionDatas.trim().equals("") && rolePermissionDatas != null) {
            updateDiscretePerms.clear();
            String[] rolePermDatas = rolePermissionDatas.split("@");
            for (i = 0; i < rolePermDatas.length; ++i) {
                try {
                    String[] rolePerms = rolePermDatas[i].split("#");
                    RoleInfo roleInfo = new RoleInfo();
                    roleInfo.setId(BOSUuid.read((String)rolePerms[0]));
                    String dashBoardId = rolePerms[1];
                    String view = rolePerms[2];
                    String edit = rolePerms[3];
                    DiscretePermCollection roleUpdatePerms = new DiscretePermCollection();
                    DiscretePermCollection roleDeletePerms = new DiscretePermCollection();
                    for (int k = 0; k < permItems.size(); ++k) {
                        PermItemInfo permItemInfo = permItems.get(k);
                        DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                        discretePermInfo.setRole(roleInfo);
                        discretePermInfo.setBizDataID(BOSUuid.read((String)dashBoardId));
                        if (view.equals("false") && view.equals("false")) {
                            discretePermInfo.setPermItemInfo(permItemInfo);
                            roleDeletePerms.add(discretePermInfo);
                            continue;
                        }
                        if (view.equals("true") && permItemInfo.getNumber().equals("bi_dashboard_config")) {
                            discretePermInfo.setPermItemInfo(permItemInfo);
                            roleUpdatePerms.add(discretePermInfo);
                        }
                        if (!edit.equals("true") || !permItemInfo.getNumber().equals("bi_dashboard_design")) continue;
                        discretePermInfo.setPermItemInfo(permItemInfo);
                        roleUpdatePerms.add(discretePermInfo);
                    }
                    updateDiscretePerms.put(dashBoardId, roleUpdatePerms);
                    removeDiscretePerms.put(dashBoardId, roleDeletePerms);
                    DiscretePermInfo discretePermInfo = new DiscretePermInfo();
                    discretePermInfo.setRole(roleInfo);
                    DiscretePermCollection[] roleDdps = DashBoardAuthorized.getDPResult(addDiscretePerms, removeDiscretePerms, updateDiscretePerms, discretePermInfo);
                    idiscretePermission.saveDiscretePerms(bizObjectType, roleDdps);
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    return "\u89d2\u8272\u4fdd\u5b58\u6743\u9650\u51fa\u9519:" + e.getMessage();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                    return "\u89d2\u8272\u4fdd\u5b58\u6743\u9650\u51fa\u9519:" + e.getMessage();
                }
            }
        }
        return "\u6743\u9650\u4fdd\u5b58\u6210\u529f\uff01";
    }

    private static PermItemCollection getDashBoardPermission(Context ctx) {
        PermItemCollection permItems = null;
        try {
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            Set permItemNames = (Set)iPermission.getConfigurationInfo().getDiscretEntityPermItems().get(new BIDashboardTreeInfo().getBOSType().toString());
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet(permItemNames), CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("enableDataPermission", (Object)new Integer(1)));
            entityViewInfo.setFilter(filterInfo);
            IPermItem iPermItem = PermItemFactory.getLocalInstance((Context)ctx);
            permItems = iPermItem.getPermItemCollection(entityViewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return permItems;
    }

    private static DiscretePermCollection[] getDPResult(Map addDiscretePerms, Map removeDiscretePerms, Map updateDiscretePerms, DiscretePermInfo discretePermInfo) {
        DiscretePermCollection[] ddps = new DiscretePermCollection[]{new DiscretePermCollection(), new DiscretePermCollection(), new DiscretePermCollection(), new DiscretePermCollection()};
        for (DiscretePermCollection item : addDiscretePerms.values()) {
            ddps[0].addCollection(item);
        }
        for (DiscretePermCollection item : removeDiscretePerms.values()) {
            ddps[1].addCollection(item);
        }
        for (DiscretePermCollection item : updateDiscretePerms.values()) {
            ddps[2].addCollection(item);
        }
        ddps[3].add(discretePermInfo);
        return ddps;
    }

    private static boolean check(String str, String flage) {
        Pattern p;
        Matcher m;
        boolean match;
        return str == null || !(match = (m = (p = Pattern.compile(flage)).matcher(str)).find());
    }

    private static String checkAndReplace(String target) {
        if (target == null) {
            return target;
        }
        if (!DashBoardAuthorized.check(target, "\"")) {
            target = StringUtils.replace((String)target, (String)"\"", (String)"\\\"");
        }
        if (!DashBoardAuthorized.check(target, "\n")) {
            target = StringUtil.replace((String)target, (String)"\n", (String)"");
        }
        if (!DashBoardAuthorized.check(target, "\t")) {
            target = StringUtil.replace((String)target, (String)"\t", (String)"");
        }
        return target;
    }
}

