/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.export;

import com.kingdee.bos.ctrl.analysis.web.export.ExportTypeNotFoundException;

public class ExportType {
    public static String TYPE_PDF = "pdf";
    public static String TYPE_EXCEL = "excel";
    public static String TYPE_EXCEL2007 = "excel2007";
    public static String TYPE_ZIP = "zip";
    public static String TYPE_IMAGE_PNG = "png";
    public static String TYPE_IMAGE_JPEG = "jpg";
    public static String TYPE_IMAGE_GIF = "gif";
    public static String TYPE_IMAGE_TIFF = "tif";
    public static String TYPE_IMAGE_BMP = "bmp";
    private static String SUFFIX_PDF = "pdf";
    private static String SUFFIX_EXCEL = "xls";
    private static String SUFFIX_IMAGE_PNG = "png";
    private static String SUFFIX_IMAGE_JPEG = "jpg";
    private static String SUFFIX_IMAGE_JPEG2 = "jpeg";
    private static String SUFFIX_IMAGE_GIF = "gif";
    private static String SUFFIX_IMAGE_TIFF = "tif";
    private static String SUFFIX_IMAGE_TIFF2 = "tiff";
    private static String SUFFIX_IMAGE_BMP = "bmp";
    private static String SUFFIX_ZIP = "zip";
    private static String MINE_TYPE_ZIP = "application/zip";
    private static String MINE_TYPE_PDF = "application/pdf";
    private static String MINE_TYPE_EXCEL = "application/vnd.ms-excel";
    private static String MINE_TYPE_IMAGE_PNG = "image/png";
    private static String MINE_TYPE_IMAGE_JPEG = "image/jpeg";
    private static String MINE_TYPE_IMAGE_GIF = "image/gif";
    private static String MINE_TYPE_IMAGE_TIFF = "image/tiff";
    private static String MINE_TYPE_IMAGE_BMP = "image/x-xbitmap";

    public static String parseTypeFromSuffix(String suffix) {
        String ret = suffix;
        if (SUFFIX_IMAGE_JPEG2.equalsIgnoreCase(suffix)) {
            ret = TYPE_IMAGE_JPEG;
        } else if (SUFFIX_IMAGE_TIFF2.equalsIgnoreCase(suffix)) {
            ret = TYPE_IMAGE_TIFF;
        }
        return ret;
    }

    public static String findFileSuffix(String type) throws ExportTypeNotFoundException {
        if (TYPE_PDF.equalsIgnoreCase(type)) {
            return SUFFIX_PDF;
        }
        if (TYPE_EXCEL.equalsIgnoreCase(type)) {
            return SUFFIX_EXCEL;
        }
        if (TYPE_IMAGE_PNG.equalsIgnoreCase(type)) {
            return SUFFIX_IMAGE_PNG;
        }
        if (TYPE_IMAGE_JPEG.equalsIgnoreCase(type)) {
            return SUFFIX_IMAGE_JPEG;
        }
        if (TYPE_IMAGE_GIF.equalsIgnoreCase(type)) {
            return SUFFIX_IMAGE_GIF;
        }
        if (TYPE_IMAGE_TIFF.equalsIgnoreCase(type)) {
            return SUFFIX_IMAGE_TIFF;
        }
        if (TYPE_IMAGE_BMP.equalsIgnoreCase(type)) {
            return SUFFIX_IMAGE_BMP;
        }
        if (TYPE_ZIP.equalsIgnoreCase(type)) {
            return SUFFIX_ZIP;
        }
        throw new ExportTypeNotFoundException("not support exportType " + type + " !");
    }

    public static String findMimeType(String type) throws ExportTypeNotFoundException {
        if (TYPE_PDF.equalsIgnoreCase(type)) {
            return MINE_TYPE_PDF;
        }
        if (TYPE_EXCEL.equalsIgnoreCase(type) || TYPE_EXCEL2007.equalsIgnoreCase(type)) {
            return MINE_TYPE_EXCEL;
        }
        if (TYPE_IMAGE_PNG.equalsIgnoreCase(type)) {
            return MINE_TYPE_IMAGE_PNG;
        }
        if (TYPE_IMAGE_JPEG.equalsIgnoreCase(type)) {
            return MINE_TYPE_IMAGE_JPEG;
        }
        if (TYPE_IMAGE_GIF.equalsIgnoreCase(type)) {
            return MINE_TYPE_IMAGE_GIF;
        }
        if (TYPE_IMAGE_TIFF.equalsIgnoreCase(type)) {
            return MINE_TYPE_IMAGE_TIFF;
        }
        if (TYPE_IMAGE_BMP.equalsIgnoreCase(type)) {
            return MINE_TYPE_IMAGE_BMP;
        }
        if (TYPE_ZIP.equalsIgnoreCase(type)) {
            return MINE_TYPE_ZIP;
        }
        throw new ExportTypeNotFoundException("not support exportType " + type + " !");
    }
}

