/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public enum Browser {
    IE6("IE"),
    IE7("IE"),
    IE8("IE"),
    IE9("IE"),
    FIREFOX("\u706b\u72d0"),
    CHROME("\u8c37\u6b4c"),
    OPERA("\u632a\u5a01"),
    SAFARI("\u82f9\u679c");

    private final String description;
    private static ThreadLocal<HttpServletRequest> cache;

    private Browser(String description) {
        this.description = description;
    }

    public String toString() {
        return this.name() + ": " + this.description;
    }

    public static Browser valueOfIgnoreCase(String browser) {
        if (StringUtils.isBlank((String)browser)) {
            throw new IllegalArgumentException("unknown resource type!");
        }
        browser = StringUtils.upperCase((String)browser);
        return Browser.valueOf(browser);
    }

    private static String getUserAgent() {
        return cache.get().getHeader("User-Agent");
    }

    public static void setCurrentRequest(HttpServletRequest request) {
        cache.set(request);
    }

    public static Browser getCurrentBrowser() {
        String ua = Browser.getUserAgent();
        if (ua == null) {
            return null;
        }
        if ((ua = ua.toLowerCase()).contains("msie 6.0")) {
            return IE6;
        }
        if (ua.contains("msie 7.0")) {
            return IE7;
        }
        if (ua.contains("msie 8.0")) {
            return IE8;
        }
        if (ua.contains("msie 9.0")) {
            return IE9;
        }
        if (ua.contains("chrome")) {
            return CHROME;
        }
        if (ua.contains("safari")) {
            return SAFARI;
        }
        if (ua.contains("firefox")) {
            return FIREFOX;
        }
        if (ua.contains("opera")) {
            return OPERA;
        }
        return null;
    }

    public static boolean browserBelowIE9() {
        return IE6.equals((Object)Browser.getCurrentBrowser()) || IE7.equals((Object)Browser.getCurrentBrowser()) || IE8.equals((Object)Browser.getCurrentBrowser());
    }

    static {
        cache = new ThreadLocal();
    }
}

