/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext.mp.handler;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONString;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.lic.EXTLicenseAgent;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.lic.ExtLicenseException;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.service.ExtReportService;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.service.MyFolderService;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.service.SubSystemService;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.MyFolderNodeVO;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.SubSystemNodeVO;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ExtServletHandler {
    private static final Logger logger = CommonLogger.getLogger(ExtServletHandler.class);
    private static MyFolderService myFolderService = new MyFolderService();
    private static ExtReportService extReportService = new ExtReportService();

    public static void writeOut(HttpServletResponse response, String ret) throws IOException {
        PrintWriter out = response.getWriter();
        out.print(ret);
        out.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handler(HttpServletRequest request, HttpServletResponse response) throws BIReportException {
        response.setContentType("application/x-www-form-urlencoded");
        String action = request.getParameter("action");
        if ("getExtReportList".equals(action)) {
            String whichType = request.getParameter("whichType");
            if ("SubSystemType".equals(whichType)) {
                try {
                    String json = extReportService.queryReportsByOrgAndCreator(request);
                    try {
                        ExtServletHandler.writeOut(response, json);
                        return;
                    }
                    catch (IOException e) {
                        logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
                    }
                    return;
                }
                catch (BIReportException e) {
                    logger.warn((Object)"\u83b7\u5f97\u62a5\u8868\u5217\u8868\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            } else {
                if (!"MyFolderType".equals(whichType)) return;
                try {
                    String json = extReportService.queryReportsByMyFolderID(request);
                    try {
                        ExtServletHandler.writeOut(response, json);
                        return;
                    }
                    catch (IOException e) {
                        logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
                    }
                    return;
                }
                catch (BIReportException e) {
                    logger.warn((Object)"\u83b7\u5f97\u62a5\u8868\u5217\u8868\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            }
        }
        if ("getSubSystemTree".equals(action)) {
            try {
                SubSystemNodeVO root = SubSystemService.getPackageTreeModel(request);
                String json = root.toString();
                try {
                    ExtServletHandler.writeOut(response, json);
                    return;
                }
                catch (IOException e) {
                    logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                logger.warn((Object)"\u83b7\u5f97\u5b50\u7cfb\u7edf\u7ed3\u6784\u5931\u8d25", (Throwable)e);
                throw new BIReportException(e);
            }
        }
        if ("buildMyFolderTree".equals(action)) {
            MyFolderNodeVO root = null;
            try {
                root = myFolderService.buildMyFolderTree(request, true);
                String json = root.toString();
                try {
                    ExtServletHandler.writeOut(response, json);
                    return;
                }
                catch (IOException e) {
                    logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
                    throw new BIReportException(e);
                }
            }
            catch (BIReportException e1) {
                logger.warn((Object)"\u6784\u5efa\u6211\u7684\u6587\u4ef6\u5939\u6811\u5931\u8d25", (Throwable)e1);
                throw e1;
            }
        }
        if ("getMyFolderTreeModel".equals(action)) {
            MyFolderNodeVO root = null;
            try {
                root = myFolderService.buildMyFolderTree(request, false);
                String json = root.toString();
                try {
                    ExtServletHandler.writeOut(response, json);
                    return;
                }
                catch (IOException e) {
                    logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
                    throw new BIReportException(e);
                }
            }
            catch (BIReportException e1) {
                logger.warn((Object)"\u83b7\u5f97\u6211\u7684\u6587\u4ef6\u5939\u6811\u6a21\u578b\u5931\u8d25", (Throwable)e1);
                throw e1;
            }
        }
        if ("addDir".equals(action)) {
            try {
                MyFolderNodeVO node = myFolderService.addMyFolderNode(request);
                myFolderService.addExtReportNode(node);
                String json = "[" + node.toString() + "]";
                try {
                    ExtServletHandler.writeOut(response, json);
                    return;
                }
                catch (IOException e) {
                    logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
                    throw new BIReportException(e);
                }
            }
            catch (BIReportException e) {
                logger.warn((Object)"\u589e\u52a0\u6211\u7684\u6587\u4ef6\u5939\u6811\u8282\u70b9\u5f02\u5e38", (Throwable)e);
                throw new BIReportException(e);
            }
        }
        if ("deleteDir".equals(action)) {
            myFolderService.leavingMyFolder(request);
            try {
                ExtServletHandler.writeOut(response, ExtServletHandler.wrapSucess(new JSONString("success")));
                return;
            }
            catch (IOException e) {
                logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
            }
            return;
        }
        if ("renameDir".equals(action)) {
            MyFolderNodeVO node = myFolderService.renameMyFolderNode(request);
            try {
                if (null == node) return;
                ExtServletHandler.writeOut(response, node.getNameJS());
                return;
            }
            catch (IOException e) {
                logger.warn((Object)"\u91cd\u547d\u540d\u6587\u4ef6\u5939\u5931\u8d25", (Throwable)e);
                throw new BIReportException(e);
            }
        }
        if ("joinToFolder".equals(action)) {
            myFolderService.join2MyFolder(request);
            try {
                ExtServletHandler.writeOut(response, ExtServletHandler.wrapSucess(new JSONString("success")));
                return;
            }
            catch (IOException e) {
                logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
            }
            return;
        }
        if ("joinToFolderBatch".equals(action)) {
            myFolderService.join2MyFolderBatch(request);
            try {
                ExtServletHandler.writeOut(response, ExtServletHandler.wrapSucess(new JSONString("success")));
                return;
            }
            catch (IOException e) {
                logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
            }
            return;
        }
        if ("moveToFolder".equals(action)) {
            myFolderService.move2MyFolder(request);
            try {
                ExtServletHandler.writeOut(response, ExtServletHandler.wrapSucess(new JSONString("success")));
                return;
            }
            catch (IOException e) {
                logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
            }
            return;
        }
        if ("moveToFolderBatch".equals(action)) {
            myFolderService.move2MyFolderBatch(request);
            try {
                ExtServletHandler.writeOut(response, ExtServletHandler.wrapSucess(new JSONString("success")));
                return;
            }
            catch (IOException e) {
                logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
            }
            return;
        }
        if ("queryReportIdNameList".equals(action)) {
            String whichType = request.getParameter("whichType");
            if ("SubSystemType".equals(whichType)) {
                try {
                    String json = extReportService.queryReportsNamesFromSSM(request);
                    try {
                        ExtServletHandler.writeOut(response, json);
                        return;
                    }
                    catch (IOException e) {
                        logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
                    }
                    return;
                }
                catch (BIReportException e) {
                    logger.warn((Object)"\u83b7\u5f97\u62a5\u8868\u5217\u8868\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            } else {
                if (!"MyFolderType".equals(whichType)) return;
                try {
                    String json = extReportService.queryReportsNameFromMFD(request);
                    try {
                        ExtServletHandler.writeOut(response, json);
                        return;
                    }
                    catch (IOException e) {
                        logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
                    }
                    return;
                }
                catch (BIReportException e) {
                    logger.warn((Object)"\u83b7\u5f97\u62a5\u8868\u5217\u8868\u5931\u8d25", (Throwable)e);
                    throw e;
                }
            }
        }
        if ("releaseLic".equals(action)) {
            try {
                String className = request.getParameter("ClassName");
                if (!StringUtil.isEmptyString((String)className)) {
                    String module = request.getParameter("ClassName");
                    EXTLicenseAgent agent = new EXTLicenseAgent(module, BISystem.getContext(request));
                    agent.releaseLicense(null);
                }
                ExtServletHandler.writeOut(response, ExtServletHandler.wrapSucess(new JSONString("success")));
                return;
            }
            catch (ExtLicenseException e) {
                throw new BIReportException("\u6269\u5c55\u62a5\u8868License\u91ca\u653e\u5931\u8d25", e);
            }
            catch (IOException e) {
                logger.warn((Object)"\u6d41\u5199\u5165HTTP Response\u5931\u8d25", (Throwable)e);
                return;
            }
        }
        try {
            response.getOutputStream().write("\u65e0\u6548\u7684URL\u8bbf\u95ee".getBytes());
            return;
        }
        catch (IOException e) {
            logger.warn((Object)"\u6d41\u5199\u5165HTTP\u5931\u8d25", (Throwable)e);
        }
    }

    public static String wrapSucess(JSON json) {
        return "{success:" + json + "}";
    }
}

