/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.globalparam;

import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportFactory;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.def.DataSourceDef;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItem;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItemSql;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.DataProviderImpl;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class GloableParamUtil {
    public static HashMap userParamMap = new HashMap();
    public static String PRE_KEY_GP = "gp_";

    public List getFilterItems(HttpServletRequest request, String themeReportPath) throws BIReportException {
        BIReport report = this.getReport(request, themeReportPath);
        BIReportFilter filter = report.getFilter(request);
        return filter == null ? null : filter.getItemList();
    }

    private BIReport getReport(HttpServletRequest request, String themeReportPath) throws BIReportException {
        Repository rep = BISystem.getRepository(request);
        String reportType = rep.getThemeReportType(themeReportPath);
        if (!"olap".equalsIgnoreCase(reportType)) {
            throw new BIReportException("\u4e0d\u652f\u6301\u7684\u62a5\u8868\u7c7b\u578b " + reportType);
        }
        String subjectName = rep.getThemeReportPropertyByPath(themeReportPath, "subject");
        String reportPath = rep.getThemeReportPropertyByPath(themeReportPath, "reportPath");
        BIReport report = BIReportFactory.buildBIReport(subjectName, reportPath, null);
        return report;
    }

    public String createGloableParamInfo(HttpServletRequest request, String themeReportPath, int index) throws BIReportException {
        StringBuffer sb = new StringBuffer();
        sb.append("<FilterInfo version=\"1.0\">");
        BIReport report = this.getReport(request, themeReportPath);
        BIReportFilterItem item = report.getFilter(request).getItem(index);
        sb.append(item.toXml());
        String varClassname = report.getSubject().getRuntimeVarClassname();
        sb.append("<varClass  var=\"" + varClassname + "\" />");
        if (item instanceof BIReportFilterItemSql) {
            BIReportFilterItemSql sqlItem = (BIReportFilterItemSql)item;
            String tableName = sqlItem.getTable();
            DataSourceDef dsf = new DataSourceDef(report.getDataSourceStream());
            String sql = new DataProviderImpl(dsf, report.getDatacenter()).getSql(tableName);
            dsf.close();
            sb.append("<Table name=\"" + tableName + "\" />");
            sb.append("<Sql sql=\"" + GloableParamUtil.formatXMLString(sql) + "\" />");
        }
        sb.append("</FilterInfo>");
        return sb.toString();
    }

    public static String formatXMLString(String xml) {
        if (xml != null) {
            return xml.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
        }
        return "";
    }

    public static String unFormatXMLString(String xml) {
        if (xml != null) {
            return xml.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&apos;", "'").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
        }
        return "";
    }

    public static void setUserParamMap(String userid, List lst) {
        if (lst.size() > 0) {
            userParamMap.put(PRE_KEY_GP + userid, lst);
        }
    }
}

