/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.kpimonitor;

import com.kingdee.bos.ctrl.analysis.web.kpimonitor.IKPIMonitor;
import com.kingdee.bos.ctrl.analysis.web.kpimonitor.IKPIMonitorList;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class KPIMonitorFactory {
    private static final Logger log = CommonLogger.getLogger(KPIMonitorFactory.class);
    private static IKPIMonitorList kpiMonitorList = null;

    public static IKPIMonitorList getKPIMonitorListInstance() throws BIReportException {
        if (kpiMonitorList != null) {
            return kpiMonitorList;
        }
        try {
            Class<?> kClass = Class.forName("com.kingdee.bos.bi.model.rt.kpimonitor.KPIMonitorList");
            kpiMonitorList = (IKPIMonitorList)kClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage());
            throw new BIReportException(e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage());
            throw new BIReportException(e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage());
            throw new BIReportException(e);
        }
        return kpiMonitorList;
    }

    public static IKPIMonitor newKPIMonitorInstance(HttpServletRequest request, String kpiMonitorId, Map baseInfoMap) throws BIReportException {
        IKPIMonitor kpiMonitor = null;
        try {
            Class<?> kClass = Class.forName("com.kingdee.bos.bi.model.rt.kpimonitor.KPIMonitor");
            Class[] kTypes = new Class[]{HttpServletRequest.class, String.class, Map.class};
            Constructor<?> kConstor = kClass.getConstructor(kTypes);
            Object[] kParams = new Object[]{request, kpiMonitorId, baseInfoMap};
            kpiMonitor = (IKPIMonitor)kConstor.newInstance(kParams);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage());
            throw new BIReportException(e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage());
            throw new BIReportException(e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage());
            throw new BIReportException(e);
        }
        catch (SecurityException e) {
            log.error((Object)e.getMessage());
            throw new BIReportException(e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage());
            throw new BIReportException(e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e.getMessage());
            throw new BIReportException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getMessage());
            throw new BIReportException(e);
        }
        if (kpiMonitor != null) {
            kpiMonitor.init(request);
        }
        return kpiMonitor;
    }
}

