/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.repository;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoard;
import com.kingdee.bos.ctrl.analysis.web.export.ExportType;
import com.kingdee.bos.ctrl.analysis.web.homepage.HomePage;
import com.kingdee.bos.ctrl.analysis.web.permission.MetaData_EAS;
import com.kingdee.bos.ctrl.analysis.web.piece.DynamicPiece;
import com.kingdee.bos.ctrl.analysis.web.piece.Piece;
import com.kingdee.bos.ctrl.analysis.web.piece.PieceUtil;
import com.kingdee.bos.ctrl.analysis.web.repository.ConectionCreator;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.BISolution;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterScheme;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.ShareStrategy;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import com.kingdee.bos.ctrl.analysis.web.solution.util.StringEncodeUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.jcr.Explorer;
import com.kingdee.bos.ctrl.jcr.ExplorerFactory;
import com.kingdee.bos.ctrl.jcr.IConnectionCreator;
import com.kingdee.bos.ctrl.jcr.SMFile;
import com.kingdee.bos.ctrl.jcr.SMFolder;
import com.kingdee.bos.ctrl.jcr.SMResource;
import com.kingdee.bos.ctrl.jcr.exception.SMException;
import com.kingdee.bos.ctrl.jcr.exception.SMExistException;
import com.kingdee.bos.ctrl.jcr.search.PropertyInfo;
import com.kingdee.bos.ctrl.jcr.search.ResourceInfo;
import com.kingdee.bos.ctrl.jcr.search.SMSearchInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.w3c.dom.Document;

public class RepositoryImpl
implements Repository {
    private SMFolder reportTreeRoot = null;
    private SMFolder pieceRoot = null;
    private SMFolder dashboardTreeRoot = null;
    private SMFolder resourceTreeRoot = null;
    private Map mapExplore = new HashMap();
    private boolean isWeb;
    private static final Logger logger = CommonLogger.getLogger(RepositoryImpl.class);
    private ConectionCreator conCreator = new ConectionCreator();
    private String dataCenter;
    private static Map mapUpgrade = new HashMap();
    private static final String JCR_NODE_PROP_REFPIECE_KEY = "refPiece";
    private static final String JCR_NODE_PROP_REFRESOURCE_KEY = "refResource";
    private static final String JCR_PROP_REFRESOURCE_SEPERATOR = "\u0001";
    private static final String JCR_FILTER_SCHEME_FOLDER = "filter_scheme";
    private static final String JCR_FOLDER_TREE_VERSIOIN_KEY = "tree_version";
    private static final String JCR_FOLDER_TREE_VERSIOIN = "6.10";

    public Explorer getReportExplorer() throws RepositoryException {
        return this.getExplorer("RPT");
    }

    private Explorer getExplorer(String wsName) throws RepositoryException {
        Explorer e = (Explorer)this.mapExplore.get(wsName);
        if (e == null) {
            throw new RepositoryException("\u672a\u77e5\u7684\u5de5\u4f5c\u7a7a\u95f4\u540d" + wsName);
        }
        return e;
    }

    @Override
    public void close() {
        for (String ws : this.mapExplore.keySet()) {
            ((Explorer)this.mapExplore.get(ws)).free();
        }
    }

    @Override
    public String[][] findDashboardPaths(String parentPath, String[] captions) throws RepositoryException {
        SMResource parent;
        if (!parentPath.equals("") && !parentPath.startsWith("/")) {
            parentPath = "/" + parentPath;
        }
        if ((parent = this.getDashboardResourceByPath(parentPath = "/dashboard_tree" + parentPath)) instanceof SMFile || null == parent) {
            throw new RepositoryException("\u6307\u5b9a\u8def\u5f84" + parentPath + "\u4e0d\u662f\u76ee\u5f55!");
        }
        SMResource[] smrs = null;
        ArrayList<String> lstPath = new ArrayList<String>();
        ArrayList<String> lstCaption = new ArrayList<String>();
        ArrayList<String> lstFolder = new ArrayList<String>();
        try {
            for (int i = 0; i < captions.length; ++i) {
                SMSearchInfo si = new SMSearchInfo(new ResourceInfo(null, new PropertyInfo("caption", captions[i])), false);
                smrs = ((SMFolder)parent).search(si);
                if (smrs == null || smrs.length <= 0) continue;
                for (int n = 0; n < smrs.length; ++n) {
                    lstPath.add(smrs[n].getName());
                    lstCaption.add(smrs[n].getProperty("caption"));
                    lstFolder.add(smrs[n].isFile() ? "false" : "true");
                }
            }
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        String[][] ret = new String[][]{lstPath.toArray(new String[0]), lstCaption.toArray(new String[0]), lstFolder.toArray(new String[0])};
        return ret;
    }

    @Override
    public String getHomePage(String userId, String orgID) throws RepositoryException {
        if (!BISystem.isEAS()) {
            return "";
        }
        HomePage homepage = new HomePage();
        String roleID = homepage.getRoleByUserAndOrg(this, userId, orgID);
        String u_dashboardid = homepage.getHomePageByUserAndOrg(this, userId, orgID);
        String r_dashboardid = "";
        if (roleID != null && roleID.trim().length() > 0) {
            r_dashboardid = homepage.getHomePageByRole(this, roleID);
        }
        if (u_dashboardid != null && u_dashboardid.length() > 0) {
            SMResource sr = this.getDashboardByID(u_dashboardid);
            try {
                return sr == null ? "" : sr.getPath();
            }
            catch (SMException e) {
                e.printStackTrace();
            }
        } else if (r_dashboardid != null && r_dashboardid.length() > 0) {
            SMResource sr = this.getDashboardByID(r_dashboardid);
            try {
                return sr == null ? "" : sr.getPath();
            }
            catch (SMException e) {
                e.printStackTrace();
            }
        } else {
            return "empty";
        }
        return "";
    }

    @Override
    public String getDashboardPathByID(String id) {
        SMResource sr = this.getDashboardByID(id);
        try {
            return sr == null ? "" : sr.getPath();
        }
        catch (SMException e) {
            logger.error((Object)e);
            return "";
        }
    }

    @Override
    public String getDashboardCaptionByID(String id) {
        SMResource sr = this.getDashboardByID(id);
        try {
            if (sr == null) {
                return null;
            }
            return sr.getProperty("caption");
        }
        catch (SMExistException e) {
            try {
                return sr.getName();
            }
            catch (SMException e1) {
                logger.error((Object)e);
            }
        }
        catch (SMException e) {
            logger.error((Object)e);
        }
        return "";
    }

    @Override
    public String getDashboardCaption(String path) throws RepositoryException {
        SMFile dashboardNode = (SMFile)this.getDashboardChildByPath(path);
        String ret = "";
        try {
            if (null != dashboardNode) {
                ret = dashboardNode.getProperty("caption");
            }
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        return ret;
    }

    private SMResource getDashboardByID(String id) {
        SMSearchInfo si = new SMSearchInfo(new ResourceInfo(null, new PropertyInfo("permissionID", id)), true);
        SMResource[] rs = null;
        try {
            rs = this.dashboardTreeRoot.search(si);
        }
        catch (SMException e) {
            e.printStackTrace();
        }
        if (null == rs || rs.length == 0) {
            return null;
        }
        return rs[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addNewDirectory(String parent, String caption, String dirName, int treeType, String user, String cu) throws RepositoryException {
        Explorer explore;
        String ret = "";
        SMFolder root = null;
        String wsName = "";
        String rootPath = "";
        switch (treeType) {
            case 3: {
                wsName = "RPT";
                rootPath = "/piece";
                root = this.pieceRoot;
                break;
            }
            case 4: {
                wsName = "DBD";
                rootPath = "/resource";
                root = this.resourceTreeRoot;
                break;
            }
            case 6: {
                wsName = "RPT";
                rootPath = "/report_tree";
                root = this.reportTreeRoot;
                break;
            }
            case 5: {
                wsName = "DBD";
                rootPath = "/dashboard_tree";
                root = this.dashboardTreeRoot;
                break;
            }
            default: {
                throw new RepositoryException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b" + treeType + "\uff01");
            }
        }
        SMFolder parentFolder = root;
        Explorer explorer = explore = this.getExplorer(wsName);
        synchronized (explorer) {
            if (!parent.equals("")) {
                parentFolder = this.getParentFolder(root, parent, false);
            }
            try {
                explore.setAtomicSave(false);
                if (this.isNodeCaptionExisted(parentFolder, caption)) {
                    throw new SMExistException("\u6307\u5b9a\u540d\u79f0" + caption + "\u4e0e\u73b0\u6709\u6587\u4ef6/\u6587\u4ef6\u5939\u91cd\u540d\uff0c\u8bf7\u6307\u5b9a\u53e6\u5916\u7684\u540d\u79f0\uff01");
                }
                SMFolder newFolder = (SMFolder)parentFolder.addChild(dirName, 1);
                newFolder.setProperty("caption", caption);
                String id = null;
                if (treeType == 6) {
                    id = MetaData_EAS.saveThemeAnalysis_EAS(this, this.getConnection(), user, cu, 0, dirName, caption, true, parentFolder, (SMResource)newFolder, "", "", true);
                } else if (treeType == 5) {
                    id = MetaData_EAS.saveDashboard_EAS(this, this.getConnection(), user, cu, 0, dirName, caption, true, parentFolder, (SMResource)newFolder, true);
                }
                if (id != null) {
                    newFolder.setProperty("permissionID", id);
                }
                explore.save();
                ret = wsName + JCR_PROP_REFRESOURCE_SEPERATOR + rootPath + JCR_PROP_REFRESOURCE_SEPERATOR + newFolder.getPath();
            }
            catch (SMExistException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException("\u76ee\u5f55\u540d" + caption + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u6307\u5b9a\u53e6\u5916\u7684\u540d\u79f0\uff01", e);
            }
            catch (SMException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException("\u6dfb\u52a0\u76ee\u5f55" + caption + "\u5931\u8d25\uff01 \u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
            }
            catch (BIReportException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException("\u6dfb\u52a0\u76ee\u5f55" + caption + "\u5931\u8d25\uff01 \u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
            }
            finally {
                explore.setAtomicSave(true);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameDirectory(String parent, String oldName, String newName, int treeType, String user, String cu) throws RepositoryException {
        Explorer explore;
        SMFolder root = null;
        String wsName = "";
        switch (treeType) {
            case 3: {
                wsName = "RPT";
                root = this.pieceRoot;
                break;
            }
            case 4: {
                wsName = "DBD";
                root = this.resourceTreeRoot;
                break;
            }
            case 6: {
                wsName = "RPT";
                root = this.reportTreeRoot;
                break;
            }
            case 5: {
                wsName = "DBD";
                root = this.dashboardTreeRoot;
                break;
            }
            default: {
                throw new RepositoryException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b" + treeType + "\uff01");
            }
        }
        SMFolder parentFolder = root;
        Explorer explorer = explore = this.getExplorer(wsName);
        synchronized (explorer) {
            if (!parent.equals("")) {
                parentFolder = this.getParentFolder(root, parent, false);
            }
            try {
                explore.setAtomicSave(false);
                SMResource res = null;
                res = this.isNodeCaptionExisted(parentFolder, oldName) ? this.getNodeResourceByCaption(parentFolder, oldName) : parentFolder.getChild(oldName);
                if (null != res) {
                    res.setProperty("caption", newName);
                    explore.save();
                    if (treeType == 6) {
                        MetaData_EAS.saveThemeAnalysis_EAS(this, this.getConnection(), user, cu, 0, newName, newName, false, parentFolder, res, "", "", true);
                    } else if (treeType == 5) {
                        MetaData_EAS.saveDashboard_EAS(this, this.getConnection(), user, cu, 0, newName, newName, false, parentFolder, res, true);
                    }
                }
            }
            catch (SMExistException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException("\u76ee\u5f55\u540d" + newName + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u6307\u5b9a\u53e6\u5916\u7684\u540d\u79f0\uff01");
            }
            catch (SMException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException("\u76ee\u5f55" + oldName + "\u66f4\u540d\u5931\u8d25\uff01 \u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
            }
            catch (BIReportException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException("\u4fee\u6539\u76ee\u5f55" + oldName + "\u5931\u8d25\uff01 \u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
            }
            finally {
                explore.setAtomicSave(true);
            }
        }
    }

    private void rollbackTrans(Explorer explore) {
        try {
            explore.giveUpSave();
        }
        catch (SMException e) {
            logger.error((Object)("error when rollback! cause: " + e.getMessage()));
        }
    }

    private SMFolder getParentFolder(SMFolder rootFolder, String parentPath, boolean create) throws RepositoryException {
        SMFolder ret = rootFolder;
        try {
            if (parentPath != null && !parentPath.equals("")) {
                ret = rootFolder.getChild(parentPath);
            }
        }
        catch (SMExistException e) {
            if (create) {
                try {
                    ret = rootFolder.addChild(parentPath, 1);
                }
                catch (SMException e1) {
                    throw new RepositoryException("\u6307\u5b9a\u8def\u5f84" + parentPath + "\u4e0d\u5408\u6cd5\uff01 \u51fa\u9519\u539f\u56e0\uff1a" + e1.getMessage());
                }
            }
            throw new RepositoryException("\u6307\u5b9a\u7236\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        catch (SMException e) {
            throw new RepositoryException("\u67e5\u627e\u7236\u76ee\u5f55\u65f6\u51fa\u9519\uff01", e);
        }
        if (ret instanceof SMFolder) {
            return ret;
        }
        throw new RepositoryException("\u6307\u5b9a\u7236\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameDashboard(String dashboardpath, String newcaption, String user, String cu) throws RepositoryException {
        Explorer explore;
        SMResource smDashboard = this.getDashboardChildByPath(dashboardpath);
        if (!(smDashboard instanceof SMFile)) {
            throw new RepositoryException("\u6307\u5b9a\u4eea\u8868\u677f" + dashboardpath + "\u672a\u627e\u5230\uff01");
        }
        try {
            if (this.isNodeCaptionExisted(smDashboard.getParent(), newcaption)) {
                throw new RepositoryException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u76ee\u5f55\u6216\u4eea\u8868\u677f\uff0c\u8bf7\u91cd\u65b0\u547d\u540d\uff01");
            }
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        Explorer explorer = explore = this.getExplorer("DBD");
        synchronized (explorer) {
            try {
                explore.setAtomicSave(false);
                smDashboard.setProperty("caption", newcaption);
                MetaData_EAS.saveDashboard_EAS(this, this.getConnection(), user, cu, 1, smDashboard.getName(), newcaption, false, smDashboard.getParent(), smDashboard, true);
                explore.save();
            }
            catch (SMException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            catch (BIReportException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            finally {
                explore.setAtomicSave(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveDashboard(String parentPath, String caption, String name, String content, String user, String cu) throws RepositoryException {
        Explorer explore;
        String ret = "";
        SMFolder parentFolder = this.dashboardTreeRoot;
        Explorer explorer = explore = this.getExplorer("DBD");
        synchronized (explorer) {
            if (!parentPath.equals("") && parentPath.startsWith("/")) {
                parentPath = parentPath.substring(1);
            }
            parentFolder = this.getParentFolder(parentFolder, parentPath, true);
            try {
                boolean isNew = false;
                SMResource smDashboard = null;
                if (this.isNodeCaptionExisted(parentFolder, caption)) {
                    SMResource smr = this.getNodeResourceByCaption(parentFolder, caption);
                    if (null == smr || !smr.isFile()) {
                        throw new SMException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u76ee\u5f55");
                    }
                    name = smr.getName();
                }
                try {
                    smDashboard = parentFolder.getChild(name);
                    if (!(smDashboard instanceof SMFile)) {
                        throw new RepositoryException("\u6307\u5b9a\u4eea\u8868\u677f" + name + "\u672a\u627e\u5230\uff01");
                    }
                }
                catch (SMExistException smr) {
                    // empty catch block
                }
                explore.setAtomicSave(false);
                if (smDashboard == null) {
                    isNew = true;
                    smDashboard = parentFolder.addChild(name, 16);
                }
                ((SMFile)smDashboard).write(content.getBytes("UTF-8"));
                smDashboard.setProperty("caption", caption);
                this.writeDashboardRefInfo((SMFile)smDashboard, content);
                String id = MetaData_EAS.saveDashboard_EAS(this, this.getConnection(), user, cu, 1, smDashboard.getName(), caption, isNew, parentFolder, smDashboard, true);
                if (id != null) {
                    smDashboard.setProperty("permissionID", id);
                }
                explore.save();
                ret = smDashboard.getPath();
            }
            catch (SMException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (BIReportException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            catch (DocumentException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            finally {
                explore.setAtomicSave(true);
            }
        }
        return ret;
    }

    private boolean isNodeCaptionExisted(SMFolder parentFolder, String caption) throws SMException {
        SMResource[] rs = this.findNodeByCaption(parentFolder, caption);
        return rs.length > 0;
    }

    private SMResource[] findNodeByCaption(SMFolder parentFolder, String caption) throws SMException {
        SMSearchInfo si = new SMSearchInfo(new ResourceInfo(null, new PropertyInfo("caption", caption)), false);
        return parentFolder.search(si);
    }

    private SMResource getNodeResourceByCaption(SMFolder parentFolder, String caption) throws SMException {
        SMSearchInfo si = new SMSearchInfo(new ResourceInfo(null, new PropertyInfo("caption", caption)), false);
        SMResource[] rs = parentFolder.search(si);
        return rs.length > 0 ? rs[0] : null;
    }

    @Override
    public String saveThemeReport(String parentNodePath, String parentNodeDisplayPath, String oldDisplayName, String displayName, String reportURL, String themeReportType, String user, String cu) throws RepositoryException {
        return this.saveThemeReport(parentNodePath, parentNodeDisplayPath, oldDisplayName, displayName, reportURL, themeReportType, user, cu, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String saveThemeReport(String parentNodePath, String parentNodeDisplayPath, String oldDisplayName, String displayName, String reportURL, String themeReportType, String user, String cu, String datacenter) throws RepositoryException {
        Explorer explore;
        String themeName = "THEME" + IDGenerator.getUUID();
        String ret = "";
        Explorer explorer = explore = this.getExplorer("RPT");
        synchronized (explorer) {
            SMFolder parentFolder = this.getParentFolder(this.reportTreeRoot, parentNodePath, true);
            try {
                boolean isNew = false;
                explore.setAtomicSave(false);
                SMResource smTheme = null;
                if (!StringUtils.isEmpty((String)oldDisplayName)) {
                    if (!this.isNodeCaptionExisted(parentFolder, oldDisplayName)) throw new SMException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u4e3b\u9898");
                    SMResource smr = this.getNodeResourceByCaption(parentFolder, oldDisplayName);
                    themeName = smr.getName();
                } else if (this.isNodeCaptionExisted(parentFolder, displayName)) {
                    SMResource smr = this.getNodeResourceByCaption(parentFolder, displayName);
                    themeName = smr.getName();
                }
                try {
                    smTheme = parentFolder.getChild(themeName);
                    if (!(smTheme instanceof SMFolder)) {
                        throw new RepositoryException("\u5df2\u5b58\u5728\u975e\u6cd5\u540c\u540d\u8282\u70b9" + themeName + "\uff01");
                    }
                }
                catch (SMExistException sMExistException) {
                    // empty catch block
                }
                if (smTheme == null) {
                    isNew = true;
                    smTheme = parentFolder.addChild(themeName, 1);
                }
                String subjectName = "";
                String reportPath = "";
                if ("ext".equalsIgnoreCase(themeReportType) || "dupont".equalsIgnoreCase(themeReportType) || "bimolap".equalsIgnoreCase(themeReportType)) {
                    reportPath = reportURL;
                } else {
                    int start;
                    int find = reportURL.indexOf("subject=");
                    if (find != -1) {
                        start = find + "subject=".length();
                        int end = reportURL.indexOf("&", start);
                        subjectName = end == -1 ? reportURL.substring(start) : reportURL.substring(start, end);
                    }
                    if ((find = reportURL.indexOf("reportPath=")) != -1) {
                        start = find + "reportPath=".length();
                        reportPath = reportURL.substring(start);
                        try {
                            reportPath = URLDecoder.decode(reportPath, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                }
                smTheme.setProperty("themeReportType", "" + themeReportType);
                smTheme.setProperty("isReport", "true");
                smTheme.setProperty("subject", subjectName);
                smTheme.setProperty("reportPath", reportPath);
                smTheme.setProperty("caption", displayName);
                smTheme.setProperty("captionPath", parentNodeDisplayPath);
                if (datacenter != null && !datacenter.equals("")) {
                    smTheme.setProperty("datacenter", datacenter);
                } else {
                    smTheme.setProperty("datacenter", null);
                }
                String id = MetaData_EAS.saveThemeAnalysis_EAS(this, this.getConnection(), user, cu, 1, smTheme.getName(), displayName, isNew, parentFolder, smTheme, subjectName, reportPath, true);
                if (id != null) {
                    smTheme.setProperty("permissionID", id);
                }
                explore.save();
                ret = smTheme.getPath();
            }
            catch (SMException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            catch (RepositoryException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            catch (BIReportException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            finally {
                explore.setAtomicSave(true);
            }
            return ret;
        }
    }

    @Override
    public void removeExtReport(String path, Context ctx) throws RepositoryException {
        this.deleteNode(path, 6, ctx, "ext");
    }

    @Override
    public void removeDupontReport(String path, Context ctx) throws RepositoryException {
        this.deleteNode(path, 6, ctx, "dupont");
    }

    @Override
    public void delNode(String path, int treeType, Context ctx) throws RepositoryException {
        this.deleteNode(path, treeType, ctx, "olap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNode(String path, int treeType, Context ctx, String caller) throws RepositoryException {
        Explorer explorer;
        SMResource node = null;
        String wsName = "";
        String user = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            switch (treeType) {
                case 3: {
                    wsName = "RPT";
                    node = this.pieceRoot.getChild(path);
                    if (BISystem.isPiecePerByUser(ctx) && !PieceUtil.canUse(user, node)) {
                        throw new RepositoryException("\u8be5\u7247\u6bb5\u7531\u4ed6\u4eba\u521b\u5efa\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
                    }
                    break;
                }
                case 4: {
                    wsName = "DBD";
                    node = this.resourceTreeRoot.getChild(path);
                    break;
                }
                case 6: {
                    wsName = "RPT";
                    if (path.startsWith("report_tree")) {
                        path = path.substring("report_tree".length() + 1);
                    }
                    node = this.reportTreeRoot.getChild(path);
                    break;
                }
                case 5: {
                    wsName = "DBD";
                    node = this.dashboardTreeRoot.getChild(path);
                    break;
                }
                default: {
                    throw new RepositoryException("\u4e0d\u652f\u6301\u7684\u5b58\u50a8\u7c7b\u578b" + treeType + "\uff01");
                }
            }
        }
        catch (SMException e) {
            throw new RepositoryException("\u6307\u5b9a\u7ed3\u70b9" + path + "\u672a\u627e\u5230\uff01", e);
        }
        Explorer explorer2 = explorer = this.getExplorer(wsName);
        synchronized (explorer2) {
            try {
                explorer.setAtomicSave(false);
                boolean needDeletePermission = BISystem.isEAS() && (treeType == 6 || treeType == 5);
                ArrayList listPermissionItemID = null;
                if (needDeletePermission) {
                    listPermissionItemID = new ArrayList();
                    MetaData_EAS.getNodePermissionIDList(node, treeType, listPermissionItemID);
                }
                this.canDeleteNode(node, treeType, caller);
                String FID = "";
                try {
                    FID = node.getProperty("permissionID");
                }
                catch (SMExistException sMExistException) {
                    // empty catch block
                }
                node.delete();
                MetaData_EAS.delTreeNode_EAS(this.getConnection(), FID, treeType, true);
                if (needDeletePermission) {
                    MetaData_EAS.removeDataPermisstion(listPermissionItemID, treeType, ctx, this.isWeb);
                }
                explorer.save();
            }
            catch (SMException e) {
                logger.error((Object)("\u5220\u9664\u7ed3\u70b9" + path + "\u5931\u8d25\uff01"), (Throwable)e);
                this.rollbackTrans(explorer);
                throw new RepositoryException("\u5220\u9664\u5931\u8d25\uff01", e);
            }
            catch (BIReportException e) {
                this.rollbackTrans(explorer);
                throw new RepositoryException("\u5220\u9664\u5931\u8d25\uff01\u539f\u56e0\uff1a" + e.getMessage());
            }
            finally {
                explorer.setAtomicSave(true);
            }
        }
    }

    private String getPathCaption(SMResource node, int treeType) throws SMException, RepositoryException {
        StringBuffer sb = new StringBuffer();
        SMFolder root = null;
        String wsName = null;
        switch (treeType) {
            case 3: {
                wsName = "RPT";
                root = this.pieceRoot;
                break;
            }
            case 4: {
                wsName = "DBD";
                root = this.resourceTreeRoot;
                break;
            }
            case 6: {
                wsName = "RPT";
                root = this.reportTreeRoot;
                break;
            }
            case 5: {
                wsName = "DBD";
                root = this.dashboardTreeRoot;
            }
        }
        String path = null;
        if (null != root) {
            path = this.getRelationPath(wsName, node.getPath(), root.getPath());
        }
        if (StringUtils.isEmpty(path)) {
            return "";
        }
        if ((path = path.trim()).startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int start = 0;
        int find = path.indexOf("/", start);
        if (null != root) {
            String caption;
            while (find != -1) {
                start = find + 1;
                caption = RepositoryUtil.getPropertyValue(root.getChild(path.substring(0, find)), "caption");
                sb.append(caption);
                sb.append("/");
                find = path.indexOf("/", start);
            }
            caption = RepositoryUtil.getPropertyValue(root.getChild(path), "caption");
            sb.append(caption);
        }
        return sb.toString();
    }

    @Override
    public int getNodeChildCount(String wsName, String path) throws RepositoryException {
        SMResource res = this.getResourceByPath(this.getExplorer(wsName), path);
        if (res instanceof SMFile) {
            return 0;
        }
        if (res instanceof SMFolder) {
            try {
                return ((SMFolder)res).getChildCount();
            }
            catch (SMException e) {
                throw new RepositoryException(e);
            }
        }
        throw new RepositoryException("\u672a\u77e5\u7c7b\u578b\u7ed3\u70b9!");
    }

    @Override
    public Calendar getNodeLastModified(String ws, String path) throws RepositoryException {
        SMResource res = this.getResourceByPath(ws, path);
        try {
            return res.getLastModified();
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public List getNodeChildrenPaths(String wsName, String path) throws RepositoryException {
        ArrayList<String> lstRet = new ArrayList<String>();
        SMResource res = this.getResourceByPath(this.getExplorer(wsName), path);
        if (res instanceof SMFile) {
            return lstRet;
        }
        if (res instanceof SMFolder) {
            try {
                SMResource[] sm_child = ((SMFolder)res).getChildren();
                int count = sm_child.length;
                for (int i = 0; i < count; ++i) {
                    lstRet.add(sm_child[i].getPath());
                }
                return lstRet;
            }
            catch (SMException e) {
                throw new RepositoryException(e);
            }
        }
        throw new RepositoryException("\u672a\u77e5\u7c7b\u578b\u7ed3\u70b9!");
    }

    private void canDeleteNode(SMResource node, int treeType, String caller) throws BIReportException, SMException {
        boolean isFolder = node instanceof SMFolder;
        switch (treeType) {
            case 3: {
                if (isFolder) break;
                List listDashboard = this.getResRefDashboardList(node.getPath(), treeType);
                if (listDashboard == null || listDashboard.size() == 0) {
                    return;
                }
                String str = this.getPathCaption(node, treeType);
                throw new BIReportException("\u7247\u6bb5 " + str + " \u6709\u4eea\u8868\u677f\u6b63\u5728\u4f7f\u7528\u3002" + listDashboard.toString());
            }
            case 4: {
                if (isFolder) break;
                List listDashboard = this.getResRefDashboardList(node.getPath(), treeType);
                if (listDashboard == null || listDashboard.size() == 0) {
                    return;
                }
                String str = this.getPathCaption(node, treeType);
                throw new BIReportException("\u56fe\u7247 " + str + " \u6709\u4eea\u8868\u677f\u6b63\u5728\u4f7f\u7528\u3002" + listDashboard.toString());
            }
            case 6: {
                List listPiece;
                boolean bl = isFolder = !RepositoryUtil.isThemeReport(node);
                if (isFolder) break;
                String str = this.getPathCaption(node, treeType);
                if ("olap".equalsIgnoreCase(caller)) {
                    if ("ext".equalsIgnoreCase(this.getThemeReportType(node))) {
                        throw new BIReportException("\u6269\u5c55\u62a5\u8868 " + str + "  \u4e0d\u5141\u8bb8\u5728\u6b64\u5904\u5220\u9664(\u8bf7\u5230\u6269\u5c55\u62a5\u8868\u7ba1\u7406\u5e73\u53f0\u64a4\u6d88\u8be5\u62a5\u8868)!");
                    }
                    if ("dupont".equalsIgnoreCase(this.getThemeReportType(node))) {
                        throw new BIReportException("\u675c\u90a6\u5206\u6790 " + str + "  \u4e0d\u5141\u8bb8\u5728\u6b64\u5904\u5220\u9664(\u8bf7\u5230\u6307\u6807\u5efa\u6a21\u63a7\u5236\u53f0\u64a4\u6d88\u8be5\u675c\u90a6\u5206\u6790)!");
                    }
                }
                if ((listPiece = this.getThemeRefPieceList(node.getPath())) == null || listPiece.size() == 0) {
                    return;
                }
                throw new BIReportException("\u4e3b\u9898 " + str + " \u5b58\u5728\u5bfc\u51fa\u7247\u6bb5\uff1a" + listPiece.toString());
            }
            case 5: {
                if (isFolder) break;
                this.delHomepageSetting(node.getPath());
            }
        }
        if (isFolder) {
            SMResource[] sr = ((SMFolder)node).getChildren();
            for (int n = 0; n < sr.length; ++n) {
                this.canDeleteNode(sr[n], treeType, caller);
            }
        }
    }

    private void delHomepageSetting(String dashboardURI) throws BIReportException {
        if (!BISystem.isEAS()) {
            return;
        }
        String ksql = "DELETE FROM T_BI_PieceHomePage WHERE T_BI_PieceHomePage.FPATH='" + dashboardURI + "'";
        this.executeUpdate(ksql);
    }

    private List getResRefDashboardList(String RepositoryURI, int type) throws RepositoryException {
        String property = "";
        SMFolder root = this.dashboardTreeRoot;
        if (type == 3) {
            property = JCR_NODE_PROP_REFPIECE_KEY;
        } else if (type == 4) {
            property = JCR_NODE_PROP_REFRESOURCE_KEY;
        } else {
            throw new RepositoryException("\u672a\u77e5\u7684\u8d44\u6e90\u7c7b\u578b\uff1a" + type);
        }
        PropertyInfo p = new PropertyInfo(property + ",\"%" + RepositoryURI + "%\"");
        p.setFunction("jcr:like");
        PropertyInfo[] pi = new PropertyInfo[]{p};
        return this.searchCaption(pi, root);
    }

    private List searchCaption(PropertyInfo[] pi, SMFolder root) throws RepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        ResourceInfo ri = new ResourceInfo(null);
        ri.setPropertyInfos(pi);
        SMSearchInfo si = new SMSearchInfo(ri);
        SMResource[] smrs = null;
        try {
            smrs = root.search(si);
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        if (smrs != null && smrs.length > 0) {
            for (int n = 0; n < smrs.length; ++n) {
                list.add(RepositoryUtil.getPropertyValue(smrs[n], "caption"));
            }
        }
        return list;
    }

    private List getThemeRefPieceList(String themeID) throws RepositoryException {
        PropertyInfo p = new PropertyInfo("themeID", themeID);
        PropertyInfo[] pi = new PropertyInfo[]{p};
        return this.searchCaption(pi, this.pieceRoot);
    }

    @Override
    public String getNodeNameByPath(String ws, String path) throws RepositoryException {
        SMResource res = this.getResourceByPath(this.getExplorer(ws), path);
        String ret = null;
        try {
            ret = res.getName();
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        return ret;
    }

    @Override
    public String getNodePropertyByPath(String ws, String path, String property) throws RepositoryException {
        SMResource res = this.getResourceByPath(this.getExplorer(ws), path);
        String ret = null;
        try {
            ret = res.getProperty(property);
        }
        catch (SMExistException e) {
            throw new RepositoryException("\u672a\u77e5\u7684\u5c5e\u6027\u540d" + property, e);
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        return ret;
    }

    @Override
    public String getThemeReportPropertyByPath(String path, String property) throws RepositoryException {
        return this.getNodePropertyByPath("RPT", path, property);
    }

    @Override
    public String getNodeCaptionByPath(String ws, String path) throws RepositoryException {
        return this.getNodePropertyByPath2(ws, path, "caption");
    }

    @Override
    public String getNodePropertyByPath2(String ws, String path, String propertyName) throws RepositoryException {
        SMResource res = this.getResourceByPath(this.getExplorer(ws), path);
        String ret = null;
        try {
            ret = res.getProperty(propertyName);
        }
        catch (SMExistException e) {
            if ("caption".equalsIgnoreCase(propertyName)) {
                try {
                    return this.getNodeNameByPath(ws, path);
                }
                catch (RepositoryException e2) {
                    logger.error((Object)"\u83b7\u53d6\u8d44\u6e90\u5c5e\u6027caption\u65f6\u51fa\u9519!", (Throwable)e2);
                }
            }
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        return ret;
    }

    private SMResource getResourceByPath(String wsName, String path) throws RepositoryException {
        return this.getResourceByPath(this.getExplorer(wsName), path);
    }

    private SMResource getResourceByPath(Explorer explore, String path) throws RepositoryException {
        SMResource res = null;
        try {
            res = explore.getResourceByPath(path);
        }
        catch (SMExistException e) {
            throw new RepositoryException("\u672a\u77e5\u8282\u70b9\u8def\u5f84" + path, e);
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        return res;
    }

    @Override
    public byte[] getNodeBinaryData(String wsName, String path) throws RepositoryException {
        SMResource res = this.getResourceByPath(this.getExplorer(wsName), path);
        byte[] ret = null;
        if (res instanceof SMFile) {
            SMFile file = (SMFile)res;
            try {
                ret = file.read();
            }
            catch (SMException e) {
                throw new RepositoryException(e);
            }
        } else {
            throw new RepositoryException("\u7ed3\u70b9\u7c7b\u578b\u4e0d\u80fd,\u65e0\u6cd5\u83b7\u53d6\u4e8c\u8fdb\u5236\u6570\u636e!");
        }
        return ret;
    }

    private SMResource getDashboardResourceByPath(String path) throws RepositoryException {
        SMResource res = null;
        try {
            res = this.getExplorer("DBD").getResourceByPath(path);
        }
        catch (SMExistException sMExistException) {
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        return res;
    }

    private SMResource getResourceResourceByPath(String path) throws RepositoryException {
        SMResource res = null;
        try {
            res = this.getExplorer("DBD").getResourceByPath(path);
        }
        catch (SMExistException sMExistException) {
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        return res;
    }

    public SMResource getImageResourceByPath(String path) throws RepositoryException {
        String fullPath = path;
        if (!path.startsWith("/resource")) {
            fullPath = !fullPath.startsWith("/") ? "/resource/" + path : "/resource" + path;
        }
        return this.getResourceResourceByPath(fullPath);
    }

    private SMResource getDashboardChildByPath(String path) throws RepositoryException {
        String fullPath = path;
        if (!path.startsWith("/dashboard_tree")) {
            fullPath = !fullPath.startsWith("/") ? "/dashboard_tree/" + path : "/dashboard_tree" + path;
        }
        return this.getDashboardResourceByPath(fullPath);
    }

    @Override
    public String getDashboardXML(String path) throws RepositoryException {
        SMFile dashboardNode = (SMFile)this.getDashboardChildByPath(path);
        return this.getDashboardXML(dashboardNode);
    }

    private String getDashboardXML(SMFile node) throws RepositoryException {
        String strXML = null;
        if (node != null) {
            try {
                byte[] byteRead = node.read();
                strXML = new String(byteRead, "UTF-8");
            }
            catch (SMException e) {
                throw new RepositoryException("\u8bfb\u53d6\u4eea\u8868\u677f\u5185\u5bb9\u65f6\u51fa\u9519\uff01\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return strXML;
    }

    @Override
    public boolean isDynamicPiece(String piecePath) throws RepositoryException {
        SMResource pieceRes = this.getResourceByPath(this.getExplorer("RPT"), piecePath);
        try {
            return "dynamic".equalsIgnoreCase(pieceRes.getProperty("type"));
        }
        catch (SMException e) {
            return false;
        }
    }

    @Override
    public boolean isSnapshotPiece(String piecePath) throws RepositoryException {
        SMResource pieceRes = this.getResourceByPath(this.getExplorer("RPT"), piecePath);
        try {
            return "snapshot".equalsIgnoreCase(pieceRes.getProperty("type"));
        }
        catch (SMException e) {
            return false;
        }
    }

    public RepositoryImpl(String dataCenter, String user, String cu, boolean isWeb) throws RepositoryException {
        this.init(StringEncodeUtil.encode(dataCenter), user, cu, isWeb);
    }

    public int getChildCount(SMFolder folder) throws RepositoryException {
        try {
            return folder.getChildren().length;
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
    }

    public SMResource lookupReportRepNode(String subjectPath, String path) throws RepositoryException {
        PropertyInfo[] pi = new PropertyInfo[]{new PropertyInfo("subject", subjectPath), new PropertyInfo("reportPath", path)};
        ResourceInfo ri = new ResourceInfo(null);
        ri.setPropertyInfos(pi);
        SMSearchInfo si = new SMSearchInfo(ri);
        SMResource[] smrs = null;
        try {
            smrs = this.reportTreeRoot.search(si);
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        if (smrs != null && smrs.length > 0) {
            return smrs[0];
        }
        return null;
    }

    private SMFolder getFilterSchemeFolder(String reportPath) throws RepositoryException {
        SMFolder smReport = (SMFolder)this.getResourceByPath("RPT", reportPath);
        SMResource smFilterSchemeFolder = null;
        try {
            smFilterSchemeFolder = smReport.getChild(JCR_FILTER_SCHEME_FOLDER);
            if (!(smFilterSchemeFolder instanceof SMFolder)) {
                throw new RepositoryException("\u672a\u627e\u5230\u62a5\u8868" + reportPath + "\u7684\u8fc7\u6ee4\u65b9\u6848\u76ee\u5f55\uff01");
            }
            return (SMFolder)smFilterSchemeFolder;
        }
        catch (SMExistException e) {
            return null;
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FilterScheme[] generateFilterSchemes(List smSchemes, String reportPath, BIReportFilter filter) throws RepositoryException {
        FilterScheme[] filterSchemes = new FilterScheme[smSchemes.size()];
        int i = 0;
        try {
            for (SMFile f : smSchemes) {
                String caption = f.getProperty("caption");
                String creatorID = null;
                String creatorOrgUnitID = null;
                String createTimeString = null;
                String lastUpdateTimeString = null;
                String shareStrategy = null;
                try {
                    creatorID = f.getProperty("creatorID");
                }
                catch (SMExistException sMExistException) {
                    // empty catch block
                }
                try {
                    creatorOrgUnitID = f.getProperty("creatorOrgUnitID");
                }
                catch (SMExistException sMExistException) {
                    // empty catch block
                }
                try {
                    createTimeString = f.getProperty("createTime");
                }
                catch (SMExistException sMExistException) {
                    // empty catch block
                }
                try {
                    lastUpdateTimeString = f.getProperty("lastUpdateTime");
                }
                catch (SMExistException sMExistException) {
                    // empty catch block
                }
                try {
                    shareStrategy = f.getProperty("shareStrategy");
                }
                catch (SMExistException sMExistException) {
                    // empty catch block
                }
                Calendar createTime = null;
                Calendar lastUpdateTime = null;
                if (createTimeString != null) {
                    createTime = Calendar.getInstance();
                    createTime.setTimeInMillis(Long.parseLong(createTimeString));
                }
                if (lastUpdateTimeString != null) {
                    lastUpdateTime = Calendar.getInstance();
                    lastUpdateTime.setTimeInMillis(Long.parseLong(lastUpdateTimeString));
                }
                ShareStrategy ss = new ShareStrategy(creatorID, creatorOrgUnitID, createTime, lastUpdateTime, shareStrategy);
                String xml = null;
                try {
                    xml = new String(f.read(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                try {
                    filterSchemes[i++] = FilterScheme.fromXML(caption, ss, xml, filter, reportPath);
                }
                catch (BIReportException e) {
                    throw new SMException("\u6784\u9020\u8fc7\u6ee4\u65b9\u6848\u5931\u8d25,\u683c\u5f0f\u9519\u8bef\uff01");
                    return filterSchemes;
                }
            }
        }
        catch (SMException e) {
            throw new RepositoryException("\u8bfb\u53d6\u8fc7\u6ee4\u65b9\u6848\u4fe1\u606f\u65f6\u51fa\u9519\uff01", e);
        }
    }

    @Override
    public FilterScheme[] loadFilterSchemesSharedByUserAndOrgUnit(String reportPath, BIReportFilter filter) throws RepositoryException {
        SMFolder smFilterSchemeFolder = this.getFilterSchemeFolder(reportPath);
        if (smFilterSchemeFolder == null) {
            return new FilterScheme[0];
        }
        PropertyInfo p1 = new PropertyInfo("shareStrategy", "0");
        PropertyInfo p2 = new PropertyInfo("shareStrategy", null);
        ResourceInfo r1 = new ResourceInfo(null, p1);
        ResourceInfo r2 = new ResourceInfo(null, p2);
        SMSearchInfo s1 = new SMSearchInfo(r1, false);
        SMSearchInfo s2 = new SMSearchInfo(r2, false);
        ArrayList<SMResource> smSchemes = new ArrayList<SMResource>();
        try {
            smSchemes.addAll(Arrays.asList(smFilterSchemeFolder.search(s1)));
            smSchemes.addAll(Arrays.asList(smFilterSchemeFolder.search(s2)));
        }
        catch (SMException e) {
            throw new RepositoryException("\u67e5\u627e\u6307\u5b9a\u62a5\u8868\u7684\u8fc7\u6ee4\u65b9\u6848\u5931\u8d25\uff01", e);
        }
        return this.generateFilterSchemes(smSchemes, reportPath, filter);
    }

    @Override
    public FilterScheme[] loadFilterSchemesSharedByUser(String reportPath, BIReportFilter filter, String user, boolean isSuperUser) throws RepositoryException {
        SMSearchInfo s;
        ResourceInfo r;
        SMFolder smFilterSchemeFolder = this.getFilterSchemeFolder(reportPath);
        if (smFilterSchemeFolder == null) {
            return new FilterScheme[0];
        }
        if (isSuperUser) {
            PropertyInfo p = new PropertyInfo("shareStrategy", "1");
            r = new ResourceInfo(null, p);
            s = new SMSearchInfo(r, false);
        } else {
            PropertyInfo[] ps = new PropertyInfo[]{new PropertyInfo("shareStrategy", "1"), new PropertyInfo("creatorID", user)};
            r = new ResourceInfo(null);
            r.setPropertyInfos(ps);
            s = new SMSearchInfo(r, false);
        }
        ArrayList<SMResource> smSchemes = new ArrayList<SMResource>();
        try {
            smSchemes.addAll(Arrays.asList(smFilterSchemeFolder.search(s)));
        }
        catch (SMException e) {
            throw new RepositoryException("\u67e5\u627e\u6307\u5b9a\u62a5\u8868\u7684\u8fc7\u6ee4\u65b9\u6848\u5931\u8d25\uff01", e);
        }
        return this.generateFilterSchemes(smSchemes, reportPath, filter);
    }

    @Override
    public FilterScheme[] loadFilterSchemesSharedByOrgUnit(String reportPath, BIReportFilter filter, OrgUnitInfo info) throws RepositoryException {
        SMFolder smFilterSchemeFolder = this.getFilterSchemeFolder(reportPath);
        if (smFilterSchemeFolder == null) {
            return new FilterScheme[0];
        }
        PropertyInfo[] ps = new PropertyInfo[]{new PropertyInfo("shareStrategy", "2"), new PropertyInfo("creatorOrgUnitID", info == null ? "null" : info.getId() + "")};
        ResourceInfo r = new ResourceInfo(null);
        r.setPropertyInfos(ps);
        SMSearchInfo s = new SMSearchInfo(r, false);
        ArrayList<SMResource> smSchemes = new ArrayList<SMResource>();
        try {
            smSchemes.addAll(Arrays.asList(smFilterSchemeFolder.search(s)));
        }
        catch (SMException e) {
            throw new RepositoryException("\u67e5\u627e\u6307\u5b9a\u62a5\u8868\u7684\u8fc7\u6ee4\u65b9\u6848\u5931\u8d25\uff01", e);
        }
        return this.generateFilterSchemes(smSchemes, reportPath, filter);
    }

    private SMFolder getReportNode(String reportPath, boolean noExcpetion) throws RepositoryException {
        SMFolder smf = null;
        try {
            smf = (SMFolder)this.getExplorer("RPT").getResourceByPath(reportPath);
        }
        catch (SMException e) {
            if (noExcpetion) {
                return null;
            }
            throw new RepositoryException("\u5b58\u50a8\u5e93\u4e2d\u672a\u627e\u5230\u6307\u5b9a\u62a5\u8868\uff01", e);
        }
        return smf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delFilterScheme(String caption, String reportPath, String currentUser, boolean isSuperUser) throws RepositoryException {
        Explorer explore;
        SMResource smFilterScheme = null;
        try {
            SMFolder parentNode = (SMFolder)this.getReportNode(reportPath, false).getChild(JCR_FILTER_SCHEME_FOLDER);
            if (!this.isNodeCaptionExisted(parentNode, caption)) {
                throw new SMExistException("");
            }
            smFilterScheme = this.getNodeResourceByCaption(parentNode, caption);
        }
        catch (SMExistException e) {
            throw new RepositoryException("\u5b50\u7ed3\u70b9" + caption + "\u4e0d\u5b58\u5728\uff01", e);
        }
        catch (SMException e) {
            throw new RepositoryException("\u67e5\u627e\u5b50\u7ed3\u70b9" + caption + "\u5931\u8d25\uff01\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
        }
        Explorer explorer = explore = this.getExplorer("RPT");
        synchronized (explorer) {
            try {
                if (currentUser == null) {
                    currentUser = currentUser + "";
                }
                String creatorID = "null";
                try {
                    creatorID = smFilterScheme.getProperty("creatorID");
                }
                catch (SMExistException sMExistException) {
                    // empty catch block
                }
                if (!isSuperUser && !currentUser.equals(creatorID)) {
                    throw new RepositoryException("\u60a8\u4e0d\u662f\u8be5\u65b9\u6848\u7684\u521b\u5efa\u8005\u6216\u8005\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u5220\u9664\u8be5\u8fc7\u6ee4\u65b9\u6848");
                }
                explore.setAtomicSave(false);
                smFilterScheme.delete();
                explore.save();
            }
            catch (SMException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException("\u5220\u9664\u5b50\u7ed3\u70b9" + caption + "\u5931\u8d25\uff01", e);
            }
            finally {
                explore.setAtomicSave(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMFolder getReportFilterSchemeFolder(String reportPath, boolean bCreate, Explorer explore) throws RepositoryException {
        SMFolder reportNode = this.getReportNode(reportPath, false);
        SMFolder smFilterSchemeFolder = null;
        try {
            smFilterSchemeFolder = (SMFolder)reportNode.getChild(JCR_FILTER_SCHEME_FOLDER);
        }
        catch (SMExistException sMExistException) {
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        if (smFilterSchemeFolder == null && bCreate) {
            RepositoryImpl repositoryImpl = this;
            synchronized (repositoryImpl) {
                try {
                    explore.setAtomicSave(false);
                    smFilterSchemeFolder = (SMFolder)reportNode.addChild(JCR_FILTER_SCHEME_FOLDER, 1);
                    explore.save();
                }
                catch (SMException e) {
                    this.rollbackTrans(explore);
                    throw new RepositoryException("\u521b\u5efa\u5b50\u7ed3\u70b9filter_scheme\u5931\u8d25\uff01\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
                }
                finally {
                    explore.setAtomicSave(true);
                }
            }
        }
        return smFilterSchemeFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFilterScheme(FilterScheme fs, String currentUser, boolean isSuperUser) throws RepositoryException {
        Explorer explore = this.getExplorer("RPT");
        SMFolder filterSchemeFolder = this.getReportFilterSchemeFolder(fs.getReportPath(), true, explore);
        SMFile filterSchemeNode = null;
        Explorer explorer = explore;
        synchronized (explorer) {
            try {
                if (this.isNodeCaptionExisted(filterSchemeFolder, fs.getCaption())) {
                    SMResource smr = this.getNodeResourceByCaption(filterSchemeFolder, fs.getCaption());
                    fs.setSchmeName(smr.getName());
                }
                try {
                    filterSchemeNode = (SMFile)filterSchemeFolder.getChild(fs.getSchmeName());
                }
                catch (SMExistException smr) {
                    // empty catch block
                }
                explore.setAtomicSave(false);
                if (filterSchemeNode == null) {
                    filterSchemeNode = (SMFile)filterSchemeFolder.addChild(fs.getSchmeName(), 16);
                } else {
                    if (currentUser == null) {
                        currentUser = currentUser + "";
                    }
                    String creatorID = "null";
                    try {
                        creatorID = filterSchemeNode.getProperty("creatorID");
                    }
                    catch (SMExistException sMExistException) {
                        // empty catch block
                    }
                    if (!isSuperUser && !currentUser.equals(creatorID)) {
                        throw new RepositoryException("\u6307\u5b9a\u540d\u79f0\u7684\u8fc7\u6ee4\u65b9\u6848\u5df2\u7ecf\u5b58\u5728\uff0c\u800c\u60a8\u4e0d\u662f\u5176\u521b\u5efa\u8005\uff0c\u56e0\u6b64\u4e0d\u80fd\u8986\u76d6\u8be5\u8fc7\u6ee4\u65b9\u6848\u3002\u60a8\u53ef\u4ee5\u9009\u62e9\u5c06\u5176\u4fdd\u5b58\u4e3a\u4e00\u4e2a\u65b0\u7684\u8fc7\u6ee4\u65b9\u6848");
                    }
                }
                Document doc = fs.toDocument();
                StringWriter sw = new StringWriter();
                XmlUtil.print(doc, sw);
                filterSchemeNode.write(sw.toString().getBytes("UTF-8"));
                filterSchemeNode.setProperty("caption", fs.getCaption());
                filterSchemeNode.setProperty("creatorID", fs.getShareStrategy().getCreatorID());
                filterSchemeNode.setProperty("creatorOrgUnitID", fs.getShareStrategy().getCreatorOrgUnitID());
                filterSchemeNode.setProperty("createTime", fs.getShareStrategy().getCreateTime().getTimeInMillis() + "");
                filterSchemeNode.setProperty("lastUpdateTime", fs.getShareStrategy().getLastUpdateTime().getTimeInMillis() + "");
                filterSchemeNode.setProperty("shareStrategy", fs.getShareStrategy().getShareStrategy());
                explore.save();
            }
            catch (SMException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            finally {
                explore.setAtomicSave(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String saveResource(boolean overwrite, String parent, String caption, String resName, byte[] data, String imageType) throws RepositoryException {
        Explorer explore;
        String ret = "";
        SMFolder smParent = this.resourceTreeRoot;
        SMResource smNode = null;
        Explorer explorer = explore = this.getExplorer("DBD");
        synchronized (explorer) {
            if (!parent.equals("")) {
                smParent = this.getParentFolder(this.resourceTreeRoot, parent, false);
            }
            try {
                SMResource[] sr = this.findNodeByCaption(smParent, caption);
                if (sr.length > 0) {
                    if (!overwrite) throw new RepositoryException("\u6307\u5b9a\u8d44\u6e90\u540d\u79f0\"" + caption + "\"\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u6307\u5b9a\u53e6\u5916\u7684\u540d\u79f0\u6216\u8005\u9009\u62e9\u5f3a\u5236\u8986\u76d6\uff01");
                    if (!(sr[0] instanceof SMFile)) throw new RepositoryException("\u6307\u5b9a\u8d44\u6e90\u540d\u79f0\"" + caption + "\"\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6\u5939\uff0c\u6587\u4ef6\u5939\u4e0d\u80fd\u5f3a\u5236\u8986\u76d6\uff0c\u8bf7\u6307\u5b9a\u53e6\u5916\u7684\u540d\u79f0\uff01");
                    smNode = sr[0];
                }
                explore.setAtomicSave(false);
                if (smNode == null) {
                    smNode = smParent.addChild(resName, 16);
                }
                ((SMFile)smNode).setContent((InputStream)new ByteArrayInputStream(data));
                smNode.setProperty("imageType", ExportType.parseTypeFromSuffix(imageType));
                smNode.setProperty("caption", caption);
                explore.save();
                ret = smNode.getPath();
            }
            catch (SMException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            finally {
                explore.setAtomicSave(true);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String savePiece(Piece piece, String caller) throws RepositoryException {
        String ret = "";
        SMFolder smParent = this.pieceRoot;
        Explorer explore = this.getExplorer("RPT");
        SMResource smPiece = null;
        String caption = piece.getCaption();
        Explorer explorer = explore;
        synchronized (explorer) {
            if (!piece.getParentPath().equals("")) {
                smParent = this.getParentFolder(smParent, piece.getParentPath(), true);
            }
            try {
                if (this.isNodeCaptionExisted(smParent, caption)) {
                    SMResource oldPiece = this.getNodeResourceByCaption(smParent, caption);
                    if (BISystem.isPiecePerByUser(this) && !PieceUtil.canUse(caller, oldPiece)) {
                        throw new RepositoryException("\u5176\u5b83\u7528\u6237\u5df2\u521b\u5efa\u540c\u540d\u7247\u6bb5\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d!");
                    }
                    piece.setName(oldPiece.getName());
                }
                try {
                    smPiece = smParent.getChild(piece.getName());
                    if (!(smPiece instanceof SMFile)) {
                        throw new RepositoryException("\u7247\u6bb5\u540d\"" + piece.getName() + "\"\u4e0d\u53ef\u7528,\u5df2\u6709\u540c\u540d\u76ee\u5f55!");
                    }
                }
                catch (SMExistException oldPiece) {
                    // empty catch block
                }
                explore.setAtomicSave(false);
                if (smPiece == null) {
                    smPiece = smParent.addChild(piece.getName(), 16);
                }
                smPiece.setProperty("themeID", piece.getThemeID());
                smPiece.setProperty("userID", caller);
                smPiece.setProperty("caption", caption);
                smPiece.setProperty("type", piece.getType());
                smPiece.setProperty("componentType", "" + piece.getComponentType());
                if (piece.getType() == "dynamic" && piece.getComponentType() == "chart") {
                    smPiece.setProperty("charType", ((DynamicPiece)piece).getChartType());
                }
                ((SMFile)smPiece).write(piece.toBinaryData());
                explore.save();
                ret = smPiece.getPath();
            }
            catch (SMException e) {
                this.rollbackTrans(explore);
                throw new RepositoryException(e.getMessage());
            }
            finally {
                explore.setAtomicSave(true);
            }
        }
        return ret;
    }

    private String getFolderTreeVersion(SMFolder folder) throws RepositoryException {
        try {
            return folder.getProperty(JCR_FOLDER_TREE_VERSIOIN_KEY);
        }
        catch (SMExistException e) {
            return null;
        }
        catch (SMException e) {
            throw new RepositoryException("\u65e0\u6cd5\u83b7\u53d6\u5b58\u50a8\u6811\u7684\u7248\u672c!", e);
        }
    }

    private String getReportTreeVersion() throws RepositoryException {
        return this.getFolderTreeVersion(this.reportTreeRoot);
    }

    private String getDashboardTreeVersion() throws RepositoryException {
        return this.getFolderTreeVersion(this.dashboardTreeRoot);
    }

    @Override
    public boolean nodeIsFile(String wsName, String path) {
        SMResource res = null;
        try {
            res = this.getResourceByPath(wsName, path);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return false;
        }
        return res instanceof SMFile;
    }

    @Override
    public boolean nodeExist(String wsName, String path) {
        SMResource res = null;
        try {
            res = this.getResourceByPath(wsName, path);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return false;
        }
        return res != null;
    }

    public Connection getConnection() throws RepositoryException {
        try {
            return this.conCreator.getConnection(this.dataCenter);
        }
        catch (SQLException e) {
            throw new RepositoryException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25!\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void init(String dataCenter, String user, String cu, boolean isWeb) throws RepositoryException {
        this.dataCenter = dataCenter;
        this.isWeb = isWeb;
        reportExplorer = ExplorerFactory.getInst((IConnectionCreator)this.conCreator, (String)dataCenter, (String)"RPT");
        this.mapExplore.put("RPT", reportExplorer);
        dashboardExplorer = ExplorerFactory.getInst((IConnectionCreator)this.conCreator, (String)dataCenter, (String)"DBD");
        this.mapExplore.put("DBD", dashboardExplorer);
        try {
            var7_7 = reportExplorer;
            synchronized (var7_7) {
                this.reportTreeRoot = this.getParentFolder(reportExplorer.getRootFolder(), "report_tree", true);
                this.pieceRoot = this.getParentFolder(reportExplorer.getRootFolder(), "piece", true);
            }
            var7_7 = dashboardExplorer;
            synchronized (var7_7) {
                this.dashboardTreeRoot = this.getParentFolder(dashboardExplorer.getRootFolder(), "dashboard_tree", true);
                this.resourceTreeRoot = this.getParentFolder(dashboardExplorer.getRootFolder(), "resource", true);
            }
        }
        catch (SMException e) {
            throw new RepositoryException("\u521d\u59cb\u5316\u5b58\u50a8\u5e93\u65f6\u51fa\u9519\uff01", e);
        }
        if (!BISystem.isEAS()) {
            return;
        }
        e = RepositoryImpl.mapUpgrade;
        synchronized (e) {
            if (RepositoryImpl.mapUpgrade.containsKey(dataCenter)) {
                return;
            }
            RepositoryImpl.mapUpgrade.put(dataCenter, new Boolean(true));
        }
        forceUpgrade = false;
        var8_11 = reportExplorer;
        synchronized (var8_11) {
            reportTreeVersion = this.getReportTreeVersion();
            con = null;
            try {
                if (forceUpgrade || StringUtils.isEmpty((String)reportTreeVersion)) {
                    RepositoryImpl.logger.info((Object)"starting upgrade report tree...");
                    con = this.getConnection();
                    MetaData_EAS.upgradeReportTree(con, this, user, cu, this.reportTreeRoot);
                    this.reportTreeRoot.setProperty("tree_version", "6.10");
                    RepositoryImpl.logger.info((Object)"upgrade report tree ok!");
                }
                ** if (con == null) goto lbl-1000
            }
            catch (BIReportException e) {
                RepositoryImpl.logger.error((Object)"\u5347\u7ea7\u62a5\u8868\u6811\u5931\u8d25,\u65e0\u6cd5\u83b7\u53d6EAS\u4e0a\u4e0b\u6587\uff01", (Throwable)e);
                ** if (con == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    SQLUtils.cleanup((Connection)con);
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (SMException e) {
                RepositoryImpl.logger.error((Object)"\u5347\u7ea7\u62a5\u8868\u6570\u5931\u8d25\uff01", (Throwable)e);
                ** if (con == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    SQLUtils.cleanup((Connection)con);
                }
lbl-1000:
                // 2 sources

                {
                }
                {
                    catch (Throwable var12_21) {
                        if (con != null) {
                            SQLUtils.cleanup(con);
                        }
                        throw var12_21;
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                SQLUtils.cleanup((Connection)con);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        var8_11 = dashboardExplorer;
        synchronized (var8_11) {
            dashboardTreeVersion = this.getDashboardTreeVersion();
            con = null;
            try {
                if (forceUpgrade || StringUtils.isEmpty((String)dashboardTreeVersion)) {
                    RepositoryImpl.logger.info((Object)"starting upgrade dashboard tree...");
                    con = this.getConnection();
                    MetaData_EAS.upgradeDashboardTree(con, this, user, cu, this.dashboardTreeRoot);
                    this.upgradeDashboardTreeRef(this.dashboardTreeRoot);
                    this.dashboardTreeRoot.setProperty("tree_version", "6.10");
                    RepositoryImpl.logger.info((Object)"upgrade dashboard tree ok!");
                }
            }
            catch (BIReportException e) {
                RepositoryImpl.logger.error((Object)"\u5347\u7ea7\u4eea\u8868\u677f\u6811\u5931\u8d25,\u65e0\u6cd5\u83b7\u53d6EAS\u4e0a\u4e0b\u6587\uff01", (Throwable)e);
            }
            catch (SMException e) {
                RepositoryImpl.logger.error((Object)"\u5347\u7ea7\u4eea\u8868\u677f\u6811\u5931\u8d25\uff01", (Throwable)e);
            }
            finally {
                if (con != null) {
                    SQLUtils.cleanup((Connection)con);
                }
            }
        }
    }

    public static String getPieceURL(String fullpath) throws RepositoryException {
        String prefix = "/piece/";
        if (fullpath != null && fullpath.length() >= prefix.length()) {
            return fullpath.substring(prefix.length());
        }
        throw new RepositoryException("\u6307\u5b9a\u7684\u8def\u5f84" + fullpath + "\u4e0d\u662f\u5408\u6cd5\u7684\u7247\u6bb5\u8def\u5f84\uff01");
    }

    @Override
    public String getReportURLFromPiece(String pieceRepPath, String contextPath) throws RepositoryException {
        String reportURL = "";
        try {
            SMFile pieceFile = (SMFile)this.getExplorer("RPT").getResourceByPath(pieceRepPath);
            String pieceType = pieceFile.getProperty("type");
            if (pieceType == "snapshot") {
                throw new RepositoryException("\u9759\u6001\u7247\u6bb5\u4e0d\u652f\u6301\u7a7f\u900f\uff01");
            }
            String themeRepPath = pieceFile.getProperty("themeID");
            String servletURL = contextPath + "/" + Constants.SERVLET_URL;
            reportURL = "../html/report_loader.htm?servletURL=" + servletURL + "&load=" + servletURL + "?" + "servletType" + "=" + "report" + "&" + "repositoryPath" + "=" + themeRepPath;
        }
        catch (SMExistException e) {
            throw new RepositoryException("\u8bfb\u53d6\u4e3b\u9898\u8def\u5f84\u5931\u8d25\uff01\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
        }
        catch (SMException e) {
            throw new RepositoryException("\u5b58\u50a8\u5e93\u64cd\u4f5c\u5931\u8d25\uff01\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage());
        }
        return reportURL;
    }

    @Override
    public String getRelationPath(String wsName, String path, String basePath) throws RepositoryException {
        try {
            SMResource res = this.getResourceByPath(wsName, path);
            if (res instanceof SMFile) {
                SMFile file = (SMFile)res;
                String filePath = file.getPath();
                if (filePath.equals(basePath)) {
                    throw new RepositoryException("\u4e0d\u5e94\u8be5\u5b58\u5728\u540c\u540d\u7684\u7ed3\u70b9\u548c\u76ee\u5f55!");
                }
                if (filePath.startsWith(basePath)) {
                    return filePath.substring(basePath.length() + 1);
                }
                throw new RepositoryException("\u65e0\u6cd5\u627e\u5230\u76f8\u5bf9\u8def\u5f84!");
            }
            SMFolder folder = (SMFolder)res;
            String folerPath = folder.getPath();
            if (folerPath.equals(basePath)) {
                return "";
            }
            if (folerPath.startsWith(basePath)) {
                return folerPath.substring(basePath.length() + 1);
            }
            throw new RepositoryException("\u65e0\u6cd5\u627e\u5230\u76f8\u5bf9\u8def\u5f84!");
        }
        catch (SMException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public String saveDataSource(HttpServletRequest req) throws RepositoryException {
        String dsPath = req.getParameter("dsPath");
        String dsName = req.getParameter("datasourceName");
        String dsType = req.getParameter("datasourceType");
        String dsContent = req.getParameter("datasourceContent");
        String dsDescription = req.getParameter("dataDescription");
        String[] outputColumns = req.getParameterValues("outputColumns");
        if (dsPath == null) {
            dsPath = IDGenerator.getUUID();
        }
        return dsPath;
    }

    public String getAllDataSourceCaptions(HttpServletRequest req) throws RepositoryException {
        return "caption1\u0002uuid1\u0001caption2\u0002uuid2\u0001caption3\u0002uuid3";
    }

    public Map getDataSourceByID(HttpServletRequest req) throws RepositoryException {
        String dsPath = req.getParameter("dsPath");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dsPath", dsPath);
        map.put("name", "testName");
        map.put("type", "sql");
        map.put("saveLocation", "repository");
        map.put("content", "select * from state");
        map.put("description", "test description");
        ArrayList outputColumns = new ArrayList();
        map.put("outputColumns", outputColumns);
        return map;
    }

    public String deleteDataSource(HttpServletRequest req) throws RepositoryException {
        String dsPath = req.getParameter("dsPath");
        return "ok";
    }

    private void upgradeDashboardTreeRef(SMFolder folder) {
        SMResource[] rs = null;
        try {
            rs = folder.getChildren();
        }
        catch (SMException e1) {
            logger.error((Object)("\u5347\u7ea7\u4eea\u8868\u677f\u6811\u7ed3\u70b9\u65f6\uff0c\u8bfb\u53d6" + folder + "\u5b50\u7ed3\u70b9\u51fa\u9519"), (Throwable)e1);
            return;
        }
        for (int n = 0; n < rs.length; ++n) {
            String xml;
            if (rs[n] instanceof SMFolder) {
                this.upgradeDashboardTreeRef((SMFolder)rs[n]);
                continue;
            }
            try {
                xml = this.getDashboardXML((SMFile)rs[n]);
            }
            catch (RepositoryException e) {
                logger.error((Object)("\u5347\u7ea7\u4eea\u8868\u677f\u6811\u7ed3\u70b9\u65f6\uff0c\u8bfb\u53d6" + folder + "\u7b2c" + n + "\u4e2a\u7ed3\u70b9\u7684xml\u51fa\u9519"), (Throwable)e);
                continue;
            }
            try {
                this.writeDashboardRefInfo((SMFile)rs[n], xml);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("\u5347\u7ea7\u4eea\u8868\u677f\u6811\u7ed3\u70b9\u65f6\uff0c\u66f4\u65b0" + folder + "\u7b2c" + n + "\u4e2a\u7ed3\u70b9\u7684\u5f15\u7528\u4fe1\u606f\u51fa\u9519"), (Throwable)e);
            }
        }
    }

    private void writeDashboardRefInfo(SMFile node, String xml) throws DocumentException, SMException {
        DashBoard ds = new DashBoard(xml);
        node.setProperty(JCR_NODE_PROP_REFPIECE_KEY, StringUtils.arrayToString((Object[])ds.getPieces().toArray(), (String)JCR_PROP_REFRESOURCE_SEPERATOR));
        ArrayList refPicture = new ArrayList();
        refPicture.addAll(ds.getNavigationPicPaths());
        refPicture.addAll(ds.getResources());
        node.setProperty(JCR_NODE_PROP_REFRESOURCE_KEY, StringUtils.arrayToString((Object[])refPicture.toArray(), (String)JCR_PROP_REFRESOURCE_SEPERATOR));
    }

    @Override
    public void testDashboardCall(String user, String cu, Context ctx) {
        int call_number = new Random().nextInt(8);
        String call_uuid = IDGenerator.getUUID();
        String call_no = IDGenerator.getID();
        try {
            block1 : switch (call_number) {
                case 0: {
                    String dirName = "dir" + call_uuid;
                    String dirCaption = "dirCaption" + call_uuid;
                    this.addNewDirectory("", dirCaption, dirName, 4, user, cu);
                    break;
                }
                case 1: {
                    String dirName = "dir" + call_uuid;
                    String dirCaption = "dirCaption" + call_uuid;
                    this.addNewDirectory("", dirCaption, dirName, 5, user, cu);
                    break;
                }
                case 2: {
                    SMResource[] sm = this.resourceTreeRoot.getChildren();
                    for (int i = 0; i < sm.length; ++i) {
                        if (!(sm[i] instanceof SMFolder)) continue;
                        String name = sm[i].getName();
                        this.renameDirectory("", name, "new" + name, 4, user, cu);
                        break block1;
                    }
                    break;
                }
                case 3: {
                    SMResource[] sm = this.dashboardTreeRoot.getChildren();
                    for (int i = 0; i < sm.length; ++i) {
                        if (!(sm[i] instanceof SMFolder)) continue;
                        String name = sm[i].getName();
                        this.renameDirectory("", name, "new" + name, 5, user, cu);
                        break block1;
                    }
                    break;
                }
                case 4: {
                    String name = "dashName" + call_uuid;
                    String caption = "dashCaption" + call_uuid;
                    StringBuffer sb = new StringBuffer();
                    sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    sb.append("<dashboard>");
                    for (int i = 0; i < 2048; ++i) {
                        sb.append("a");
                    }
                    sb.append("</dashboard>");
                    String content = sb.toString();
                    this.saveDashboard("", caption, name, content, user, cu);
                    break;
                }
                case 5: {
                    SMResource[] sm = this.resourceTreeRoot.getChildren();
                    for (int i = 0; i < sm.length; ++i) {
                        if (!(sm[i] instanceof SMFile)) continue;
                        this.delNode(sm[i].getPath(), 4, ctx);
                        break block1;
                    }
                    break;
                }
                case 6: {
                    SMResource[] sm = this.dashboardTreeRoot.getChildren();
                    for (int i = 0; i < sm.length; ++i) {
                        if (!(sm[i] instanceof SMFile)) continue;
                        this.delNode(sm[i].getPath(), 5, ctx);
                        break block1;
                    }
                    break;
                }
                case 7: {
                    String name = "res" + call_uuid;
                    String caption = "rescaption" + call_uuid;
                    this.saveResource(true, "", caption, name, new byte[4096], "jpg");
                    break;
                }
            }
            logger.info((Object)(call_no + "\uff1a\u6210\u529f\u8c03\u7528\u529f\u80fd\u53f7\uff1a" + call_number));
        }
        catch (RepositoryException e1) {
            logger.error((Object)(call_no + "\uff1a\u51fa\u9519\u529f\u80fd\u53f7\uff1a" + call_number), (Throwable)e1);
        }
        catch (SMException e2) {
            logger.error((Object)(call_no + "\uff1a\u51fa\u9519\u529f\u80fd\u53f7\uff1a" + call_number), (Throwable)e2);
        }
    }

    @Override
    public List executeQuery(String ksql) throws RepositoryException {
        Connection cn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList list = new ArrayList();
        try {
            stmt = cn.prepareStatement(ksql);
            rs = stmt.executeQuery(ksql);
            this.putRSToList(rs, list);
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return list;
    }

    private void putRSToList(ResultSet rs, List list) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String name = rsmd.getColumnName(i);
                map.put(name.toLowerCase(), rs.getObject(i));
            }
            list.add(map);
        }
    }

    @Override
    public List execQueryStmt(String sql, Object[] params) throws RepositoryException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList list = new ArrayList();
        try {
            stmt = con.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            rs = stmt.executeQuery();
            this.putRSToList(rs, list);
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return list;
    }

    @Override
    public String executeQuery2(String sql) throws RepositoryException {
        String ret = null;
        PreparedStatement stmt = null;
        Connection con = this.getConnection();
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ret = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return ret;
    }

    @Override
    public int executeUpdate(String ksql) throws RepositoryException {
        Connection cn = this.getConnection();
        PreparedStatement stmt = null;
        int y = 0;
        try {
            stmt = cn.prepareStatement(ksql);
            y = stmt.executeUpdate(ksql);
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        }
        return y;
    }

    @Override
    public String getThemeReportFlag(String wsName, String path) throws RepositoryException {
        SMResource res = this.getResourceByPath(wsName, path);
        String ret = null;
        try {
            ret = res.getProperty("isReport");
        }
        catch (SMExistException sMExistException) {
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        return ret;
    }

    @Override
    public void testCall(String user, String cu, Context ctx) {
    }

    @Override
    public TreeModel getBITree(int treeType) throws RepositoryException {
        BISolution solution = BISystem.getSolution();
        if (solution == null) {
            return null;
        }
        TreeModel treeModel = null;
        try {
            treeModel = solution.getBITree(treeType, this, null);
        }
        catch (BIReportException e) {
            throw new RepositoryException(e);
        }
        return treeModel;
    }

    @Override
    public boolean isFolder(String wsName, String path) throws RepositoryException {
        SMResource res = this.getResourceByPath(this.getExplorer(wsName), path);
        return res instanceof SMFolder;
    }

    @Override
    public boolean isThemeReport(String path) throws RepositoryException {
        SMResource res = this.getResourceByPath(this.getExplorer("RPT"), path);
        String isReport = null;
        try {
            isReport = res.getProperty("isReport");
        }
        catch (SMExistException e) {
            return false;
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        if (isReport != null) {
            return "true".equalsIgnoreCase(isReport);
        }
        return false;
    }

    @Override
    public String getThemeReportType(String path) throws RepositoryException {
        SMResource res = this.getResourceByPath(this.getExplorer("RPT"), path);
        return this.getThemeReportType(res);
    }

    private String getThemeReportType(SMResource res) throws RepositoryException {
        String type = null;
        try {
            type = res.getProperty("themeReportType");
        }
        catch (SMExistException e) {
            type = "olap";
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
        return type;
    }

    @Override
    public Object call(String methodname, Map parameters) throws RepositoryException {
        if ("getPortletProp".equalsIgnoreCase(methodname)) {
            String path = (String)parameters.get("path");
            String ws = (String)parameters.get("workspace");
            String property = (String)parameters.get("propname");
            SMResource res = this.getResourceByPath(this.getExplorer(ws), path);
            String ret = null;
            try {
                ret = res.getProperty(property);
            }
            catch (SMExistException e) {
                return null;
            }
            catch (SMException e) {
                throw new RepositoryException(e);
            }
            return ret;
        }
        return null;
    }

    @Override
    public void saveNodeProperty(String workspace, String nodePath, String propName, String propValue) throws RepositoryException {
        Explorer explore = this.getExplorer(workspace);
        SMResource sr = this.getResourceByPath(explore, nodePath);
        try {
            sr.setProperty(propName, propValue);
        }
        catch (SMException e) {
            String error = "\u4fdd\u5b58\u5c5e\u6027" + propName + ":" + propValue + "\u5931\u8d25!";
            logger.error((Object)error, (Throwable)e);
            throw new RepositoryException(error, e);
        }
    }

    @Override
    public int getColumnType(String sql, String columnName) throws RepositoryException {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        Connection con = this.getConnection();
        int type = 0;
        try {
            stmt = con.prepareStatement(sql);
            rs = stmt.executeQuery();
            ResultSetMetaData rsm = rs.getMetaData();
            int n = rsm.getColumnCount() + 1;
            for (int i = 1; i < n; ++i) {
                String colName = rsm.getColumnName(i);
                if (!colName.equalsIgnoreCase(columnName)) continue;
                type = rsm.getColumnType(i);
                break;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("\u83b7\u53d6\u5b57\u6bb5\u7c7b\u578b\u51fa\u9519\uff01");
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return type;
    }

    @Override
    public String getReportPathCaption(String resourePath) throws RepositoryException {
        SMResource res = this.getResourceByPath(this.getExplorer("RPT"), resourePath);
        try {
            return this.getPathCaption(res, 6);
        }
        catch (SMException e) {
            throw new RepositoryException(e);
        }
    }
}

