/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryContext;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryFactory;
import com.kingdee.bos.ctrl.analysis.web.solution.BIEasEnv;
import com.kingdee.bos.ctrl.analysis.web.solution.BISolution;
import com.kingdee.bos.ctrl.analysis.web.solution.InnerDataSource;
import com.kingdee.bos.ctrl.analysis.web.solution.RunModel;
import com.kingdee.bos.ctrl.analysis.web.solution.datacenter.DataCenterManager;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BISolutionImpl;
import com.kingdee.bos.ctrl.analysis.web.systemconfigure.SystemConfigure;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.FontUtil;
import com.kingdee.bos.ctrl.freechart.chart.JFreeChart;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.olap.ITempTableManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.awt.Font;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class BISystem {
    private static Logger logger = CommonLogger.getLogger(BISystem.class);
    private static RunModel _kdeas = RunModel.EAS;
    private static Constructor ttmConstructor = null;
    private static BISolution solution;
    private static BIEasEnv env;

    public BISystem() {
        _kdeas = RunModel.EAS;
    }

    public static boolean initSolutionByFile(String solution_path, String subjects_path) {
        solution = new BISolutionImpl(solution_path, subjects_path);
        JFreeChart.setEASDefaultFont((Font)FontUtil.getServerFontSupportedChinese());
        _kdeas = RunModel.EAS;
        return true;
    }

    public static String getCurrentUser(HttpServletRequest request) throws BIReportException {
        Context ctx = BISystem.getContext(request);
        if (ctx == null) {
            return null;
        }
        return ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
    }

    public static String getCurrentUserName(HttpServletRequest request) throws BIReportException {
        Context ctx = BISystem.getContext(request);
        if (ctx == null) {
            return null;
        }
        return ContextUtil.getCurrentUserInfo((Context)ctx).getName().toString();
    }

    public static String getCurrentUserNumber(HttpServletRequest request) throws BIReportException {
        Context ctx = BISystem.getContext(request);
        if (ctx == null) {
            return null;
        }
        return ContextUtil.getCurrentUserInfo((Context)ctx).getNumber().toString();
    }

    public static OrgUnitInfo getCurrentOrgUnit(HttpServletRequest request) throws BIReportException {
        Context ctx = BISystem.getContext(request);
        if (ctx == null) {
            return null;
        }
        return ContextUtil.getCurrentOrgUnit((Context)ctx);
    }

    public static String getCurrentOrgUnitID(HttpServletRequest request) throws BIReportException {
        Context ctx = BISystem.getContext(request);
        if (ctx == null) {
            return null;
        }
        return ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
    }

    public static String getCurrentOrgUnitID(Context ctx) {
        return ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
    }

    public static String getCurrentCU(HttpServletRequest request) throws BIReportException {
        Context ctx = BISystem.getContext(request);
        if (ctx == null) {
            return null;
        }
        return ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
    }

    public static void setBIEasEnv(BIEasEnv _env) {
        env = _env;
    }

    public static boolean isShowGlobalParam(HttpServletRequest request) {
        String isShowGlobalParam = "";
        try {
            Repository rep = BISystem.getRepository(request);
            isShowGlobalParam = new SystemConfigure().getShowGlobalParam(rep);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isShowGlobalParam.equalsIgnoreCase("1");
    }

    public static boolean isPiecePerByUser(Context ctx) {
        Repository rep = null;
        try {
            rep = BISystem.getRepository(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BISystem.isPiecePerByUser(rep);
    }

    public static boolean isPiecePerByUser(HttpServletRequest request) {
        Repository rep = null;
        try {
            rep = BISystem.getRepository(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BISystem.isPiecePerByUser(rep);
    }

    public static boolean isPiecePerByUser(Repository rep) {
        String isPiecePerByUser = "";
        try {
            isPiecePerByUser = new SystemConfigure().getPiecePerByUser(rep);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isPiecePerByUser.equalsIgnoreCase("1");
    }

    public static boolean isDsbPerUseView(HttpServletRequest request) {
        Repository rep = null;
        try {
            rep = BISystem.getRepository(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BISystem.isDsbPerUseView(rep);
    }

    public static boolean isDsbPerUseView(Context ctx) {
        Repository rep = null;
        try {
            rep = BISystem.getRepository(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BISystem.isDsbPerUseView(rep);
    }

    private static boolean isDsbPerUseView(Repository rep) {
        String isDsbPerUseView = "";
        try {
            isDsbPerUseView = new SystemConfigure().getDsbPerUseView(rep);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDsbPerUseView.equalsIgnoreCase("1");
    }

    public static String getThemeAnalysisTreeWidth(HttpServletRequest request) {
        try {
            Repository rep = BISystem.getRepository(request);
            return new SystemConfigure().getThemeAnalysisTreeWidth(rep);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return Constants.CONFIGURETYPE_THEMEANALYSISTREEWIDTH_VALUE;
        }
    }

    public static void setEAS(boolean b) {
    }

    public static void setDebug() {
        _kdeas = RunModel.DEBUG;
    }

    public static BIEasEnv getBIEasEnv(HttpServletRequest request) throws BIReportException {
        if (!BISystem.isEAS()) {
            return env;
        }
        Context ctx = BISystem.getContext(request);
        return new BIEasEnv(ctx){

            @Override
            public Object getControlUnit() {
                return ContextUtil.getCurrentCtrlUnit((Context)this.ctx);
            }

            @Override
            public Object getOrgUnit() {
                return ContextUtil.getCurrentOrgUnit((Context)this.ctx);
            }

            @Override
            public Object getUserInfo() {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)this.ctx.getCaller().toString()));
                return userInfo;
            }
        };
    }

    public static BISolution getSolution() {
        if (solution == null) {
            String fileName = System.getProperty("portal.config");
            logger.info((Object)("FILENAME1:" + fileName));
            if (fileName == null) {
                logger.info((Object)"In the BussSolutionListener,init bussSolution error:cann't find the config file!");
                return null;
            }
            fileName = fileName.substring(0, fileName.indexOf("profiles")) + "deploy";
            logger.info((Object)("FILENAME2:" + fileName));
            logger.info((Object)"\u914d\u7f6e\u4e86BIOLAP\u4e13\u7528\u670d\u52a1\uff0csolution\u53ef\u80fd\u4e3a\u7a7a\uff0c\u91cd\u65b0\u8fdb\u884c\u521d\u59cb\u5316");
            BISystem.initSolutionByFile(fileName, "/subjects");
        }
        return solution;
    }

    public static Context getContext(HttpServletRequest request) throws BIReportException {
        if (BISystem.isEAS()) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            if (ctx == null) {
                throw new BIReportException("\u4f1a\u8bdd\u5df2\u5173\u95ed\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
            }
            return ctx;
        }
        return null;
    }

    public static Connection getJdbcConnection(Context ctx) throws SQLException {
        return BISystem.getJdbcConnection(ctx, null);
    }

    public static Connection getJdbcConnection(Context ctx, String datacenter) throws SQLException {
        if (datacenter == null || "".equals(datacenter)) {
            if (!BISystem.isEAS()) {
                return env.getJdbcConnection();
            }
            return EJBFactory.getConnection((Context)ctx);
        }
        return DataCenterManager.getConnection(ctx, datacenter);
    }

    public static Connection getJdbcConnection(HttpServletRequest request) throws SQLException {
        if (!BISystem.isEAS()) {
            return env.getJdbcConnection();
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        return EJBFactory.getConnection((Context)ctx);
    }

    public static Repository getRepository(HttpServletRequest request) throws BIReportException {
        RepositoryContext ctx = new RepositoryContext();
        if (BISystem.isEAS()) {
            ctx.put("DEBUG", Boolean.FALSE);
            ctx.put("DATACENTER", WebContextUtil.getEasContext((HttpServletRequest)request).getAIS());
        } else {
            ctx.put("DEBUG", Boolean.TRUE);
        }
        ctx.put("CURRENT_USER", BISystem.getCurrentUser(request));
        ctx.put("CURRENT_CU", BISystem.getCurrentCU(request));
        ctx.put("CURRENT_USER_NUMBER", BISystem.getCurrentUserNumber(request));
        return RepositoryFactory.createRepository(ctx);
    }

    public static Repository getRepository(Context context) throws BIReportException {
        RepositoryContext ctx = new RepositoryContext();
        ctx.put("DATACENTER", context.getAIS());
        ctx.put("CURRENT_USER", ContextUtil.getCurrentUserInfo((Context)context).getId().toString());
        ctx.put("CURRENT_CU", ContextUtil.getCurrentCtrlUnit((Context)context).getId().toString());
        ctx.put("DEBUG", new Boolean(false));
        ctx.put("CURRENT_USER_NUMBER", ContextUtil.getCurrentUserInfo((Context)context).getNumber());
        return RepositoryFactory.createRepository(ctx);
    }

    public static DataSource getDataSource(HttpServletRequest request) throws BIReportException {
        return new InnerDataSource(BISystem.getContext(request), null);
    }

    public static boolean isEAS() {
        return System.getProperty("bos.config") != null;
    }

    public static ITempTableManager getTempTableManager(HttpServletRequest request) {
        if (BISystem.isEAS()) {
            if (ttmConstructor == null) {
                try {
                    Class<?> ttmClass = Class.forName("com.kingdee.eas.framework.bireport.util.KSQLTempTableManager");
                    ttmConstructor = ttmClass.getConstructor(Context.class);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)"Can't find class:com.kingdee.eas.framework.bireport.util.KSQLTempTableManager.", (Throwable)e);
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            try {
                ITempTableManager ttm = (ITempTableManager)ttmConstructor.newInstance(BISystem.getContext(request));
                return ttm;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return null;
            }
        }
        return null;
    }

    public static int getTimeout() {
        return 10000000;
    }

    public static DataSource getDataSource(HttpServletRequest request, String datacenter) throws BIReportException {
        return new InnerDataSource(BISystem.getContext(request), datacenter);
    }

    static {
        env = null;
    }
}

