/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.def;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.link.DimensionLink;
import com.kingdee.bos.ctrl.analysis.web.solution.BIComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportScheme;
import com.kingdee.bos.ctrl.analysis.web.solution.BISubject;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterImpl;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.AbstractBIReportComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BIReportChartComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BIReportImpl;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BIReportWorksheetComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BITableLayout;
import com.kingdee.bos.ctrl.analysis.web.worklist.WorklistLoader;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BIReportDef {
    private Logger logger = CommonLogger.getLogger(BIReportDef.class);
    private String name;
    private String caption;
    private String path;
    private String subjectPath;
    private BISubject subject;

    public BIReportDef(String subjectPath, String name, String caption, String path, BISubject subject) {
        this.subjectPath = subjectPath;
        this.name = name;
        this.caption = caption;
        this.path = path;
        this.subject = subject;
    }

    public String getPath() {
        return this.path;
    }

    public BIReport createReport() throws BIReportException {
        String reportBasePath = this.subjectPath + File.separator + "report";
        String cubeBasePath = this.subjectPath + File.separator + "cube";
        String dsBasePath = this.subjectPath + File.separator + "datasource";
        String reportPathName = reportBasePath + File.separator + this.path;
        try {
            Node node;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            File fileReport = new File(reportPathName);
            if (!fileReport.exists()) {
                throw new BIReportException("\u62a5\u8868\u4e0d\u5b58\u5728:" + reportPathName);
            }
            Document doc = builder.parse(new File(reportPathName));
            Element rootXML = doc.getDocumentElement();
            String cubeRefPath = XmlUtil.getNodeAttribute(rootXML, "Cube", "ref");
            if (cubeRefPath == null) {
                throw new BIReportException("\u7f3a\u5c11<Cube ref=''/>\u7ed3\u70b9!");
            }
            cubeRefPath = cubeRefPath.startsWith("public:") ? cubeBasePath + File.separator + cubeRefPath.substring("public:".length()) : reportBasePath + File.separator + cubeRefPath;
            String dataSourceRefPath = XmlUtil.getNodeAttribute(rootXML, "DataSource", "ref");
            if (dataSourceRefPath == null) {
                throw new BIReportException("\u7f3a\u5c11<DataSource ref=''/>\u7ed3\u70b9!");
            }
            dataSourceRefPath = dataSourceRefPath.startsWith("public:") ? dsBasePath + File.separator + dataSourceRefPath.substring("public:".length()) : reportBasePath + File.separator + dataSourceRefPath;
            ArrayList<AbstractBIReportComponent> lstComponents = new ArrayList<AbstractBIReportComponent>();
            ArrayList<BIReportScheme> lstSchemes = new ArrayList<BIReportScheme>();
            ArrayList lstWorklist = new ArrayList();
            ArrayList<DimensionLink> lstLinks = new ArrayList<DimensionLink>();
            HashMap<String, BIComponent> mapComponents = new HashMap<String, BIComponent>();
            BIReportFilterImpl filter = null;
            HashMap<String, String> mapMdxQuery = new HashMap<String, String>();
            Node[] mdxQuerys = XmlUtil.getChildNodes((Node)rootXML, "MdxQuery");
            if (mdxQuerys == null || mdxQuerys.length == 0) {
                throw new BIReportException("\u6ca1\u6709\u5b9a\u4e49\u5206\u6790\u65b9\u6848.");
            }
            for (int i = 0; i < mdxQuerys.length; ++i) {
                String name = XmlUtil.getNodeAttribute(mdxQuerys[i], "name");
                String mdx = XmlUtil.getNodeTextContent(mdxQuerys[i]);
                String schemeCaption = XmlUtil.getNodeAttribute(mdxQuerys[i], "caption");
                String schemeTitle = XmlUtil.getNodeAttribute(mdxQuerys[i], "title", "");
                String schemeMemoHead = XmlUtil.getNodeAttribute(mdxQuerys[i], "memoHead", "");
                String schemeMemoTail = XmlUtil.getNodeAttribute(mdxQuerys[i], "memoTail");
                String schemeChartLayout = XmlUtil.getNodeAttribute(mdxQuerys[i], "chartLayout");
                int perPageRows = -1;
                String pageRows = XmlUtil.getNodeAttribute(mdxQuerys[i], "perPageRows");
                if (pageRows != null && !pageRows.equals("")) {
                    try {
                        perPageRows = Integer.parseInt(pageRows);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                BIReportScheme scheme = new BIReportScheme(name, schemeCaption, mdx, schemeTitle, schemeMemoHead, schemeMemoTail, schemeChartLayout, perPageRows);
                lstSchemes.add(scheme);
                mapMdxQuery.put(name, mdx);
            }
            Node[] nodes = XmlUtil.getChildNodes((Node)rootXML, new String[]{"WorksheetComponent", "ChartComponent"});
            for (int i = 0; i < nodes.length; ++i) {
                String mdxQuery;
                String componentCaption;
                String componentName;
                node = nodes[i];
                if (node.getNodeName().equals("WorksheetComponent")) {
                    componentName = XmlUtil.getNodeAttribute(node, "name");
                    componentCaption = XmlUtil.getNodeAttribute(node, "caption");
                    mdxQuery = XmlUtil.getNodeAttribute(node, "mdxQuery");
                    if (mdxQuery == null || mdxQuery.equals("")) continue;
                    Properties pro = new Properties();
                    String showSlicer = XmlUtil.getNodeAttribute(node, "showSlicer");
                    if (showSlicer == null || showSlicer.equals("")) {
                        showSlicer = "true";
                    }
                    if ("true".equals(showSlicer)) {
                        pro.put("showSlicer", "true");
                    } else {
                        pro.put("showSlicer", "false");
                    }
                    String[] attrs = BIReportDef.getWorksheetAttrNames();
                    this.getAttrsToProp(pro, node, attrs);
                    String mdx = (String)mapMdxQuery.get(mdxQuery);
                    BIReportWorksheetComponent com = new BIReportWorksheetComponent(componentName, componentCaption, "worksheet", mdxQuery, mdx, pro);
                    lstComponents.add(com);
                    mapComponents.put(componentName, com);
                    continue;
                }
                componentName = XmlUtil.getNodeAttribute(node, "name");
                componentCaption = XmlUtil.getNodeAttribute(node, "caption");
                mdxQuery = XmlUtil.getNodeAttribute(node, "mdxQuery");
                if (mdxQuery == null || mdxQuery.equals("")) continue;
                Properties prop = new Properties();
                this.getAttrsToProp(prop, node, BIReportDef.getChartAttrNames());
                String mdx = (String)mapMdxQuery.get(mdxQuery);
                BIReportChartComponent com = new BIReportChartComponent(componentName, componentCaption, "chart", mdxQuery, mdx, prop);
                Node datamodelNode = XmlUtil.getChildNode(node, "DataModel");
                if (datamodelNode != null) {
                    com.setDataModelNode(datamodelNode);
                }
                lstComponents.add(com);
                mapComponents.put(componentName, com);
            }
            Node[] links = XmlUtil.getChildNodes((Node)rootXML, "Link");
            for (int i = 0; i < links.length; ++i) {
                node = links[i];
                DimensionLink dl = DimensionLink.from(node);
                if (dl == null) continue;
                lstLinks.add(dl);
            }
            Node filterNode = XmlUtil.getChildNode(rootXML, "FilterComponent");
            if (filterNode != null) {
                filter = new BIReportFilterImpl(filterNode);
                mapComponents.put(filter.getName(), filter);
            }
            Node[] lists = XmlUtil.getChildNodes((Node)rootXML, "ListComponent");
            for (int i = 0; i < lists.length; ++i) {
                node = lists[i];
                WorklistLoader.loadWorklist(node, lstWorklist);
            }
            if (lstComponents.size() <= 0) {
                throw new BIReportException("\u672a\u627e\u5230\u53ef\u7528\u7684\u7ec4\u4ef6!");
            }
            Node nodeLayout = XmlUtil.getChildNode(rootXML, "Layout");
            BITableLayout layout = null;
            if (nodeLayout != null) {
                try {
                    layout = new BITableLayout(nodeLayout, mapComponents);
                }
                catch (Exception datamodelNode) {
                    // empty catch block
                }
            }
            boolean molap = false;
            boolean isDefaultOpenDataDrill = false;
            NodeList optionsList = rootXML.getElementsByTagName("Options");
            if (optionsList.getLength() > 0) {
                NodeList children = optionsList.item(0).getChildNodes();
                for (int index = 0; index < children.getLength(); ++index) {
                    String value;
                    node = children.item(index);
                    if (node.getNodeName().equals("Molap")) {
                        value = XmlUtil.getNodeAttribute(node, "value");
                        molap = "true".equalsIgnoreCase(value);
                        continue;
                    }
                    if (!node.getNodeName().equals("DefaultOpenDataDrill")) continue;
                    value = XmlUtil.getNodeAttribute(node, "value");
                    isDefaultOpenDataDrill = "true".equalsIgnoreCase(value);
                }
            }
            BIReportImpl report = new BIReportImpl(this.name, this.caption, this.path, lstComponents, cubeRefPath, dataSourceRefPath, filter, layout, lstSchemes, this.subjectPath, this.subject, lstLinks, lstWorklist, molap, isDefaultOpenDataDrill);
            return report;
        }
        catch (BIReportException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.info((Object)"\u89e3\u6790\u62a5\u8868\u6587\u4ef6\u51fa\u9519.", (Throwable)e);
            throw new BIReportException("\u89e3\u6790\u62a5\u8868\u6587\u4ef6\u51fa\u9519.", e);
        }
    }

    private void getAttrToProp(Properties prop, Node node, String attrName) {
        String v = XmlUtil.getNodeAttribute(node, attrName, "");
        if (!"".equals(v)) {
            prop.put(attrName, v);
        }
    }

    private void getAttrsToProp(Properties prop, Node node, String[] attrNames) {
        for (int i = 0; i < attrNames.length; ++i) {
            this.getAttrToProp(prop, node, attrNames[i]);
        }
    }

    private static String[] getWorksheetAttrNames() {
        return new String[]{"showColumnHeader", "showColumnDimensionInSlicer", "showRowDimensionInSlicer", "canMoveDimension", "fontSize"};
    }

    private static String[] getChartAttrNames() {
        return new String[]{"chartType", "showChangeType", "chartTitle", "showSlicer", "chartHeight", "chartWidth", "showLegend", "legendPosition", "categoryLabelAlign", "showPercentFormatForValue", "lineMemberUniqueNames", "showPercentFormatForTooltip", "showItemData", "showColumnDimensionInSlicer", "showRowDimensionInSlicer", "canMoveDimension", "radarMinColumnIndex", "radarTargetColumnIndex"};
    }
}

