/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.filter;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.BIWebComponentSupport;
import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.export.ExportType;
import com.kingdee.bos.ctrl.analysis.web.export.ExportUtil;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtFilterHandler;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReportPage;
import com.kingdee.bos.ctrl.analysis.web.globalparam.GloableParamUtil;
import com.kingdee.bos.ctrl.analysis.web.globalparam.GlobalParam;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetup;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.AbstractVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.DataProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.ScriptSQL;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItem;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItemInput;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItemList;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItemSql;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.DataType;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterScheme;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterValue;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.Operator;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.ValueCaptionPair;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.ValueCaptionPairList;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.olap.util.IgnoreCaseString;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilterComponent
extends BIWebComponentSupport
implements FilterValue {
    private static final String TAG_FILTER = "Filter";
    private static final String TAG_FILTER_ROW = "Row";
    private static final String TAG_FILTER_ITEM = "FilterItem";
    private static final String PREFIX_VAR = "$";
    private static final String ATTR_FILTER_ITEM_INDEX = "index";
    private static final String ATTR_FILTER_ITEM_SUBMIT = "submit";
    private static final String ATTR_FILTER_ITEM_CAPTION = "caption";
    private static final String ATTR_FILTER_ITEM_COLUMN = "column";
    private static final String ATTR_FILTER_ITEM_DATATYPE = "dataType";
    private static final String ATTR_FILTER_ITEM_OPERATOR = "operator";
    private static final String ATTR_FILTER_ITEM_REQUIRED = "required";
    private static final String ATTR_FILTER_ITEM_READONLY = "readonly";
    private static final String ATTR_FILTER_ITEM_TYPE = "type";
    private static final String ATTR_FILTER_ITEM_DEFCAPTION = "defaultCaption";
    private static final String ATTR_FILTER_ITEM_DEFVALUE = "defaultValue";
    private static final String ATTR_FILTER_ITEM_SHOWTREE = "showTree";
    private static final String TAG_FILTER_ITEM_LIST = "ListItem";
    private static final String ATTR_FILTER_ITEM_LIST_VALUE = "value";
    private static final String ATTR_FILTER_ITEM_LIST_CAPTION = "caption";
    private ReportPage page;
    private BIReportFilter filterInfo;
    private DataProvider dataProvider;
    private HashMap item2Selected = new HashMap();
    private List macroList = null;
    private Map conditionMap = null;
    private Object[] defaultValueParams;
    private Object[] defaultCaptionParams;
    private static final String valueSeperator = "\u0001";
    private int maxWidth = -1;
    private static final int MAX_ONE_LINE = 5000;

    public FilterComponent(ReportPage page, String id, BIReportFilter filterInfo, DataProvider dataProvider) {
        super(id, filterInfo.getCaption());
        this.page = page;
        this.init(filterInfo, dataProvider);
    }

    @Override
    protected void clearPaginInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document render(HttpServletRequest request) throws Exception {
        boolean PERROW_COLUMN = true;
        BIReportVarProvider varProvider = null;
        if ("olap".equalsIgnoreCase(this.page.getType())) {
            varProvider = new BIReportVarProvider(BISystem.getContext(request), !BISystem.isEAS(), ((BIReportPage)this.page).getSubject().getRuntimeVarFilename(), ((BIReportPage)this.page).getSubject().getRuntimeVarClassname(), this.dataProvider.getDatacenter());
        }
        Document document = XmlUtil.createDocument();
        Element root = document.createElement(TAG_FILTER);
        document.appendChild(root);
        List itemList = this.filterInfo.getItemList();
        this.defaultValueParams = new Object[itemList.size()];
        this.defaultCaptionParams = new Object[itemList.size()];
        int counter = 0;
        Element eleRowNow = root;
        for (BIReportFilterItem item : itemList) {
            Element itemEle = document.createElement(TAG_FILTER_ITEM);
            itemEle.setAttribute(ATTR_FILTER_ITEM_INDEX, Integer.toString(counter + 1));
            eleRowNow.appendChild(itemEle);
            this.renderItem(varProvider, item, itemEle, document, counter, request);
            ++counter;
        }
        if (this.page.canUseRepository()) {
            FilterScheme defaultScheme = FilterScheme.createFilterScheme("\u9ed8\u8ba4\u8fc7\u6ee4\u65b9\u6848", this.defaultValueParams, this.defaultCaptionParams, null, null);
            Element eleSchemeDefault = document.createElement("FilterSchemeItem");
            String defaultCaption = defaultScheme.getCaption();
            defaultCaption = defaultCaption == null ? "\u9ed8\u8ba4\u8fc7\u6ee4\u65b9\u6848" : defaultCaption;
            eleSchemeDefault.setAttribute("schemeName", defaultCaption);
            eleSchemeDefault.setAttribute("schemeValue", defaultScheme.toString());
            root.appendChild(eleSchemeDefault);
            Repository rep = null;
            FilterScheme[] filterSchemes = null;
            if (this.page instanceof ExtReportPage && ((ExtReportPage)this.page).getExtID() != null) {
                BIReportFilter filter = this.page.getReport().getFilter(request);
                filterSchemes = ExtFilterHandler.getFilterSchemes(request, "0", (ExtReportPage)this.page, filter);
            } else {
                rep = BISystem.getRepository(request);
                try {
                    String reportPath = this.page.getReport().getRepositoryPath();
                    BIReportFilter filter = this.page.getReport().getFilter(request);
                    filterSchemes = FilterScheme.getFilterSchemesSharedByUserAndOrgUnit(reportPath, filter, rep);
                }
                finally {
                    if (rep != null) {
                        rep.close();
                    }
                }
            }
            if (filterSchemes != null && filterSchemes.length > 0) {
                for (int i = 0; i <= filterSchemes.length - 1; ++i) {
                    Element eleScheme = document.createElement("FilterSchemeItem");
                    String caption = filterSchemes[i].getCaption();
                    caption = caption == null ? "\u672a\u547d\u540d\u8fc7\u6ee4\u65b9\u6848" : caption;
                    eleScheme.setAttribute("schemeName", caption);
                    eleScheme.setAttribute("schemeValue", filterSchemes[i].toString());
                    root.appendChild(eleScheme);
                }
            }
        }
        return document;
    }

    public void applyFilter(Object[] objParams) throws BIReportException {
        for (int i = 0; i < this.filterInfo.getItemCount(); ++i) {
            BIReportFilterItem item;
            String[] params = null;
            if (objParams[i] != null && ((List)objParams[i]).size() > 0) {
                params = (String[])((List)objParams[i]).toArray();
            }
            if ((item = this.filterInfo.getItem(i)) instanceof BIReportFilterItemInput) {
                if (params == null || params.length == 0) {
                    this.item2Selected.remove(item);
                    continue;
                }
                this.item2Selected.put(item, params);
                continue;
            }
            if (item instanceof BIReportFilterItemList) {
                if (params == null) {
                    this.item2Selected.remove(item);
                    continue;
                }
                this.item2Selected.put(item, params);
                continue;
            }
            if (!(item instanceof BIReportFilterItemSql)) continue;
            if (params == null) {
                this.item2Selected.remove(item);
                continue;
            }
            this.item2Selected.put(item, params);
        }
        this.makeMacroList();
        this.makeFilterConditions();
    }

    @Override
    public List getMacroList() {
        return this.macroList;
    }

    @Override
    public Map getFilterConditions() {
        return this.conditionMap;
    }

    private void init(BIReportFilter filterInfo, DataProvider dataProvider) {
        this.filterInfo = filterInfo;
        this.dataProvider = dataProvider;
    }

    private String calcDefaultValue(String defaultValue, BIReportVarProvider varProvider) throws BIReportException {
        String calcValue = null;
        if (defaultValue != null) {
            if (defaultValue.startsWith(PREFIX_VAR)) {
                ScriptSQL sc = new ScriptSQL();
                calcValue = sc.transSql(defaultValue, (AbstractVarProvider)varProvider, null, null);
            } else {
                calcValue = defaultValue != null & !defaultValue.equals("") ? StringUtil.replace((String)defaultValue, (String)"\\$", (String)PREFIX_VAR) : defaultValue;
            }
        }
        return calcValue;
    }

    private void renderItem(BIReportVarProvider varProvider, BIReportFilterItem item, Element ele, Document doc, int counter, HttpServletRequest request) throws Exception {
        List paramList;
        String caption = item.getCaption();
        String column = item.getColumn();
        String dataType = item.getDataType();
        String operator = item.getOperator();
        String rowLimit = item.getRowLimit();
        String defaultValue = item.getDefaultValue();
        if (dataType.equalsIgnoreCase("date")) {
            defaultValue = this.getF7DateFarmat(defaultValue);
        }
        String defaultCaption = item.getDefaultCaption();
        String globalParam = item.getGlobalParamName();
        boolean required = item.isRequired();
        boolean readonly = item.isReadOnly();
        ele.setAttribute("caption", caption);
        ele.setAttribute(ATTR_FILTER_ITEM_COLUMN, column);
        ele.setAttribute(ATTR_FILTER_ITEM_DATATYPE, dataType);
        ele.setAttribute(ATTR_FILTER_ITEM_OPERATOR, operator);
        ele.setAttribute("rowLimit", rowLimit);
        if (required) {
            ele.setAttribute(ATTR_FILTER_ITEM_REQUIRED, "true");
        }
        if (readonly) {
            ele.setAttribute(ATTR_FILTER_ITEM_READONLY, "true");
        }
        defaultValue = this.calcDefaultValue(defaultValue, varProvider);
        String userID = BISystem.getCurrentUser(request);
        boolean globalParamExist = false;
        if (!StringUtils.isEmpty((String)globalParam) && GloableParamUtil.userParamMap.get(GloableParamUtil.PRE_KEY_GP + userID) != null) {
            paramList = (List)GloableParamUtil.userParamMap.get(GloableParamUtil.PRE_KEY_GP + userID);
            for (int i = 0; i < paramList.size(); ++i) {
                HashMap map = (HashMap)paramList.get(i);
                String paramName = String.valueOf(map.get("fparamname"));
                if (!paramName.equalsIgnoreCase(globalParam)) continue;
                globalParamExist = true;
                break;
            }
        }
        if (globalParamExist) {
            paramList = (List)GloableParamUtil.userParamMap.get(GloableParamUtil.PRE_KEY_GP + userID);
            String paramName = "";
            String paramValue = "";
            String paramCaption = "";
            String ffillterItem = "";
            for (int i = 0; i < paramList.size(); ++i) {
                HashMap map = (HashMap)paramList.get(i);
                paramName = String.valueOf(map.get("fparamname"));
                paramValue = String.valueOf(map.get("fparamvalue"));
                paramCaption = String.valueOf(map.get("fparamcaption"));
                ffillterItem = String.valueOf(map.get("ffillteritem"));
                if (!paramName.equalsIgnoreCase(globalParam)) continue;
                if (dataType.equalsIgnoreCase("date")) {
                    paramValue = this.getF7DateFarmat(paramValue);
                }
                defaultValue = paramValue;
                if (!paramCaption.equalsIgnoreCase("")) break;
                defaultCaption = defaultValue;
                break;
            }
            if (item instanceof BIReportFilterItemInput) {
                if (defaultValue != null) {
                    ele.setAttribute(ATTR_FILTER_ITEM_DEFVALUE, defaultValue);
                    ((BIReportFilterItemInput)item).setRequired(true);
                    ele.setAttribute(ATTR_FILTER_ITEM_REQUIRED, "true");
                }
                ele.setAttribute(ATTR_FILTER_ITEM_TYPE, "input");
            } else if (item instanceof BIReportFilterItemSql) {
                BIReportFilterItemSql sqlItem = (BIReportFilterItemSql)item;
                sqlItem = new GlobalParam().overlayFilterSqlItem(sqlItem, ffillterItem);
                ele.setAttribute(ATTR_FILTER_ITEM_TYPE, "sql");
                if (defaultValue != null) {
                    if ("olap".equalsIgnoreCase(this.page.getType())) {
                        defaultCaption = this.findSqlCaption(varProvider, sqlItem, defaultValue);
                    } else if ("ext".equalsIgnoreCase(this.page.getType())) {
                        defaultCaption = ((ExtReportPage)this.page).getExtReport().getF7ValueCaption(counter, defaultValue, request);
                    }
                    if (defaultCaption != null) {
                        ele.setAttribute(ATTR_FILTER_ITEM_DEFCAPTION, defaultCaption);
                        ele.setAttribute(ATTR_FILTER_ITEM_DEFVALUE, defaultValue);
                    }
                }
                if (sqlItem.needShowTree()) {
                    ele.setAttribute(ATTR_FILTER_ITEM_SHOWTREE, "true");
                }
            } else if (item instanceof BIReportFilterItemList) {
                BIReportFilterItemList listItem = (BIReportFilterItemList)item;
                ele.setAttribute(ATTR_FILTER_ITEM_TYPE, "list");
                ValueCaptionPairList vcpl = listItem.getValueCaptionPairList();
                Iterator iter = vcpl.getPairIterator();
                while (iter.hasNext()) {
                    ValueCaptionPair vcp = (ValueCaptionPair)iter.next();
                    Element lie = doc.createElement(TAG_FILTER_ITEM_LIST);
                    String value = vcp.getValue().toString();
                    String strCaption = vcp.getCaption();
                    lie.setAttribute(ATTR_FILTER_ITEM_LIST_VALUE, value);
                    lie.setAttribute("caption", strCaption);
                    ele.appendChild(lie);
                }
                if (!StringUtils.isEmpty((String)defaultValue) && StringUtils.isEmpty((String)defaultCaption)) {
                    String[] defaultValues = defaultValue.split(",");
                    StringBuffer sbCaption = new StringBuffer();
                    boolean isFirst = true;
                    for (int i = 0; i < defaultValues.length; ++i) {
                        String cap = vcpl.findCaption(defaultValues[i]);
                        if (cap == null) continue;
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sbCaption.append(valueSeperator);
                        }
                        sbCaption.append(cap);
                    }
                    defaultCaption = sbCaption.toString();
                }
                if (defaultCaption != null) {
                    ele.setAttribute(ATTR_FILTER_ITEM_DEFVALUE, defaultValue);
                    ele.setAttribute(ATTR_FILTER_ITEM_DEFCAPTION, defaultCaption);
                }
            }
        } else if (item instanceof BIReportFilterItemInput) {
            if (defaultValue != null) {
                ele.setAttribute(ATTR_FILTER_ITEM_DEFVALUE, defaultValue);
            }
            ele.setAttribute(ATTR_FILTER_ITEM_TYPE, "input");
        } else if (item instanceof BIReportFilterItemSql) {
            BIReportFilterItemSql sqlItem = (BIReportFilterItemSql)item;
            ele.setAttribute(ATTR_FILTER_ITEM_TYPE, "sql");
            if (defaultValue != null) {
                if ("olap".equalsIgnoreCase(this.page.getType())) {
                    defaultCaption = this.findSqlCaption(varProvider, sqlItem, defaultValue);
                    defaultValue = defaultValue.replaceAll(",", valueSeperator);
                } else if ("ext".equalsIgnoreCase(this.page.getType())) {
                    defaultCaption = ((ExtReportPage)this.page).getExtReport().getF7ValueCaption(counter, defaultValue, request);
                    defaultValue = defaultValue.replaceAll("0xx1xx", valueSeperator);
                    defaultCaption = defaultCaption.replaceAll("0xx1xx", valueSeperator);
                }
                if (defaultCaption != null) {
                    ele.setAttribute(ATTR_FILTER_ITEM_DEFCAPTION, defaultCaption);
                    ele.setAttribute(ATTR_FILTER_ITEM_DEFVALUE, defaultValue);
                }
            }
            if (sqlItem.needShowTree()) {
                ele.setAttribute(ATTR_FILTER_ITEM_SHOWTREE, "true");
            }
        } else if (item instanceof BIReportFilterItemList) {
            BIReportFilterItemList listItem = (BIReportFilterItemList)item;
            ele.setAttribute(ATTR_FILTER_ITEM_TYPE, "list");
            ValueCaptionPairList vcpl = listItem.getValueCaptionPairList();
            Iterator iter = vcpl.getPairIterator();
            while (iter.hasNext()) {
                ValueCaptionPair vcp = (ValueCaptionPair)iter.next();
                Element lie = doc.createElement(TAG_FILTER_ITEM_LIST);
                String value = vcp.getValue().toString();
                String strCaption = vcp.getCaption();
                lie.setAttribute(ATTR_FILTER_ITEM_LIST_VALUE, value);
                lie.setAttribute("caption", strCaption);
                ele.appendChild(lie);
            }
            if (!StringUtils.isEmpty((String)defaultValue) && StringUtils.isEmpty((String)defaultCaption)) {
                String[] defaultValues = null;
                if ("olap".equalsIgnoreCase(this.page.getType())) {
                    defaultValues = defaultValue.split(",");
                } else if ("ext".equalsIgnoreCase(this.page.getType())) {
                    defaultValues = defaultValue.split("0xx1xx");
                }
                defaultValue = defaultValue.replaceAll(",", valueSeperator);
                StringBuffer sbCaption = new StringBuffer();
                boolean isFirst = true;
                for (int i = 0; i < defaultValues.length; ++i) {
                    String cap = vcpl.findCaption(defaultValues[i]);
                    if (cap == null) continue;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sbCaption.append(valueSeperator);
                    }
                    sbCaption.append(cap);
                }
                defaultCaption = sbCaption.toString();
            }
            if (defaultCaption != null && defaultValue != null) {
                if ("olap".equalsIgnoreCase(this.page.getType())) {
                    defaultValue = defaultValue.replaceAll(",", valueSeperator);
                    defaultCaption = defaultCaption.replaceAll(",", valueSeperator);
                } else if ("ext".equalsIgnoreCase(this.page.getType())) {
                    defaultValue = defaultValue.replaceAll("0xx1xx", valueSeperator);
                    defaultCaption = defaultCaption.replaceAll("0xx1xx", valueSeperator);
                }
                ele.setAttribute(ATTR_FILTER_ITEM_DEFVALUE, defaultValue);
                ele.setAttribute(ATTR_FILTER_ITEM_DEFCAPTION, defaultCaption);
            }
        }
        this.defaultValueParams[counter] = Arrays.asList((Object[])new Object[]{defaultValue});
        this.defaultCaptionParams[counter] = Arrays.asList((Object[])new Object[]{defaultCaption});
    }

    private String getFilterSql(BIReportVarProvider varProvider, String tableName) throws BIReportException {
        return this.dataProvider.getSql(varProvider, tableName);
    }

    private String[] splitTableColumn(String columnExpr) throws Exception {
        String[] tokens = columnExpr.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tokens.length; ++i) {
            String[] tc = tokens[i].split("\\.");
            if (tc.length != 2) {
                throw new Exception("Column:" + columnExpr + "\u683c\u5f0f\u4e0d\u5bf9\uff0c\u5fc5\u987b\u662fTable.column");
            }
            list.add(tc[0]);
            list.add(tc[1]);
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    private Object getItemCaption(BIReportFilterItem item, BIReportVarProvider varProvider, int itemIndex, HttpServletRequest request) throws Exception {
        String[] caption;
        block5: {
            Object selectedValue;
            String[] selected;
            block6: {
                block4: {
                    caption = null;
                    if (!(item instanceof BIReportFilterItemInput)) break block4;
                    Object selectedValue2 = this.item2Selected.get(item);
                    if (selectedValue2 == null) break block5;
                    caption = (String[])selectedValue2;
                    break block5;
                }
                if (!(item instanceof BIReportFilterItemList)) break block6;
                Object selectedValue3 = this.item2Selected.get(item);
                String[] selected2 = (String[])selectedValue3;
                if (selected2 == null || selected2.length <= 0) break block5;
                caption = new String[selected2.length];
                for (int i = 0; i < selected2.length; ++i) {
                    caption[i] = this.findListCaption((BIReportFilterItemList)item, selected2[i]);
                }
                break block5;
            }
            if (item instanceof BIReportFilterItemSql && (selected = (String[])(selectedValue = this.item2Selected.get(item))) != null && selected.length > 0) {
                caption = new String[selected.length];
                for (int i = 0; i < selected.length; ++i) {
                    if ("olap".equalsIgnoreCase(this.page.getType())) {
                        caption[i] = this.findSqlCaption(varProvider, (BIReportFilterItemSql)item, selected[i]);
                        continue;
                    }
                    if (!"ext".equalsIgnoreCase(this.page.getType())) continue;
                    caption[i] = ((ExtReportPage)this.page).getExtReport().getF7ValueCaption(itemIndex, selected[i], request);
                }
            }
        }
        return caption;
    }

    private String findListCaption(BIReportFilterItemList item, String value) {
        if (value == null) {
            return null;
        }
        ValueCaptionPairList vcpl = item.getValueCaptionPairList();
        Iterator iter = vcpl.getPairIterator();
        while (iter.hasNext()) {
            ValueCaptionPair vcp = (ValueCaptionPair)iter.next();
            String value2 = vcp.getValue().toString();
            String strCaption = vcp.getCaption();
            if (!value2.equals(value)) continue;
            return strCaption;
        }
        return null;
    }

    private Object getItemValue(BIReportFilterItem item) {
        String[] value;
        block4: {
            Object selectedValue;
            String[] selected;
            block5: {
                block3: {
                    value = null;
                    if (!(item instanceof BIReportFilterItemInput)) break block3;
                    Object selectedValue2 = this.item2Selected.get(item);
                    if (selectedValue2 == null) break block4;
                    value = (String[])selectedValue2;
                    break block4;
                }
                if (!(item instanceof BIReportFilterItemList)) break block5;
                Object selectedValue3 = this.item2Selected.get(item);
                String[] selected2 = (String[])selectedValue3;
                if (selected2 == null || selected2.length <= 0) break block4;
                value = new String[selected2.length];
                for (int i = 0; i < selected2.length; ++i) {
                    value[i] = selected2[i];
                }
                break block4;
            }
            if (item instanceof BIReportFilterItemSql && (selected = (String[])(selectedValue = this.item2Selected.get(item))) != null && selected.length > 0) {
                value = new String[selected.length];
                for (int i = 0; i < selected.length; ++i) {
                    value[i] = selected[i];
                }
            }
        }
        return value;
    }

    private void makeMacroList() {
        this.macroList = new ArrayList();
        for (int i = 0; i < this.filterInfo.getItemCount(); ++i) {
            Object value;
            String[] arrayValue;
            BIReportFilterItem item = this.filterInfo.getItem(i);
            String macroName = item.getVarname();
            if (macroName == null || macroName.equals("") || (arrayValue = (String[])(value = this.getItemValue(item))) == null || arrayValue.length <= 0) continue;
            StringBuffer condition = new StringBuffer(macroName + valueSeperator + arrayValue[0]);
            for (int j = 1; j < arrayValue.length; ++j) {
                condition.append("\u0002");
                condition.append(arrayValue[j]);
            }
            this.macroList.add(condition.toString());
        }
    }

    private void makeFilterConditions() throws BIReportException {
        this.conditionMap = new HashMap();
        for (int i = 0; i < this.filterInfo.getItemCount(); ++i) {
            try {
                BIReportFilterItem item = this.filterInfo.getItem(i);
                String columnExpr = item.getColumn();
                if (columnExpr == null || columnExpr.equals("")) continue;
                String[] tcs = this.splitTableColumn(columnExpr);
                String operator = item.getOperator();
                String dataType = item.getDataType();
                Object value = this.getItemValue(item);
                if (value == null) continue;
                for (int j = 0; j < tcs.length; ++j) {
                    String tableName = tcs[j];
                    String columnName = tcs[j + 1];
                    String condition = this.makeCondition(columnName, value, operator, dataType);
                    this.setTableConditions(tableName, condition, this.conditionMap);
                    ++j;
                }
                continue;
            }
            catch (Exception e) {
                throw new BIReportException(e);
            }
        }
    }

    private String makeCondition(String column, Object value, String operator, String dataType) throws Exception {
        return Operator.getExpr(column, value, operator, dataType);
    }

    private void setTableConditions(String tableName, String condition, Map map) {
        IgnoreCaseString tableNameIgnoreCase = new IgnoreCaseString(tableName);
        ArrayList<String> list = (ArrayList<String>)map.get(tableNameIgnoreCase);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(condition);
        map.put(tableNameIgnoreCase, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findSqlCaption(BIReportVarProvider varProvider, BIReportFilterItemSql sqlItem, String value) throws Exception {
        String caption = null;
        String captionColumn = sqlItem.getCaptionColumn();
        String valueColumn = sqlItem.getValueColumn();
        String table = sqlItem.getTable();
        String sql = this.getFilterSql(varProvider, table);
        sql = this.preHandleSql(sql);
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select " + captionColumn);
        sbSql.append(" from (");
        sbSql.append(sql);
        sbSql.append(") a where ");
        sbSql.append(valueColumn);
        sbSql.append(" in(");
        String[] values = value.split(",");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sbSql.append(",");
            }
            sbSql.append(DataType.getString(sqlItem.getDataType(), values[i]));
        }
        sbSql.append(")");
        Connection con = null;
        ResultSet rs = null;
        StringBuilder sbCaption = new StringBuilder();
        try {
            con = BISystem.getJdbcConnection(varProvider.getContext(), varProvider.getDatacenter());
            PreparedStatement statement = con.prepareStatement(sbSql.toString());
            rs = statement.executeQuery(sbSql.toString());
            boolean isFirst = true;
            while (rs.next()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sbCaption.append(valueSeperator);
                }
                Object ret = rs.getObject(captionColumn);
                if (ret instanceof Number) {
                    caption = String.valueOf(ret);
                    sbCaption.append(caption);
                    continue;
                }
                if (ret instanceof Date) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    caption = sdf.format((Date)ret);
                    sbCaption.append(caption);
                    continue;
                }
                caption = String.valueOf(ret);
                sbCaption.append(caption);
            }
            this.close(rs, con);
        }
        catch (Throwable throwable) {
            this.close(rs, con);
            throw throwable;
        }
        return sbCaption.toString();
    }

    public void getSqlValues(BIReportVarProvider varProvider, StringBuffer sb, BIReportFilterItemSql sqlItem) throws Exception {
        String orderString = "";
        String captionColumn = sqlItem.getCaptionColumn();
        String valueColumn = sqlItem.getValueColumn();
        String orderBy = sqlItem.getOrderBy();
        String orderMethod = sqlItem.getOrderMethod();
        if (orderBy.trim().length() > 0) {
            orderString = " order by a." + orderBy + " " + orderMethod;
        }
        String table = sqlItem.getTable();
        String sql = this.getFilterSql(varProvider, table);
        sql = this.preHandleSql(sql);
        sql = "select " + valueColumn + "," + captionColumn + " from (" + sql + ") a " + orderString;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = BISystem.getJdbcConnection(varProvider.getContext(), varProvider.getDatacenter());
            if (con == null) {
                throw new BIReportException("\u6570\u636e\u5e93\u8fde\u63a5\u83b7\u53d6\u5931\u8d25\uff0c\u53ef\u80fd\u6570\u636e\u5e93\u5df2\u5173\u95ed!");
            }
            rs = con.createStatement().executeQuery(sql);
            boolean firstItem = true;
            while (rs.next()) {
                Object value = rs.getObject(valueColumn);
                Object caption = null;
                if (captionColumn != null) {
                    caption = rs.getObject(captionColumn);
                }
                if (!firstItem) {
                    sb.append(valueSeperator);
                }
                sb.append(caption);
                sb.append(valueSeperator);
                sb.append(value);
                firstItem = false;
            }
            this.close(rs, con);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                this.close(rs, con);
                throw throwable;
            }
        }
    }

    private String preHandleSql(String sql) {
        String sqlHandle = sql.toLowerCase();
        int findOrderBy = sqlHandle.indexOf("order by");
        sqlHandle = findOrderBy != -1 ? sql.substring(0, findOrderBy) : sql;
        return sqlHandle;
    }

    public void getSqlValues(BIReportVarProvider varProvider, StringBuffer sb, BIReportFilterItemSql sqlItem, String strParentID) throws Exception {
        String orderString = "";
        String captionColumn = sqlItem.getCaptionColumn();
        String valueColumn = sqlItem.getValueColumn();
        String parentColumn = sqlItem.getParentColumn();
        String childColumn = sqlItem.getChildColumn();
        String isLeafColumn = sqlItem.getIsLeafColumn();
        String orderBy = sqlItem.getOrderBy();
        String orderMethod = sqlItem.getOrderMethod();
        if (orderBy.trim().length() > 0) {
            orderString = " order by a." + orderBy + " " + orderMethod;
        }
        String table = sqlItem.getTable();
        String sql = this.getFilterSql(varProvider, table);
        sql = this.preHandleSql(sql);
        String isLeafColumnAlias = "isLeaf";
        String strLeafColumn = "";
        strLeafColumn = isLeafColumn == null || isLeafColumn.equalsIgnoreCase("") ? "0 AS " + isLeafColumnAlias : isLeafColumn + " AS " + isLeafColumnAlias;
        sql = "select " + valueColumn + "," + captionColumn + "," + childColumn + "," + strLeafColumn + " from (" + sql + ") a where ";
        if (strParentID.equals("")) {
            sql = sql + parentColumn + " is null or " + parentColumn + " = " + childColumn + orderString;
        } else {
            String parentID = DataType.getString(sqlItem.getDataType(), strParentID);
            sql = sql + parentColumn + " = " + parentID + " and " + childColumn + "<>" + parentID + orderString;
        }
        Connection con = null;
        ResultSet rs = null;
        try {
            con = BISystem.getJdbcConnection(varProvider.getContext(), varProvider.getDatacenter());
            PreparedStatement statement = con.prepareStatement(sql);
            rs = statement.executeQuery(sql);
            boolean firstItem = true;
            while (rs.next()) {
                Object value = null;
                Object caption = null;
                Object child = null;
                int isLeaf = 0;
                if (!firstItem) {
                    sb.append(valueSeperator);
                }
                if (valueColumn != null) {
                    value = rs.getObject(valueColumn);
                }
                if (captionColumn != null) {
                    caption = rs.getObject(captionColumn);
                }
                if (childColumn != null) {
                    child = rs.getObject(childColumn);
                }
                isLeaf = rs.getInt(isLeafColumnAlias);
                sb.append(caption);
                sb.append(valueSeperator);
                sb.append(value);
                sb.append(valueSeperator);
                sb.append(child);
                sb.append(valueSeperator);
                sb.append(isLeaf);
                firstItem = false;
            }
            this.close(rs, con);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                this.close(rs, con);
                throw throwable;
            }
        }
    }

    private void close(ResultSet rs, Connection con) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public KDSSheet export(KDSBook book, PageSetup pageSetup, String exportType, int sheetIndex, HttpServletRequest request) throws Exception {
        if (!"olap".equalsIgnoreCase(this.page.getType())) {
            throw new BIReportException("\u4e0d\u652f\u6301\u7684\u8fc7\u6ee4\u5668!");
        }
        BIReportVarProvider varProvider = new BIReportVarProvider(BISystem.getContext(request), !BISystem.isEAS(), ((BIReportPage)this.page).getSubject().getRuntimeVarFilename(), ((BIReportPage)this.page).getSubject().getRuntimeVarClassname(), this.dataProvider.getDatacenter());
        int len = this.filterInfo.getItemCount();
        if (len == 0) {
            return null;
        }
        int row = 0;
        this.maxWidth = 0;
        int lineWidth = pageSetup.getPaperSizeWidth() - pageSetup.getPaperMaginLeft() - pageSetup.getPaperMaginRight();
        lineWidth = (int)UnitConverter.mmToPx((double)lineWidth);
        KDSSheet sheet = new KDSSheet(book, "\u8fc7\u6ee4\u6761\u4ef6");
        if (ExportType.TYPE_PDF.equalsIgnoreCase(exportType)) {
            row = this.renderSheetLine(sheet, row++, "\u8fc7\u6ee4\u6761\u4ef6", lineWidth);
            ++row;
        }
        for (int i = 0; i < len; ++i) {
            BIReportFilterItem item = this.filterInfo.getItem(i);
            Object value = this.getItemCaption(item, varProvider, i, request);
            row = this.renderSheetLine(sheet, row++, item.getCaption() + ":" + this.itemValueToString(value), lineWidth);
        }
        return sheet;
    }

    private String itemValueToString(Object value) {
        String ret = "";
        if (value == null) {
            return ret;
        }
        if (value instanceof Object[]) {
            Object[] arrays = (Object[])value;
            StringBuffer sb = new StringBuffer();
            for (int n = 0; n < arrays.length; ++n) {
                sb.append(arrays[n]);
                if (n == arrays.length - 1) continue;
                sb.append(valueSeperator);
            }
            ret = sb.toString();
            if (ret.length() > 5000) {
                ret = ret.substring(0, 5000) + "...";
            }
        } else {
            return "";
        }
        return ret;
    }

    private int renderSheetLine(KDSSheet sheet, int row, String content, int lineWidth) {
        int rows = 1;
        int col = 0;
        int calcWidth = ExportUtil.calcWidth(sheet, content);
        if (calcWidth > lineWidth) {
            String[] v = content.split(valueSeperator);
            String lineStr = "";
            int width = 0;
            for (int n = 0; n < v.length; ++n) {
                String temp = lineStr;
                width = ExportUtil.calcWidth(sheet, lineStr = lineStr + v[n] + ",");
                if (width <= lineWidth) continue;
                sheet.setCellValue(row, col, (Object)temp);
                sheet.getCellStyleAttributes(row, col).setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                sheet.getCellStyleAttributes(row, col).setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
                ++row;
                lineStr = v[n] + ",";
            }
            sheet.setCellValue(row, col, (Object)lineStr.subSequence(0, lineStr.length() - 1));
            sheet.getCellStyleAttributes(row, col).setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            sheet.getCellStyleAttributes(row, col).setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
            ++row;
            sheet.getColumns().setColumnWidth(col, (float)UnitConverter.px2mm((int)lineWidth));
        } else {
            content = content.replaceAll("\\\u0001", ",");
            sheet.setCellValue(row, col, (Object)content);
            sheet.getCellStyleAttributes(row, col).setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            sheet.getCellStyleAttributes(row, col).setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
            if (calcWidth > this.maxWidth) {
                sheet.getColumns().setColumnWidth(col, (float)UnitConverter.px2mm((int)calcWidth));
                this.maxWidth = calcWidth;
            }
        }
        return row + rows;
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public String getF7DateFarmat(String inputDate) {
        if (inputDate == null || inputDate.equalsIgnoreCase("")) {
            return inputDate;
        }
        String[] dates = inputDate.split("-");
        String date = "";
        for (int i = 0; i < dates.length; ++i) {
            date = date + "/" + dates[i];
        }
        return date.substring("/".length(), date.length());
    }
}

