/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.filter;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.permission.BIPermission_EAS;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.ShareStrategy;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import com.kingdee.bos.ctrl.analysis.web.solution.util.XMLConfig;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jdom2.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilterScheme
implements Serializable {
    private static final long serialVersionUID = -3637880031709852426L;
    private String name = "FILTER" + IDGenerator.getUUID();
    private String caption;
    private String reportPath;
    private Object[] valueParams = null;
    private Object[] captionParams = null;
    private ShareStrategy shareStrategy;
    private boolean isDefault = false;
    private Object[] nameParams = null;
    private static final String TAG_FILTER_SCHEME = "filter_scheme";
    private static final String TAG_FILTER_SCHEME_ITEM = "scheme_item";
    private static final String TAG_VALUE_CAPTION_ITEM = "item";
    private static final String TAG_FILTER_SCHEME_VALUE = "value";
    private static final String TAG_FILTER_SCHEME_CAPTION = "caption";
    private static final String ATTR_FILTER_SCHEME_INDEX = "index";
    private static final String ATTR_FILTER_SCHEME_NAME = "name";
    private static final String ATTR_FILTER_SCHEME_VALUE = "value";
    private static final String FilterParamSeperator = "\u0001";
    private static final String FilterParamMultiSeperator = "\u0002";

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public String getSchmeName() {
        return this.name;
    }

    public void setSchmeName(String name) {
        this.name = name;
    }

    public String getCaption() {
        return this.caption;
    }

    public ShareStrategy getShareStrategy() {
        return this.shareStrategy;
    }

    public void setShareStrategy(ShareStrategy shareStrategy) {
        this.shareStrategy = shareStrategy;
    }

    public Object[] getNameParams() {
        return this.nameParams;
    }

    public static FilterScheme[] getFilterSchemesSharedByUserAndOrgUnit(String reportPath, BIReportFilter filter, Repository rep) throws BIReportException {
        try {
            return rep.loadFilterSchemesSharedByUserAndOrgUnit(reportPath, filter);
        }
        catch (RepositoryException e) {
            throw new BIReportException("\u88c5\u8f7d\u8fc7\u6ee4\u65b9\u6848\u5931\u8d25!", e);
        }
    }

    public static FilterScheme[] getFilterSchemesSharedByUser(String reportPath, BIReportFilter filter, Repository rep, HttpServletRequest req) throws BIReportException {
        try {
            return rep.loadFilterSchemesSharedByUser(reportPath, filter, BISystem.getCurrentUser(req), FilterScheme.isSuperUser(req));
        }
        catch (RepositoryException e) {
            throw new BIReportException("\u88c5\u8f7d\u8fc7\u6ee4\u65b9\u6848\u5931\u8d25!", e);
        }
    }

    public static FilterScheme[] getFilterSchemesSharedByOrgUnit(String reportPath, BIReportFilter filter, Repository rep, HttpServletRequest req) throws BIReportException {
        try {
            return rep.loadFilterSchemesSharedByOrgUnit(reportPath, filter, BISystem.getCurrentOrgUnit(req));
        }
        catch (RepositoryException e) {
            throw new BIReportException("\u88c5\u8f7d\u8fc7\u6ee4\u65b9\u6848\u5931\u8d25!", e);
        }
    }

    public static void delFilterScheme(String caption, String reportPath, Repository rep, HttpServletRequest req) throws BIReportException {
        if (caption == null || "".equals(caption)) {
            throw new BIReportException("\u8fc7\u6ee4\u65b9\u6848\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            rep.delFilterScheme(caption, reportPath, BISystem.getCurrentUser(req), FilterScheme.isSuperUser(req));
        }
        catch (RepositoryException e) {
            throw new BIReportException(e.getMessage());
        }
    }

    public static FilterScheme fromXML(String caption, ShareStrategy ss, String xml, BIReportFilter filter, String reportPath) throws BIReportException {
        ArrayList lstValue = new ArrayList();
        ArrayList lstCaption = new ArrayList();
        XMLConfig xc = null;
        try {
            xc = new XMLConfig(xml, "UTF-8");
            int itemCount = filter.getItemCount();
            for (int index = 0; index < itemCount; ++index) {
                org.jdom2.Element[] nodes = xc.getNodes("/filter_scheme/scheme_item");
                boolean isEmpty = true;
                for (int j = 0; j < nodes.length; ++j) {
                    org.jdom2.Element eleCaption;
                    if (!("" + index).equalsIgnoreCase(nodes[j].getAttributeValue(ATTR_FILTER_SCHEME_INDEX))) continue;
                    org.jdom2.Element eleValue = nodes[j].getChild("value");
                    if (eleValue != null) {
                        isEmpty = false;
                        ArrayList<String> lstTemp = new ArrayList<String>();
                        List lst = eleValue.getChildren();
                        for (org.jdom2.Element ele : lst) {
                            lstTemp.add(ele.getAttributeValue("value"));
                        }
                        lstValue.add(lstTemp);
                    }
                    if ((eleCaption = nodes[j].getChild(TAG_FILTER_SCHEME_CAPTION)) == null) continue;
                    isEmpty = false;
                    ArrayList<String> lstTemp = new ArrayList<String>();
                    List lst = eleCaption.getChildren();
                    for (org.jdom2.Element ele : lst) {
                        lstTemp.add(ele.getAttributeValue("value"));
                    }
                    lstCaption.add(lstTemp);
                }
                if (!isEmpty) continue;
                lstValue.add(new ArrayList());
                lstCaption.add(new ArrayList());
            }
        }
        catch (JDOMException e) {
            throw new BIReportException("XML\u683c\u5f0f\u6709\u9519\u8bef!", e);
        }
        catch (IOException e) {
            throw new BIReportException("XML\u683c\u5f0f\u6709\u9519\u8bef!", e);
        }
        return new FilterScheme(caption, lstValue.toArray(), lstCaption.toArray(), ss, reportPath);
    }

    public static FilterScheme fromNewXML(String caption, ShareStrategy ss, String xml, BIReportFilter filter, String reportPath) throws BIReportException {
        ArrayList lstValue = new ArrayList();
        ArrayList lstCaption = new ArrayList();
        ArrayList<String> lstName = new ArrayList<String>();
        XMLConfig xc = null;
        try {
            xc = new XMLConfig(xml, "UTF-8");
            int itemCount = filter.getItemCount();
            org.jdom2.Element[] nodes = xc.getNodes("/fields/field");
            boolean isEmpty = true;
            if (nodes != null) {
                for (int j = 0; j < nodes.length; ++j) {
                    ArrayList<String> lstTemp1;
                    String value;
                    if (nodes[j].getAttributeValue(ATTR_FILTER_SCHEME_NAME).endsWith("_text")) continue;
                    String name = nodes[j].getAttributeValue(ATTR_FILTER_SCHEME_NAME);
                    if (!StringUtil.isEmptyString((String)name)) {
                        lstName.add(name);
                    }
                    if (!StringUtil.isEmptyString((String)(value = nodes[j].getAttributeValue("value"))) && value.indexOf("0xx1xx") != -1) {
                        value = ExtStringUtil.replace((String)value, (String)"0xx1xx", (String)";");
                    }
                    isEmpty = false;
                    ArrayList<String> lstTemp = new ArrayList<String>();
                    lstTemp.add(value);
                    lstValue.add(lstTemp);
                    String value_caption = nodes[j].getAttributeValue("valueAlias");
                    if (!value_caption.isEmpty()) {
                        isEmpty = false;
                        lstTemp1 = new ArrayList();
                        lstTemp1.add(value_caption);
                        lstCaption.add(lstTemp1);
                        continue;
                    }
                    lstTemp1 = new ArrayList<String>();
                    lstTemp1.add(value);
                    lstCaption.add(lstTemp1);
                }
            }
            if (isEmpty) {
                lstValue.add(new ArrayList());
                lstCaption.add(new ArrayList());
            }
        }
        catch (JDOMException e) {
            throw new BIReportException("XML\u683c\u5f0f\u6709\u9519\u8bef!", e);
        }
        catch (IOException e) {
            throw new BIReportException("XML\u683c\u5f0f\u6709\u9519\u8bef!", e);
        }
        return new FilterScheme(caption, lstValue.toArray(), lstCaption.toArray(), ss, reportPath, lstName.toArray());
    }

    public static FilterScheme fromString(String caption, String strParms, ShareStrategy ss, String reportPath) throws BIReportException {
        ArrayList<List<String>> lstValue = new ArrayList<List<String>>();
        ArrayList<List<String>> lstCaption = new ArrayList<List<String>>();
        String[] parms = StringUtil.splitString((String)strParms, (String)FilterParamSeperator);
        for (int i = 0; i < parms.length; ++i) {
            String[] parmsMulti;
            String str = parms[i];
            if (str.startsWith("V")) {
                String strValue = str.substring(3);
                parmsMulti = StringUtil.splitString((String)strValue, (String)FilterParamMultiSeperator);
                lstValue.add(Arrays.asList(parmsMulti));
                continue;
            }
            if (!str.startsWith("C")) continue;
            String strCaption = str.substring(3);
            parmsMulti = StringUtil.splitString((String)strCaption, (String)FilterParamMultiSeperator);
            lstCaption.add(Arrays.asList(parmsMulti));
        }
        return new FilterScheme(caption, lstValue.toArray(), lstCaption.toArray(), ss, reportPath);
    }

    public static FilterScheme createFilterScheme(String caption, Object[] valueParams, Object[] captionParams, ShareStrategy ss, String reportPath) throws BIReportException {
        return FilterScheme.createFilterScheme(caption, valueParams, captionParams, ss, reportPath, null);
    }

    public static FilterScheme createFilterScheme(String caption, Object[] valueParams, Object[] captionParams, ShareStrategy ss, String reportPath, Object[] nameParams) throws BIReportException {
        if (caption == null || "".equals(caption)) {
            throw new BIReportException("\u8fc7\u6ee4\u65b9\u6848\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        return new FilterScheme(caption, valueParams, captionParams, ss, reportPath, nameParams);
    }

    private FilterScheme(String caption, Object[] valueParams, Object[] captionParams, ShareStrategy ss, String reportPath) throws BIReportException {
        this(caption, valueParams, captionParams, ss, reportPath, null);
    }

    private FilterScheme(String caption, Object[] valueParams, Object[] captionParams, ShareStrategy ss, String reportPath, Object[] nameParams) throws BIReportException {
        this.caption = caption;
        this.reportPath = reportPath;
        this.captionParams = captionParams;
        this.valueParams = valueParams;
        this.shareStrategy = ss;
        this.nameParams = nameParams;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.valueParams != null && this.captionParams != null) {
            for (int i = 0; i < this.valueParams.length; ++i) {
                if (this.nameParams != null && this.nameParams.length != 0) {
                    sb.append("N" + i).append("=").append(this.nameParams[i]);
                    sb.append(FilterParamSeperator);
                }
                List lstParamValue = (List)this.valueParams[i];
                sb.append("V" + i);
                sb.append("=");
                if (lstParamValue != null) {
                    Iterator it = lstParamValue.iterator();
                    boolean first = true;
                    while (it.hasNext()) {
                        Object objValue;
                        if (!first) {
                            sb.append(FilterParamMultiSeperator);
                        }
                        if ((objValue = it.next()) != null) {
                            sb.append(objValue);
                        }
                        first = false;
                    }
                }
                sb.append(FilterParamSeperator);
                List lstParamCaption = (List)this.captionParams[i];
                sb.append("C" + i);
                sb.append("=");
                if (lstParamValue != null) {
                    Iterator it = lstParamCaption.iterator();
                    boolean first = true;
                    while (it.hasNext()) {
                        Object objValue;
                        if (!first) {
                            sb.append(FilterParamMultiSeperator);
                        }
                        if ((objValue = it.next()) != null) {
                            sb.append(objValue);
                        }
                        first = false;
                    }
                }
                sb.append(FilterParamSeperator);
            }
        }
        return sb.toString();
    }

    public void save(Repository rep, HttpServletRequest req) throws BIReportException {
        try {
            rep.saveFilterScheme(this, BISystem.getCurrentUser(req), FilterScheme.isSuperUser(req));
        }
        catch (RepositoryException e) {
            throw new BIReportException(e.getMessage());
        }
    }

    public Document toDocument() {
        Document document = XmlUtil.createDocument();
        Element root = document.createElement(TAG_FILTER_SCHEME);
        document.appendChild(root);
        root.setAttribute(ATTR_FILTER_SCHEME_NAME, this.name);
        if (this.valueParams == null || this.captionParams == null) {
            return null;
        }
        for (int i = 0; i < this.valueParams.length; ++i) {
            Element eleScheme = document.createElement(TAG_FILTER_SCHEME_ITEM);
            eleScheme.setAttribute(ATTR_FILTER_SCHEME_INDEX, "" + i);
            this.appendSchemeItem(document, this.valueParams[i], "value", eleScheme);
            this.appendSchemeItem(document, this.captionParams[i], TAG_FILTER_SCHEME_CAPTION, eleScheme);
            root.appendChild(eleScheme);
        }
        return document;
    }

    private void appendSchemeItem(Document document, Object params, String tagname, Element parent) {
        if (params != null) {
            Element eleValue = document.createElement(tagname);
            List lst = (List)params;
            Iterator it = lst.iterator();
            while (it.hasNext()) {
                Element ele = document.createElement(TAG_VALUE_CAPTION_ITEM);
                String value = (String)it.next();
                ele.setAttribute("value", value);
                eleValue.appendChild(ele);
            }
            parent.appendChild(eleValue);
        }
    }

    private static boolean isSuperUser(HttpServletRequest req) throws BIReportException {
        BIPermission_EAS permission = new BIPermission_EAS(BISystem.getContext(req));
        return permission.hasPermission("querysolutionmanage");
    }
}

