/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.tree;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONList;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BIReportTreeNode_EAS;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BITreeNode;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.ThemeReportTreeNode;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class KPITreeNode
extends DefaultKingdeeTreeNode
implements Comparable,
BITreeNode {
    private static final long serialVersionUID = 7090179827948395074L;
    private List children;
    private String caption;
    private String repositoryPath;
    private String kpi;
    private String number;
    private boolean isFolder = false;
    private String repositoryPathCaption;

    public KPITreeNode(KPITreeNode parent) {
        this.setParent((MutableTreeNode)((Object)parent));
    }

    public void setFolder() {
        this.isFolder = true;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public void setKPI(String kpi) {
        this.kpi = kpi;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getNumber() {
        return this.number;
    }

    @Override
    public boolean isLeaf() {
        return this.children == null || this.children.size() == 0;
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public TreeNode getChildAt(int index) {
        int childCount = this.getChildCount();
        if (index < 0 || index >= childCount) {
            return null;
        }
        return (TreeNode)this.children.get(index);
    }

    public String toString() {
        return this.caption;
    }

    public String getName() {
        return this.caption;
    }

    public String getAllDescendants() {
        ArrayList listDescendants = new ArrayList();
        int len = this.getChildCount();
        for (int i = 0; i < len; ++i) {
            TreeNode node = this.getChildAt(i);
            this.generateAllDescendants(listDescendants, node);
        }
        return new JSONList(listDescendants).toString();
    }

    private Map generateDataMap(KPITreeNode node) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        mapData.put("caption", node.getName());
        mapData.put("id", node.getID());
        mapData.put("url", "");
        mapData.put("isFolder", new Boolean(!node.isKPI()));
        return mapData;
    }

    private void generateAllDescendants(List list, TreeNode parentNode) {
        if (parentNode.getChildCount() == 0) {
            list.add(this.generateDataMap((KPITreeNode)parentNode));
        } else {
            ArrayList<Map> listChild = new ArrayList<Map>();
            listChild.add(this.generateDataMap((KPITreeNode)parentNode));
            list.add(listChild);
            int len = parentNode.getChildCount();
            for (int i = 0; i < len; ++i) {
                TreeNode node = parentNode.getChildAt(i);
                this.generateAllDescendants(listChild, node);
            }
        }
    }

    public int compareTo(Object o) {
        if (!(o instanceof BIReportTreeNode_EAS)) {
            return 1;
        }
        ThemeReportTreeNode objTo = (ThemeReportTreeNode)o;
        if (this.isLeaf()) {
            if (objTo.isLeaf()) {
                return this.getName().compareTo(objTo.getName());
            }
            return 1;
        }
        if (objTo.isLeaf()) {
            return -1;
        }
        return this.getName().compareTo(objTo.getName());
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isKPI() {
        return this.kpi != null;
    }

    @Override
    public String getPropertyValue(String propertyName) {
        if (propertyName.equalsIgnoreCase("caption")) {
            return this.getName();
        }
        return null;
    }

    @Override
    public String getFullPath() {
        return null;
    }

    @Override
    public String getID() {
        return this.kpi;
    }

    @Override
    public Calendar getLastModified() {
        return null;
    }
}

