/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.tree;

import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.ThemeReportTreeNode;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ThemeReportTreeModel
implements TreeModel,
Serializable {
    private static final long serialVersionUID = -1548973151509462922L;
    private static Logger logger = CommonLogger.getLogger(ThemeReportTreeModel.class);
    ThemeReportTreeNode root;
    private static final String WS_REPORT = "RPT";
    protected EventListenerList listenerList = new EventListenerList();

    public ThemeReportTreeModel(Repository rep) {
        this.root = new ThemeReportTreeNode(null);
        this.createTree(rep, "/report_tree", this.root);
    }

    private void createTree(Repository rep, String parentPath, ThemeReportTreeNode parentNode) {
        List childrenPath = null;
        Vector<ThemeReportTreeNode> children = null;
        try {
            childrenPath = rep.getNodeChildrenPaths(WS_REPORT, parentPath);
            children = new Vector<ThemeReportTreeNode>();
            parentNode.setChildren(children);
        }
        catch (RepositoryException e) {
            logger.error((Object)"\u521b\u5efa\u6811\u65f6\u53d6\u5b50\u7ed3\u70b9\u51fa\u9519", (Throwable)e);
            return;
        }
        Iterator it = childrenPath.iterator();
        while (it.hasNext()) {
            try {
                String caption;
                ThemeReportTreeNode node;
                String path = (String)it.next();
                if (rep.isThemeReport(path)) {
                    node = new ThemeReportTreeNode(parentNode);
                    caption = rep.getNodePropertyByPath(WS_REPORT, path, "caption");
                    node.setCaption(caption);
                    node.setUserObject(caption);
                    String reportPath = rep.getNodePropertyByPath(WS_REPORT, path, "reportPath");
                    node.setReportPath(reportPath);
                    String relativePath = path.substring("report_tree".length() + 2);
                    node.setRepositoryPath(relativePath);
                    String type = rep.getThemeReportType(path);
                    node.setReportType(type);
                    children.add(node);
                    continue;
                }
                if (!rep.isFolder(WS_REPORT, path)) continue;
                node = new ThemeReportTreeNode(parentNode);
                caption = rep.getNodePropertyByPath(WS_REPORT, path, "caption");
                node.setCaption(caption);
                node.setUserObject(caption);
                String relativePath = path.substring("report_tree".length() + 2);
                node.setRepositoryPath(relativePath);
                node.setFolder();
                this.createTree(rep, path, node);
                children.add(node);
            }
            catch (RepositoryException e) {
                logger.error((Object)"\u521b\u5efa\u6811\u65f6\u83b7\u53d6\u7ed3\u70b9\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            }
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((ThemeReportTreeNode)parent).getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((ThemeReportTreeNode)parent).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int n = this.getChildCount(parent);
        for (int i = 0; i < n; ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((ThemeReportTreeNode)node).isLeaf();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

