/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.util;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public class FolderUtil {
    public static String[] getChildrenFolderName(String folderPath, List exceptFolder) {
        String[] path = FolderUtil.getChildrenFolderPath(folderPath, exceptFolder);
        return FolderUtil.parseName(path);
    }

    public static String[] getChildrenFolderAndFilePath(String folderPath, final String suffixName, final List exceptFolder) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !FolderUtil.isExcept(exceptFolder, pathname.getName()) || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(suffixName);
            }
        };
        return FolderUtil.getChildrenPathByFilter(folderPath, filter);
    }

    public static String[] getChildrenFolderPath(String folderPath, final List exceptFolder) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !FolderUtil.isExcept(exceptFolder, pathname.getName());
            }
        };
        return FolderUtil.getChildrenPathByFilter(folderPath, filter);
    }

    public static String[] parseName(String[] folderPath) {
        String[] names = null;
        if (folderPath != null && folderPath.length > 0) {
            names = new String[folderPath.length];
            for (int index = 0; index < folderPath.length; ++index) {
                File f = new File(folderPath[index]);
                names[index] = f.getName();
            }
        }
        return names;
    }

    public static boolean[] parseType(String[] folderPath) {
        boolean[] types = null;
        if (folderPath != null && folderPath.length > 0) {
            types = new boolean[folderPath.length];
            for (int index = 0; index < folderPath.length; ++index) {
                File f = new File(folderPath[index]);
                types[index] = f.isFile();
            }
        }
        return types;
    }

    private static boolean isExcept(List exceptFolder, String name) {
        for (String folder : exceptFolder) {
            if (!folder.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static int getChildrenFolderCount(String path, final List exceptFolder) {
        return FolderUtil.getFilesCount(path, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !FolderUtil.isExcept(exceptFolder, pathname.getName());
            }
        });
    }

    public static int getChildrenFolderAndFileCount(String path, final String suffixName, final List exceptFolder) {
        return FolderUtil.getFilesCount(path, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !FolderUtil.isExcept(exceptFolder, pathname.getName()) || pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(suffixName);
            }
        });
    }

    private static File[] getFilesList(String folderPath, FileFilter filter) {
        File srcDirectory = new File(FilenameUtils.normalize((String)folderPath));
        if (srcDirectory.isDirectory()) {
            return srcDirectory.listFiles(filter);
        }
        return null;
    }

    private static int getFilesCount(String path, FileFilter filter) {
        File[] filesList = FolderUtil.getFilesList(path, filter);
        return filesList != null ? filesList.length : 0;
    }

    private static String[] getChildrenPathByFilter(String folderPath, FileFilter filter) {
        String[] paths = null;
        File[] filesList = FolderUtil.getFilesList(folderPath, filter);
        if (filesList != null && filesList.length > 0) {
            paths = new String[filesList.length];
            for (int index = 0; index < filesList.length; ++index) {
                paths[index] = filesList[index].getAbsolutePath();
            }
        }
        return paths;
    }
}

