/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worksheet;

import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.util.Displayable;
import com.kingdee.bos.ctrl.analysis.web.WebFrameworkException;
import com.kingdee.bos.ctrl.analysis.web.export.ExportUtil;
import com.kingdee.bos.ctrl.analysis.web.worksheet.AxisBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.AxisConfig;
import com.kingdee.bos.ctrl.analysis.web.worksheet.ColumnAxisBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.PartBuilderSupport;
import com.kingdee.bos.ctrl.analysis.web.worksheet.RowAxisBuilderImpl;
import com.kingdee.bos.ctrl.analysis.web.worksheet.SpanBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.HierarchyHeaderFactory;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.PropertySpanBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.SpanCalc;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.SpanConfigSupport;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class AxisBuilderSupport
extends PartBuilderSupport
implements AxisBuilder,
AxisConfig,
PropertyChangeListener {
    protected SpanCalc spanCalc;
    protected SpanBuilder spanBuilder;
    protected boolean showParentMembers = false;
    protected boolean memberIndent = false;
    protected int hierarchyHeader = 0;
    protected int memberSpan = 3;
    protected int headerSpan = 3;
    protected PropertySpanBuilder propertySpanBuilder;

    protected AxisBuilderSupport(SpanBuilder spanBuilder) {
        this.spanBuilder = spanBuilder;
    }

    @Override
    public void initialize(WorksheetComponent worksheet) throws WebFrameworkException {
        super.initialize(worksheet);
        this.spanBuilder.initialize(worksheet);
        this.propertySpanBuilder = new PropertySpanBuilder(worksheet.getOlapModel());
        this.propertySpanBuilder.addPropertyChangeListener(this);
    }

    @Override
    public void destroy() throws WebFrameworkException {
        super.destroy();
    }

    protected void initialize(Axis axis) {
        this.spanCalc = new SpanCalc(axis);
        SpanConfigSupport scs = new SpanConfigSupport();
        scs.setDirection(Member.class, this.memberSpan);
        scs.setDirection(Displayable.class, this.headerSpan);
        this.spanCalc.setConfig(scs);
        this.propertySpanBuilder.addPropertySpans(axis, this.spanCalc);
        switch (this.hierarchyHeader) {
            case 1: {
                this.spanCalc.addHierarchyHeader(new HierarchyHeaderFactory(), true, this.getAxis());
            }
        }
    }

    @Override
    public boolean isShowParentMembers() {
        return this.showParentMembers;
    }

    @Override
    public void setShowParentMembers(boolean showParentMembers) {
        this.showParentMembers = showParentMembers;
        this.setDirty(true);
    }

    @Override
    public SpanBuilder getSpanBuilder() {
        return this.spanBuilder;
    }

    @Override
    public void setSpanBuilder(SpanBuilder spanBuilder) {
        this.spanBuilder = spanBuilder;
        this.setDirty(true);
    }

    @Override
    public boolean isMemberIndent() {
        return this.memberIndent;
    }

    @Override
    public void setMemberIndent(boolean memberIndent) {
        this.memberIndent = memberIndent;
        this.setDirty(true);
    }

    @Override
    public AxisConfig getAxisConfig() {
        return this;
    }

    @Override
    public int getHeaderSpan() {
        return this.headerSpan;
    }

    @Override
    public int getHierarchyHeader() {
        return this.hierarchyHeader;
    }

    @Override
    public int getMemberSpan() {
        return this.memberSpan;
    }

    @Override
    public void setHeaderSpan(int headerSpan) {
        this.headerSpan = headerSpan;
        this.setDirty(true);
    }

    @Override
    public void setHierarchyHeader(int hierarchyHeader) {
        this.hierarchyHeader = hierarchyHeader;
        this.setDirty(true);
    }

    @Override
    public void setMemberSpan(int memberSpan) {
        this.memberSpan = memberSpan;
        this.setDirty(true);
    }

    protected abstract Axis getAxis();

    @Override
    public void startBuild() {
        Axis axis = this.getAxis();
        if (axis != null) {
            this.initialize(axis);
        }
        super.startBuild();
        this.spanBuilder.startBuild();
    }

    @Override
    public void stopBuild() {
        this.spanBuilder.stopBuild();
        super.stopBuild();
        this.spanCalc = null;
    }

    @Override
    public SpanCalc getSpanCalc() {
        return this.spanCalc;
    }

    protected void buildHeading(Element row, Span span, int rowspan, int colspan, boolean even) {
        Element elem = this.spanBuilder.build(span, even);
        elem.setAttribute("rowspan", Integer.toString(rowspan));
        elem.setAttribute("colspan", Integer.toString(colspan));
        if (elem.getAttribute("style").length() == 0) {
            String style = colspan > 1 || rowspan > 1 ? "span" : (even ? "even" : "odd");
            elem.setAttribute("style", style);
        }
        if (this.isMemberIndent() && span.isMember()) {
            elem.setAttribute("indent", Integer.toString(span.getIndent()));
        }
        row.appendChild(elem);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setDirty(true);
    }

    protected void buildHeading(KDSSheet sheet, int row, int col, Span span, int rowspan, int colspan, boolean even, Map mapColumnWidth) {
        String label = span.getObject().getLabel();
        if (label != null) {
            label = label.trim();
        }
        sheet.setCellValue(row, col, (Object)label);
        int calcWidth = ExportUtil.calcWidth(sheet, span.getObject().toString());
        Integer colWidth = (Integer)mapColumnWidth.get(new Integer(col));
        if (colWidth == null || colWidth.compareTo(new Integer(calcWidth)) < 0) {
            mapColumnWidth.put(new Integer(col), new Integer(calcWidth));
            sheet.getColumns().setColumnWidth(col, (float)UnitConverter.px2mm((int)calcWidth));
        }
        ExportUtil.addMergeWithBorder(sheet, row, col, rowspan, colspan);
        if ((span.isMember() || !(this instanceof RowAxisBuilderImpl)) && !span.isMember() && this instanceof ColumnAxisBuilder) {
            sheet.getCellStyleAttributes(row, col).setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        }
    }
}

