/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worksheet;

import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.web.worksheet.AxisBuilderSupport;
import com.kingdee.bos.ctrl.analysis.web.worksheet.RowAxisBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.RowAxisConfig;
import com.kingdee.bos.ctrl.analysis.web.worksheet.SpanBuilderImpl;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.HierarchyHeaderFactory;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.SpanCalc;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import java.util.Map;
import org.w3c.dom.Element;

public class RowAxisBuilderImpl
extends AxisBuilderSupport
implements RowAxisBuilder,
RowAxisConfig {
    int positionHeader;
    SpanCalc headerSpans;

    public RowAxisBuilderImpl() {
        super(new SpanBuilderImpl("row-heading", "row-heading-heading"));
        this.setMemberIndent(true);
        this.setShowParentMembers(false);
        this.setHierarchyHeader(0);
        this.setMemberSpan(3);
        this.setHeaderSpan(3);
        this.setPositionHeader(1);
    }

    @Override
    public void buildRow(KDSSheet sheet, int rowIndex, int startRow, int startCol, Map mapColumnWidth) {
        boolean even = rowIndex % 2 == 0;
        block0: for (int i = 0; i < this.spanCalc.getHierarchyCount(); ++i) {
            int colspan;
            int rowspan;
            Span span = this.spanCalc.getSpan(rowIndex, i);
            if (!span.isSignificant()) {
                rowspan = span.getPositionSpan();
                colspan = span.getHierarchySpan();
                int index2 = rowIndex;
                Span span2 = null;
                span2 = this.spanCalc.getSpan(--index2, i);
                while (span2.getMember() == span.getMember()) {
                    if (span2.getPositionSpan() > 0 && span2.getPositionSpan() >= span.getPositionIndex() - span2.getPositionIndex()) {
                        rowspan = span2.getPositionSpan() - (span.getPositionIndex() - span2.getPositionIndex());
                        this.buildHeading(sheet, startRow, startCol + i, span, rowspan, colspan, even, mapColumnWidth);
                    }
                    if (index2 == 0) continue block0;
                    span2 = this.spanCalc.getSpan(--index2, i);
                }
                continue;
            }
            if (!span.isSignificant()) continue;
            rowspan = span.getPositionSpan();
            colspan = span.getHierarchySpan();
            this.buildHeading(sheet, startRow, startCol + i, span, rowspan, colspan, even, mapColumnWidth);
        }
    }

    @Override
    public void buildRow(Element parent, int rowIndex, boolean first) {
        boolean even = rowIndex % 2 == 0;
        block0: for (int i = 0; i < this.spanCalc.getHierarchyCount(); ++i) {
            int colspan;
            int rowspan;
            Span span = this.spanCalc.getSpan(rowIndex, i);
            if (first && !span.isSignificant()) {
                rowspan = span.getPositionSpan();
                colspan = span.getHierarchySpan();
                int index2 = rowIndex;
                Span span2 = null;
                span2 = this.spanCalc.getSpan(--index2, i);
                while (span2.getMember() == span.getMember()) {
                    if (span2.getPositionSpan() > 0 && span2.getPositionSpan() >= span.getPositionIndex() - span2.getPositionIndex()) {
                        rowspan = span2.getPositionSpan() - (span.getPositionIndex() - span2.getPositionIndex());
                        this.buildHeading(parent, span, rowspan, colspan, even);
                    }
                    if (index2 == 0) continue block0;
                    span2 = this.spanCalc.getSpan(--index2, i);
                }
                continue;
            }
            if (!span.isSignificant()) continue;
            rowspan = span.getPositionSpan();
            colspan = span.getHierarchySpan();
            this.buildHeading(parent, span, rowspan, colspan, even);
        }
    }

    @Override
    public int getColumnCount() {
        return this.spanCalc.getHierarchyCount();
    }

    @Override
    public int getRowCount() {
        return this.spanCalc.getPositionCount();
    }

    @Override
    public int getPositionHeader() {
        return this.positionHeader;
    }

    @Override
    public void setPositionHeader(int positionHeader) {
        this.positionHeader = positionHeader;
        this.setDirty(true);
    }

    @Override
    public void buildHeaderRow(Element parent, int rowIndex) {
        boolean even = rowIndex % 2 == 0;
        for (int i = 0; i < this.headerSpans.getHierarchyCount(); ++i) {
            Span span = this.headerSpans.getSpan(rowIndex, i);
            if (!span.isSignificant()) continue;
            int rowspan = span.getPositionSpan();
            int colspan = span.getHierarchySpan();
            this.buildHeading(parent, span, rowspan, colspan, even);
        }
    }

    @Override
    public void buildHeaderRow(KDSSheet sheet, int rowIndex, int startRow, int startCol, Map mapColumnWidth) {
        boolean even = rowIndex % 2 == 0;
        for (int i = 0; i < this.headerSpans.getHierarchyCount(); ++i) {
            Span span = this.headerSpans.getSpan(rowIndex, i);
            if (!span.isSignificant()) continue;
            int rowspan = span.getPositionSpan();
            int colspan = span.getHierarchySpan();
            this.buildHeading(sheet, startRow, startCol + i, span, rowspan, colspan, even, mapColumnWidth);
        }
    }

    @Override
    public int getHeaderRowCount() {
        if (this.headerSpans == null) {
            return 0;
        }
        return this.headerSpans.getPositionCount();
    }

    @Override
    public SpanCalc getHeaderSpanCalc() {
        return this.headerSpans;
    }

    @Override
    public void initialize(Axis axis) {
        super.initialize(axis);
        switch (this.positionHeader) {
            case 1: 
            case 3: {
                this.headerSpans = this.spanCalc.createPositionHeader(new HierarchyHeaderFactory(), this.getAxis());
                break;
            }
            default: {
                this.headerSpans = null;
            }
        }
        if (this.headerSpans != null) {
            this.headerSpans.setConfig(this.spanCalc.getConfig());
        }
    }

    @Override
    public void stopBuild() {
        super.stopBuild();
        this.headerSpans = null;
    }

    @Override
    protected Axis getAxis() {
        return this.worksheet.getRowAxis();
    }
}

