/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XMLConfig
implements Serializable {
    public static final String ENCODING = "GBK";
    protected Document doc = null;
    private Map cache = new HashMap();

    public static XMLConfig createXMLConfig(String root) throws JDOMException, IOException {
        return new XMLConfig("<?xml version=\"1.0\" encoding=\"GBK\"?><" + root + "></" + root + ">");
    }

    public XMLConfig() {
    }

    public void setRoot(String rootName) throws JDOMException, IOException {
        String value = "<?xml version=\"1.0\" encoding=\"GBK\"?><" + rootName + "></" + rootName + ">";
        this.doc = new SAXBuilder().build((InputStream)new ByteArrayInputStream(value.getBytes()));
        this.resetCache();
    }

    public XMLConfig(String value) throws JDOMException, IOException {
        if (value == null || value.length() == 0) {
            value = "<?xml version=\"1.0\" encoding=\"GBK\"?><root></root>";
        }
        this.doc = new SAXBuilder().build((InputStream)new ByteArrayInputStream(value.getBytes()));
    }

    public XMLConfig(InputStream is) throws JDOMException, IOException {
        this.doc = new SAXBuilder().build(is);
    }

    public XMLConfig(Document doc) {
        this.doc = doc;
    }

    public String toXMLString() throws IOException {
        StringWriter sw = new StringWriter();
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding(ENCODING);
        new XMLOutputter(format).output(this.doc, (Writer)sw);
        return sw.toString();
    }

    public void resetCache() {
        this.cache.clear();
    }

    public Element[] getNodes(String path) {
        if (this.cache.containsKey(path)) {
            return (Element[])this.cache.get(path);
        }
        String[] ps = path.split("/");
        Element e = this.doc.getRootElement();
        if (ps.length == 0) {
            return new Element[]{e};
        }
        List re = null;
        for (int i = 0; i < ps.length; ++i) {
            String name = ps[i];
            if (name.length() <= 0) continue;
            re = this.searchNodes(e, name);
            if (re.size() > 0) {
                e = (Element)re.get(0);
                continue;
            }
            return this.cacheNodes(path, null);
        }
        if (re == null || re.size() == 0) {
            return this.cacheNodes(path, null);
        }
        return this.cacheNodes(path, re.toArray(new Element[0]));
    }

    private Element[] cacheNodes(String path, Element[] values) {
        this.cache.put(path, values);
        return values;
    }

    private List searchNodes(Element e, String name) {
        ArrayList<Element> re = new ArrayList<Element>(1);
        if (e.getName().equals(name)) {
            re.add(e);
            return re;
        }
        List list = e.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            List se = this.searchNodes((Element)list.get(i), name);
            re.addAll(se);
        }
        return re;
    }

    public String getValue(String path) {
        Element[] es = this.getNodes(path);
        if (es != null) {
            return es[0].getText();
        }
        return null;
    }

    public String[] getValues(String path) {
        Element[] es = this.getNodes(path);
        if (es != null) {
            ArrayList<String> list = new ArrayList<String>(es.length);
            int n = es.length;
            for (int i = 0; i < n; ++i) {
                list.add(es[i].getText());
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    public boolean setValue(String path, String value) {
        Element[] es = this.getNodes(path);
        if (es != null) {
            es[0].setText(value);
            return true;
        }
        return false;
    }

    public boolean setAttribute(String path, String attrKey, String value) {
        Element[] es = this.getNodes(path);
        if (es != null) {
            if (value == null) {
                value = "";
            }
            es[0].setAttribute(attrKey, value);
            String key = path + '>' + attrKey;
            this.cacheAttribute(key, value);
            return true;
        }
        return false;
    }

    public Element addNode(String parentPath, String name) {
        return this.addNode(parentPath, name, null);
    }

    public Element addNode(String parentPath, String name, String value) {
        Element[] es = this.getNodes(parentPath);
        if (es != null) {
            Element e = new Element(name);
            if (value != null) {
                e.setText(value);
            }
            es[0].addContent((Content)e);
            return e;
        }
        return null;
    }

    public boolean removeNodes(String path) {
        Element[] es = this.getNodes(path);
        if (es != null) {
            this.cache.remove(path);
            Element p = es[0].getParentElement();
            p.removeChildren(es[0].getName());
            return true;
        }
        return false;
    }

    public boolean removeAttribute(String path, String attrKey) {
        String key = path + '>' + attrKey;
        this.cache.remove(key);
        Element[] es = this.getNodes(path);
        if (es != null) {
            return es[0].removeAttribute(attrKey);
        }
        return false;
    }

    public String getAttribute(String path, String attrKey) {
        String key = path + '>' + attrKey;
        if (this.cache.containsKey(key)) {
            return (String)this.cache.get(key);
        }
        Element[] es = this.getNodes(path);
        if (es != null) {
            return this.cacheAttribute(key, es[0].getAttributeValue(attrKey));
        }
        return this.cacheAttribute(key, null);
    }

    private String cacheAttribute(String key, String value) {
        this.cache.put(key, value);
        return value;
    }

    public static void main(String[] args) throws Exception {
        XMLConfig config = XMLConfig.createXMLConfig("source");
        Element e = config.addNode("/source", "zzf", "eeeeeee");
        e.setAttribute("name", "laoda");
        System.out.println(config.toXMLString());
    }
}

