/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services.standalone.server;

import com.kingdee.bos.ctrl.bibench.platform.services.IDataSource;
import com.kingdee.bos.ctrl.bibench.platform.services.IServiceManager;
import com.kingdee.bos.ctrl.bibench.platform.services.RequestBlock;
import com.kingdee.bos.ctrl.bibench.platform.services.ResponseBlock;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceInvoker;
import com.kingdee.bos.ctrl.bibench.platform.services.impl.IMiniServer;
import com.kingdee.bos.ctrl.bibench.platform.services.standalone.server.IWrokerCallBack;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import org.apache.commons.io.serialization.ValidatingObjectInputStream;
import org.apache.log4j.Logger;

public class MiniServiceWorker
implements Runnable {
    private Logger log = CommonLogger.getLogger(MiniServiceWorker.class);
    private Socket s;
    private IServiceManager serviceManager;
    private IMiniServer server;
    private Thread thread;
    private IWrokerCallBack callback;
    private IDataSource con;

    public MiniServiceWorker(IServiceManager serviceManager, IMiniServer server, IWrokerCallBack callback) {
        this.serviceManager = serviceManager;
        this.server = server;
        this.callback = callback;
    }

    public void switchChannel(Socket s, IDataSource con, Thread thread) {
        this.s = s;
        this.con = con;
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ResponseBlock bw = new ResponseBlock();
            try {
                ObjectInputStream is = new ObjectInputStream(this.s.getInputStream());
                ValidatingObjectInputStream validatingObjectInputStream = new ValidatingObjectInputStream((InputStream)is);
                validatingObjectInputStream.accept(new Class[]{RequestBlock.class});
                Object re = validatingObjectInputStream.readObject();
                if (!(re instanceof RequestBlock)) {
                    throw new IllegalAccessException("Unknow request!");
                }
                RequestBlock b = (RequestBlock)re;
                bw.setValue(this.service(b));
            }
            catch (Exception e) {
                Throwable t = e;
                if (e instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)e).getTargetException();
                }
                bw.setValue(t);
            }
            ObjectOutputStream os = new ObjectOutputStream(this.s.getOutputStream());
            os.writeObject(bw);
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
        }
        finally {
            this.callback.callback(this);
        }
    }

    private Object service(RequestBlock b) throws Exception {
        return ServiceInvoker.service(b, this.con, this.serviceManager, this.server);
    }
}

