/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.visitor;

import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.ListCollection;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.FilterBoolean;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.FilterDataSource;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.FilterDate;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.FilterInteger;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.FilterList;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.FilterString;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.visitor.IFilterVisitor;
import java.text.SimpleDateFormat;

public class FilterSQLVisitor
implements IFilterVisitor {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");

    private static String maskSQLValue(Object value) {
        return String.valueOf(value).replaceAll("'", "''");
    }

    @Override
    public Object visit(FilterBoolean visitable, Object arg) {
        return (Boolean)visitable.getValue() != false ? "1" : "0";
    }

    @Override
    public Object visit(FilterDataSource visitable, Object arg) {
        Object v = visitable.getValue();
        if (v instanceof Number) {
            return v;
        }
        return "'" + FilterSQLVisitor.maskSQLValue(v) + "'";
    }

    @Override
    public Object visit(FilterDate visitable, Object arg) {
        return "to_date('" + sdf.format(visitable.getValue()) + "')";
    }

    @Override
    public Object visit(FilterInteger visitable, Object arg) {
        return visitable.getValue();
    }

    @Override
    public Object visit(FilterList visitable, Object arg) {
        ListCollection lc = (ListCollection)visitable.getInitValue();
        if (lc.getType() instanceof FilterInteger) {
            return visitable.getValue();
        }
        return "'" + FilterSQLVisitor.maskSQLValue(visitable.getValue()) + "'";
    }

    @Override
    public Object visit(FilterString visitable, Object arg) {
        return "'" + FilterSQLVisitor.maskSQLValue(visitable.getValue()) + "'";
    }
}

