/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.cubemodel;

import com.kingdee.bos.ctrl.analysis.cubemodel.ICubeModelEditorListener;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.CubeModelEditor;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.CubeModelDataProvider;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelUtil;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Cube;
import com.kingdee.bos.ctrl.bibench.platform.common.XMLConfig;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.cubemodel.RDCubeModelNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.dsprovider.RDTableForCubeModelProvider;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterItemCollection;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.RDBaseInternalFrame;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.RDReportViewDlg;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.x.MdxBuilder;
import com.kingdee.bos.ctrl.bibench.platform.ui.icon.IconResource;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.common.ui.editor.styled.SchemaDefStyledEditor;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.olap.def.SchemaDef;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CubeModelInnerFrame
extends RDBaseInternalFrame {
    private CubeModelEditor cmEditor;
    private RDTableForCubeModelProvider provider;
    private SchemaDefStyledEditor xmlEditor = null;
    private KDToggleButton btnViewSource;
    private KDScrollPane contentPanel = new KDScrollPane();
    private RDCubeModelNode cmItem;
    private RDReportViewDlg previewDlg = null;

    public CubeModelInnerFrame(RDBaseNode item) {
        super(item);
        this.cmItem = (RDCubeModelNode)item;
        this.initUI();
    }

    private void initUI() {
        this.provider = new RDTableForCubeModelProvider(this.item);
        this.cmEditor = new CubeModelEditor((CubeModelDataProvider)this.provider, false);
        this.contentPanel.setViewportView((Component)this.cmEditor);
        this.add((Component)this.contentPanel, "Center");
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        CubeModel cm = this.cmItem.getCubeModelConfig().getCubeModel();
        if (cm != null) {
            this.cmEditor.setCubeModel(cm);
        }
        this.cmEditor.addCubeModelEditorListener(new ICubeModelEditorListener(){

            public void modifiedChanged(boolean isDirty) {
                if (isDirty) {
                    CubeModelInnerFrame.this.valueChanged("name", CubeModelInnerFrame.this.item);
                }
            }
        });
    }

    @Override
    public void save() {
        try {
            CubeModel cm = this.cmEditor.getCubeModel();
            if (cm != null) {
                this.cmItem.getCubeModelConfig().setCubeModel(cm);
                this.cmItem.fireContentChanged();
                super.save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MsgBox.error("\u4fdd\u5b58", ex, (Component)((Object)this));
        }
    }

    @Override
    public void initToolBar(KDToolBar bar) {
        this.initToolBar_addSave(bar);
        this.initToolBar_addShowSchemaDef(bar);
        this.initToolBar_addPreview(bar);
        this.initToolBar_addExit(bar);
    }

    protected void initToolBar_addPreview(KDToolBar bar) {
        KDWorkButton btnPreview = new KDWorkButton("\u9884\u89c8");
        btnPreview.setIcon(IconResource.getIcon("tree_view.gif"));
        btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CubeModelInnerFrame.this.preview();
            }
        });
        bar.add((Component)btnPreview);
    }

    protected void initToolBar_addShowSchemaDef(KDToolBar bar) {
        this.btnViewSource = new KDToggleButton("\u67e5\u770b\u6e90\u6587\u4ef6");
        this.btnViewSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CubeModelInnerFrame.this.viewSource();
            }
        });
        bar.add((Component)this.btnViewSource);
    }

    private void viewSource() {
        if (this.btnViewSource.isSelected()) {
            if (this.xmlEditor == null) {
                this.xmlEditor = new SchemaDefStyledEditor();
                this.xmlEditor.setEditable(false);
            }
            this.contentPanel.setViewportView((Component)this.xmlEditor);
            try {
                SchemaDef def = CubeModelUtil.convertCube((CubeModel_Cube)this.cmEditor.getCubeModel().getCubes()[0]);
                XMLConfig c = new XMLConfig(def.export());
                this.xmlEditor.setText(c.toXMLString());
            }
            catch (Exception e) {
                this.xmlEditor.setText(e.getMessage());
            }
            this.xmlEditor.setCaretPosition(0);
        } else {
            this.contentPanel.setViewportView((Component)this.cmEditor);
        }
        this.contentPanel.updateUI();
    }

    private void preview() {
        CubeModel cm = this.cmEditor.getCubeModel();
        if (cm != null) {
            if (this.previewDlg == null) {
                this.previewDlg = new RDReportViewDlg((Frame)((Object)this.ctx.getFrame()), this.ctx);
            }
            try {
                this.previewDlg.setTitle(cm.getCubes()[0].getAlias());
                this.previewDlg.showX(null, cm, this.provider, MdxBuilder.createDefaultMdx(cm, true), new FilterItemCollection(), null);
            }
            catch (Exception e) {
                e.printStackTrace();
                MsgBox.error("\u9884\u89c8", e, (Component)((Object)this));
            }
        }
    }
}

