/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.x;

import com.kingdee.bos.ctrl.analysis.bicomponent.ChartComponent;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.mdxw.panelet.SplitUtil;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.resource.Resources;
import com.kingdee.bos.ctrl.bibench.platform.ui.RDBaseAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.DefaultPrintConfigProvider;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.IRDReportActor;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.RDPrinter;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitlePanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.olap.Connection;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.Action;

public class RDReportPanelX
extends KDPanel {
    private TitlePanel titlePanel;
    private KDToolBar toolBar = new KDToolBar();
    private WorksheetComponent ws;
    private ChartComponent cc;
    private ComponentConfig config;
    private boolean showChart = true;
    private OlapModel model = null;
    private Connection con = null;
    private KDSplitPane topSp = new KDSplitPane();
    private KDPanel leftPanel = new KDPanel();
    private KDPanel rightPanel = new KDPanel();
    private KDChart chart = new KDChart();
    private KDTable table = new KDTable();
    private String title;
    private IRDReportActor actor;
    private RDBaseAction filterAction = null;

    public RDReportPanelX(IRDReportActor actor) {
        this.actor = actor;
        this.init();
    }

    public KDTable getTable() {
        return this.table;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitlePanel(TitlePanel tp) {
        this.titlePanel = tp;
    }

    public void setFilterActionEnabled(boolean enable) {
        this.filterAction.setEnabled(enable);
    }

    private void init() {
        this.setLayout(new CardLayout());
        this.leftPanel.setLayout((LayoutManager)new BorderLayout());
        this.rightPanel.setLayout((LayoutManager)new BorderLayout());
        this.topSp.add((Component)this.leftPanel, (Object)"left");
        this.leftPanel.add((Component)this.table, (Object)"Center");
        this.topSp.add((Component)this.rightPanel, (Object)"right");
        this.rightPanel.add((Component)this.chart, (Object)"Center");
        this.add((Component)this.topSp, "topSp");
        this.topSp.setDividerLocation(200);
        this.config = ComponentConfig.getConfig();
        this.config.showColumnDimensionHeader = true;
        this.config.useNonEmpty = false;
        this.table.checkParsed();
        this.ws = new WorksheetComponent(this.table, this.config, true);
        this.cc = new ChartComponent(this.chart, this.config);
        this.leftPanel.removeAll();
        this.leftPanel.add((Component)this.ws.getJComponent());
        new SplitUtil().layout(this.topSp, 0.5f);
        this.setShowChart(false);
        this.initToolBar();
    }

    public KDToolBar getToolBar() {
        return this.toolBar;
    }

    public WorksheetComponent getWS() {
        return this.ws;
    }

    public void setShowChart(boolean showChart) {
        this.showChart = showChart;
        this.chart.setVisible(showChart);
        this.chart.setEnabled(this.model != null);
        if (showChart) {
            if (this.model != null) {
                if (this.cc.getOlapModel() == this.model) {
                    this.cc.refresh();
                    this.model.addModelChangeListener((ModelChangeListener)this.cc);
                } else {
                    this.cc.setModel(this.model);
                }
            }
            this.topSp.add((Component)this.leftPanel, (Object)"left");
            this.add((Component)this.topSp, "topSp");
        } else {
            if (this.model != null) {
                this.model.removeModelChangeListener((ModelChangeListener)this.cc);
            }
            this.remove((Component)this.topSp);
            this.topSp.remove((Component)this.leftPanel);
            this.add((Component)this.leftPanel, "leftPanel");
        }
        this.updateUI();
    }

    public void setModel(OlapModel model, Connection con) {
        this.model = model;
        this.con = con;
        this.ws.setModel(model);
        this.setShowChart(this.showChart);
    }

    public KDSplitPane getKDSplitPane() {
        return this.topSp;
    }

    private void initToolBar() {
        this.toolBar.add((Action)new RDBaseAction("\u5173\u95ed", Resources.getIcon((String)"icon/tbtn_quit.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.exit();
            }

            @Override
            public boolean onlyForStandalone() {
                return true;
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u5237\u65b0", Resources.getIcon((String)"icon/tbtn_refresh.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RDReportPanelX.this.actor != null) {
                    try {
                        RDReportPanelX.this.actor.refresh();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        MsgBox.error(RDReportPanelX.this.getName(), e1, (Component)((Object)RDReportPanelX.this));
                    }
                }
            }
        });
        this.filterAction = new RDBaseAction("\u8fc7\u6ee4", Resources.getIcon((String)"icon/tbtn_filter.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RDReportPanelX.this.actor != null) {
                    try {
                        RDReportPanelX.this.actor.showQueryDialog();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        MsgBox.error(RDReportPanelX.this.getName(), e1, (Component)((Object)RDReportPanelX.this));
                    }
                }
            }
        };
        this.toolBar.add((Action)this.filterAction);
        this.toolBar.add((Action)new RDBaseAction("\u6253\u5370\u9884\u89c8", Resources.getIcon((String)"icon/preview.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RDReportPanelX.this.model != null) {
                    RDPrinter rd = new RDPrinter();
                    rd.setPrintConfigProvider(new DefaultPrintConfigProvider(RDReportPanelX.this.title, RDReportPanelX.this.titlePanel));
                    try {
                        rd.doPrint(RDReportPanelX.this.table, RDReportPanelX.this.showChart ? RDReportPanelX.this.chart : null, true, (Component)((Object)RDReportPanelX.this));
                    }
                    catch (Exception _) {
                        _.printStackTrace();
                        MsgBox.error("\u6253\u5370\u9884\u89c8", _, (Component)((Object)RDReportPanelX.this));
                    }
                }
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u6253\u5370", Resources.getIcon((String)"icon/tbtn_print.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RDReportPanelX.this.model != null) {
                    RDPrinter rd = new RDPrinter();
                    rd.setPrintConfigProvider(new DefaultPrintConfigProvider(RDReportPanelX.this.title, RDReportPanelX.this.titlePanel));
                    try {
                        rd.doPrint(RDReportPanelX.this.table, RDReportPanelX.this.showChart ? RDReportPanelX.this.chart : null, false, (Component)((Object)RDReportPanelX.this));
                    }
                    catch (Exception _) {
                        _.printStackTrace();
                        MsgBox.error("\u6253\u5370", _, (Component)((Object)RDReportPanelX.this));
                    }
                }
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u884c\u5217\u4ea4\u6362", Resources.getIcon((String)"icon/tbtn_swapaxes.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.ws.swapAxis();
            }
        });
        this.toolBar.add((Action)new RDBaseAction("MDX\u67e5\u8be2", Resources.getIcon((String)"icon/tbtn_mdx.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.ws.mdxQuery();
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u5e03\u5c40", Resources.getIcon((String)"icon/tbtn_layout.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.ws.openLayoutDesigner();
            }
        });
        this.toolBar.add((Component)new KDToggleButton((Action)new RDBaseAction("\u663e\u793a\u56fe\u5f62", Resources.getIcon((String)"icon/tbtn_chart.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.setShowChart(((KDToggleButton)e.getSource()).isSelected());
            }
        }));
        this.toolBar.add((Action)new RDBaseAction("\u56fe\u5f62\u5206\u6790", Resources.getIcon((String)"icon/tbtn_graphsetting.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.ws.openChartAnalysis(RDReportPanelX.this.con, RDReportPanelX.this.model.getCurrentMdx(), null, null);
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u6392\u5e8f\u6392\u540d", Resources.getIcon((String)"icon/tbtn_sortRank.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.ws.sortRank();
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u5355\u5143\u683c\u683c\u5f0f", Resources.getIcon((String)"icon/tree_dataformat.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.ws.dataStyle();
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u5355\u5143\u683c\u878d\u5408", Resources.getIcon((String)"icon/tbtn_merge.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.ws.mergeStyle();
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u6570\u636e\u5237\u9009", Resources.getIcon((String)"icon/tbtn_billfilter.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.ws.sizerData();
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u5217\u987a\u5e8f\u8c03\u6574", Resources.getIcon((String)"icon/tbtn_movetier.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.ws.adjustColOrder();
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u5bfc\u51fa\u5230Excel", Resources.getIcon((String)"icon/tbtn_importexcel.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelX.this.ws.export2Excel();
            }
        });
    }

    private void exit() {
        if (this.actor != null) {
            this.actor.exit();
            this.ws.dispose();
        }
        this.model = null;
    }
}

