/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.BasicView;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.ITableDragableBizWrapper;
import com.kingdee.bos.ctrl.kdf.table.ITableDragableStrategy;
import com.kingdee.bos.ctrl.kdf.table.ITableDragableUiAssistant;
import com.kingdee.bos.ctrl.kdf.table.KDTCellPosition;
import com.kingdee.bos.ctrl.kdf.table.KDTView;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class TableDragableMouseBinder {
    public static void bindMouseHandler(KDTable table, ITableDragableStrategy strategy, ITableDragableUiAssistant uiAssistant) {
        MouseHandler mh = new MouseHandler(table, strategy, uiAssistant);
        int viewCount = table.getViewManager().getViewCount();
        for (int i = viewCount - 1; i >= 0; --i) {
            BasicView view = table.getViewManager().getView(i);
            if (view.getViewType() != 1 && view.getViewType() != 2) continue;
            view.addMouseListener((MouseListener)mh);
            view.addMouseMotionListener((MouseMotionListener)mh);
        }
    }

    private static class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private KDTable _table;
        private ITableDragableStrategy _strategy;
        private ITableDragableUiAssistant _uiAssistant;
        private boolean _isCanDrag;
        private ITableDragableBizWrapper _sourceBizWrapper;
        private Rectangle _sourceRect;
        private Point _mouseStart;
        private boolean _isCanDrop;
        private Rectangle _targetRect;
        private Rectangle _lastRect;

        public MouseHandler(KDTable tb, ITableDragableStrategy stg, ITableDragableUiAssistant uia) {
            this._table = tb;
            this._strategy = stg;
            this._uiAssistant = uia;
        }

        private MouseEvent convertEvent(MouseEvent e, Component owner) {
            KDTView source = (KDTView)e.getSource();
            return SwingUtilities.convertMouseEvent((Component)source, e, owner);
        }

        private KDTView getTargetView(MouseEvent eventOfTable) {
            Component cTarget = SwingUtilities.getDeepestComponentAt((Component)this._table, eventOfTable.getX(), eventOfTable.getY());
            if (cTarget instanceof KDTView) {
                KDTView target = (KDTView)cTarget;
                return target;
            }
            return null;
        }

        private ICell getCellByIndex(KDTView view, int rowIdx, int colIdx) {
            IRow row = null;
            if (view.getViewType() == 2) {
                row = this._table.getHeadRow(rowIdx);
            } else if (view.getViewType() == 1) {
                row = this._table.getRow(rowIdx);
            }
            if (row != null) {
                return row.getCell(colIdx);
            }
            return null;
        }

        private int getRowCount(KDTView view) {
            return view.getViewType() == 2 ? this._table.getHeadRowCount() : this._table.getRowCount();
        }

        private CellAux getAppointedCell(KDTView view, int x, int y) {
            KDTCellPosition cellPos = view.getCellPosition2(x, y);
            ICell cell = this.getCellByIndex(view, cellPos.rowIndex, cellPos.colIndex);
            if (cell != null) {
                CellAux result = new CellAux();
                result.cell = cell;
                result.position = cellPos;
                return result;
            }
            return null;
        }

        private ITableDragableBizWrapper getBizWrapper(CellAux cellAux) {
            if (cellAux != null) {
                return this.getBizWrapper(cellAux.cell);
            }
            return null;
        }

        private ITableDragableBizWrapper getBizWrapper(ICell cell) {
            Object value = cell.getUserObject();
            if (value instanceof ITableDragableBizWrapper) {
                return (ITableDragableBizWrapper)value;
            }
            return null;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            KDTView view = (KDTView)e.getSource();
            if (view.getStatus() != 0 && view.getStatus() != 5) {
                return;
            }
            CellAux cellAux = this.getAppointedCell(view, e.getX(), e.getY());
            ITableDragableBizWrapper bizWrapper = this.getBizWrapper(cellAux);
            if (bizWrapper != null) {
                Rectangle rect = view.getCellRectangle2(cellAux.position.rowIndex, cellAux.position.colIndex);
                boolean bl = this._isCanDrag = this._strategy.isCanDrag(bizWrapper) && this._uiAssistant.isCanDrag(e, rect);
                if (this._isCanDrag) {
                    view.setStatus(0);
                    this._sourceBizWrapper = bizWrapper;
                    this._sourceRect = this.searchRect((KDTView)view, (KDTCellPosition)cellAux.position, (ITableDragableBizWrapper)bizWrapper).rect;
                    this._sourceRect = SwingUtilities.convertRectangle((Component)view, this._sourceRect, (Component)this._table);
                    this._mouseStart = SwingUtilities.convertPoint((Component)view, e.getX(), e.getY(), (Component)this._table);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this._isCanDrag) {
                if (this._isCanDrop) {
                    ITableDragableBizWrapper bizWrapper;
                    MouseEvent tableMouseEvent = this.convertEvent(e, (Component)this._table);
                    KDTView targetView = this.getTargetView(tableMouseEvent);
                    targetView.setCursor(Cursor.getDefaultCursor());
                    CellAux cellAux = null;
                    if (targetView != null) {
                        Point point = SwingUtilities.convertPoint((Component)((KDTView)e.getSource()), e.getX(), e.getY(), (Component)targetView);
                        cellAux = this.getAppointedCell(targetView, point.x, point.y);
                    }
                    if ((bizWrapper = this.getBizWrapper(cellAux)) != null) {
                        this._strategy.setMouseEvent(tableMouseEvent);
                        if (this._strategy.preDropPrompt(this._sourceBizWrapper, bizWrapper, (Component)this._table)) {
                            this._strategy.dropping(this._sourceBizWrapper, bizWrapper);
                        }
                    }
                }
                this._uiAssistant.drawXorPromptRect(this._table.getGraphics(), this._lastRect, null);
                this._isCanDrag = false;
                this._isCanDrop = false;
                this._sourceBizWrapper = null;
                this._sourceRect = null;
                this._lastRect = null;
                this._mouseStart = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this._isCanDrag) {
                return;
            }
            Graphics g = this._table.getGraphics();
            MouseEvent tableMouseEvent = this.convertEvent(e, (Component)this._table);
            KDTView targetView = this.getTargetView(tableMouseEvent);
            if (targetView != null) {
                Point point = SwingUtilities.convertPoint((Component)((KDTView)e.getSource()), e.getX(), e.getY(), (Component)targetView);
                CellAux cellAux = this.getAppointedCell(targetView, point.x, point.y);
                ITableDragableBizWrapper bizWrapper = this.getBizWrapper(cellAux);
                if (bizWrapper != null && this._strategy.isCanDrop(this._sourceBizWrapper, bizWrapper)) {
                    if (!this._isCanDrop) {
                        targetView.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    this._isCanDrop = true;
                    this._targetRect = this.searchTargetRect(targetView, cellAux, e, bizWrapper);
                    this._targetRect = SwingUtilities.convertRectangle((Component)targetView, this._targetRect, (Component)this._table);
                    this._uiAssistant.drawXorPromptRect(g, this._lastRect, this._targetRect);
                    this._lastRect = this._targetRect;
                } else {
                    if (this._isCanDrop) {
                        targetView.setCursor(Cursor.getDefaultCursor());
                    }
                    this._isCanDrop = false;
                    Rectangle rect = new Rectangle(this._sourceRect);
                    rect.x += tableMouseEvent.getX() - this._mouseStart.x;
                    rect.y += tableMouseEvent.getY() - this._mouseStart.y;
                    this._uiAssistant.drawXorPromptRect(g, this._lastRect, rect);
                    this._lastRect = rect;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private Rectangle searchTargetRect(KDTView view, CellAux cellAux, MouseEvent evt, ITableDragableBizWrapper targetBizWrapper) {
            int y;
            int x;
            if (view == evt.getSource()) {
                x = evt.getX();
                y = evt.getY();
            } else {
                MouseEvent e = this.convertEvent(evt, (Component)view);
                x = e.getX();
                y = e.getY();
            }
            KDTCellPosition cp = cellAux.position;
            RectAux rectAux = this.searchRect(view, cp, targetBizWrapper);
            Rectangle baseRect = rectAux.rect;
            boolean isNearTop = false;
            boolean isNearLeft = false;
            int vBorderDistance = 0;
            int hBorderDistance = 0;
            if (rectAux.isSingle() || rectAux.isHorizontal()) {
                if (y < baseRect.y + baseRect.height / 2) {
                    isNearTop = true;
                    vBorderDistance = y - baseRect.y;
                } else {
                    isNearTop = false;
                    vBorderDistance = baseRect.y + baseRect.height - y;
                }
            } else if (rectAux.isSingle() || !rectAux.isHorizontal()) {
                if (x < baseRect.x + baseRect.width / 2) {
                    isNearLeft = true;
                    hBorderDistance = x - baseRect.x;
                } else {
                    isNearLeft = false;
                    hBorderDistance = baseRect.x + baseRect.width - x;
                }
            } else {
                throw new RuntimeException("RectAux\u7684\u7c7b\u578b\u4e0d\u5bf9");
            }
            int dir = rectAux.isSingle() ? (hBorderDistance < vBorderDistance ? (isNearLeft ? 2 : 4) : (isNearTop ? 1 : 3)) : (rectAux.isHorizontal() ? (isNearTop ? 1 : 3) : (isNearLeft ? 2 : 4));
            switch (dir) {
                case 1: {
                    int upRow = cp.rowIndex - 1;
                    if (upRow < 0) {
                        baseRect.height /= 2;
                    } else {
                        Rectangle upRect = view.getCellRectangle(upRow, cp.colIndex);
                        int upThird = upRect.height / 3;
                        baseRect.y -= upThird;
                        baseRect.height = upThird + baseRect.height / 3;
                    }
                    this._strategy.setInsertType(1);
                    break;
                }
                case 3: {
                    int downRow = cp.rowIndex + 1;
                    int baseHeightThird = baseRect.height / 3;
                    baseRect.y += baseHeightThird * 2;
                    if (downRow == this.getRowCount(view)) {
                        baseRect.height = baseHeightThird * 2;
                    } else {
                        Rectangle downRect = view.getCellRectangle(downRow, cp.colIndex);
                        baseRect.height = baseHeightThird + downRect.height / 3;
                    }
                    this._strategy.setInsertType(2);
                    break;
                }
                case 2: {
                    int leftCol = cp.colIndex - 1;
                    if (leftCol < 0) {
                        baseRect.width /= 2;
                    } else {
                        Rectangle leftRect = view.getCellRectangle(cp.rowIndex, leftCol);
                        int leftThird = leftRect.width / 3;
                        baseRect.x -= leftThird;
                        baseRect.width = leftThird + baseRect.width / 3;
                    }
                    this._strategy.setInsertType(1);
                    break;
                }
                case 4: {
                    int rightCol = cp.colIndex + 1;
                    int baseWidthThird = baseRect.width / 3;
                    baseRect.x += baseWidthThird * 2;
                    if (rightCol == this._table.getColumnCount()) {
                        baseRect.width = baseWidthThird * 2;
                    } else {
                        Rectangle rightRect = view.getCellRectangle(cp.rowIndex, rightCol);
                        baseRect.width = baseWidthThird + rightRect.width / 3;
                    }
                    this._strategy.setInsertType(2);
                    break;
                }
            }
            return baseRect;
        }

        private RectAux searchRect(KDTView view, KDTCellPosition cp, ITableDragableBizWrapper baseBizWrapper) {
            Rectangle baseRect = view.getCellRectangle(cp.rowIndex, cp.colIndex);
            boolean isSingle = !this._uiAssistant.isSearchingNeighbor();
            boolean isHFound = false;
            if (!isSingle) {
                Rectangle rect;
                int i;
                for (i = cp.colIndex - 1; i >= 0 && this.catchNeighbor(view, cp.rowIndex, i, baseBizWrapper); --i) {
                    rect = view.getCellRectangle(cp.rowIndex, i);
                    baseRect = MouseHandler.uniteRect(rect, baseRect, true);
                    isHFound = true;
                }
                for (i = cp.colIndex + 1; i < this._table.getColumnCount() && this.catchNeighbor(view, cp.rowIndex, i, baseBizWrapper); ++i) {
                    rect = view.getCellRectangle(cp.rowIndex, i);
                    baseRect = MouseHandler.uniteRect(rect, baseRect, true);
                    isHFound = true;
                }
                if (!isHFound) {
                    for (i = cp.rowIndex - 1; i >= 0 && this.catchNeighbor(view, i, cp.colIndex, baseBizWrapper); --i) {
                        rect = view.getCellRectangle(i, cp.colIndex);
                        baseRect = MouseHandler.uniteRect(rect, baseRect, false);
                    }
                    int rowCount = this.getRowCount(view);
                    for (i = cp.rowIndex + 1; i < rowCount && this.catchNeighbor(view, i, cp.colIndex, baseBizWrapper); ++i) {
                        Rectangle rect2 = view.getCellRectangle(i, cp.colIndex);
                        baseRect = MouseHandler.uniteRect(rect2, baseRect, false);
                    }
                }
            }
            RectAux rectAux = new RectAux();
            rectAux.rect = baseRect;
            rectAux.setType(isSingle, isHFound);
            return rectAux;
        }

        private boolean catchNeighbor(KDTView view, int rowIdx, int colIdx, ITableDragableBizWrapper baseBizWrapper) {
            ICell cell = this.getCellByIndex(view, rowIdx, colIdx);
            ITableDragableBizWrapper bizWrapper = this.getBizWrapper(cell);
            return bizWrapper != null && this._uiAssistant.isNeighborSameClan(baseBizWrapper, bizWrapper);
        }

        private static Rectangle uniteRect(Rectangle rect1, Rectangle rect2, boolean isHorizontal) {
            Rectangle rect = new Rectangle();
            if (isHorizontal) {
                rect.y = rect1.y;
                rect.height = rect1.height;
                rect.x = Math.min(rect1.x, rect2.x);
                rect.width = rect1.width + rect2.width;
            } else {
                rect.x = rect1.x;
                rect.width = rect1.width;
                rect.y = Math.min(rect1.y, rect2.y);
                rect.height = rect1.height + rect2.height;
            }
            return rect;
        }
    }

    private static class RectAux {
        public static int Type_Single = 1;
        public static int Type_Horizontal = 18;
        public static int Type_Vertical = 34;
        public Rectangle rect;
        public int type;

        private RectAux() {
        }

        public void setType(boolean isSingle, boolean isH) {
            this.type = isSingle ? Type_Single : (isH ? Type_Horizontal : Type_Vertical);
        }

        public boolean isSingle() {
            return (this.type & Type_Single) == Type_Single;
        }

        public boolean isHorizontal() {
            return (this.type & Type_Horizontal) == Type_Horizontal;
        }
    }

    private static class CellAux {
        public ICell cell;
        public KDTCellPosition position;

        private CellAux() {
        }
    }
}

