/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.common;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.wizard.WizardResource;
import com.kingdee.bos.ctrl.data.wizard.formula.FormulaEditorDialog;
import com.kingdee.bos.ctrl.data.wizard.formula.FormulaWizardEditor;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public abstract class CustomTextEditor
extends KDPanel {
    protected FormulaEditorDialog formulaDialog;
    protected FormulaWizardEditor formula;
    private JTextComponent txaResult;
    private KDWorkButton btnWizard;
    private KDPanel panTitle;
    private KDLabel labTitle;

    public CustomTextEditor(JTextComponent txt) {
        this.txaResult = txt;
        this.setOpaque(false);
        this.init();
        this.installListener();
    }

    public CustomTextEditor() {
        this.setOpaque(false);
        this.init();
        this.installListener();
    }

    private void init() {
        this.panTitle = new KDPanel();
        this.labTitle = new KDLabel();
        this.panTitle.setOpaque(false);
        this.panTitle.add((Component)this.labTitle);
        this.resetTitlePaneLayout((JComponent)this.getWizardButton());
        TableLayout tl = TableLayout.split((int)2, (int)1);
        tl.rowStyle(0).setHeight(19);
        tl.rowStyle(0).setMarginBottom(1);
        tl.rowStyle(1).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)this.panTitle, tl.cell(0));
        this.add((Component)new KDScrollPane((Component)this.getTextArea()), tl.cell(1));
    }

    private void installListener() {
        this.getWizardButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomTextEditor.this.getFormulaDialog().getWizardPane().setResult(CustomTextEditor.this.getTextArea().getText());
                if (CustomTextEditor.this.getFormulaDialog().showDialog()) {
                    CustomTextEditor.this.getTextArea().setText(CustomTextEditor.this.getFormulaDialog().getWizardPane().getResult());
                }
            }
        });
    }

    private void resetTitlePaneLayout(JComponent newBtn) {
        Component[] comps = this.panTitle.getComponents();
        int c = this.panTitle.getComponentCount();
        this.panTitle.removeAll();
        TableLayout tl = TableLayout.splitCol((int)(c + 1));
        this.panTitle.setLayout((LayoutManager)tl);
        for (int i = 0; i < c; ++i) {
            tl.colStyle(i).setWidth(26);
            tl.colStyle(i).setMarginRight(3);
            this.panTitle.add(comps[i], (Object)tl.cell(i));
        }
        this.panTitle.add((Component)newBtn, (Object)tl.cell(c));
        tl.colStyle(0).setPriX(1);
        tl.colStyle(c).setMarginRight(2);
    }

    public JTextComponent getTextArea() {
        if (this.txaResult == null) {
            this.txaResult = new KDTextArea();
        }
        return this.txaResult;
    }

    public void setResultEditable(boolean isEditable) {
        this.txaResult.setEditable(isEditable);
    }

    public void setResultEnable(boolean isEnable) {
        this.txaResult.setEnabled(isEnable);
    }

    public KDWorkButton getWizardButton() {
        if (this.btnWizard == null) {
            this.btnWizard = new KDWorkButton((Icon)Resource.ICON_FORMULA_WIZARD);
            this.btnWizard.setText(WizardResource.getString("res_3"));
        }
        return this.btnWizard;
    }

    protected FormulaEditorDialog getFormulaDialog() {
        if (this.formulaDialog == null) {
            this.formulaDialog = (FormulaEditorDialog)((Object)WindowUtil.createWindow(FormulaEditorDialog.class, (Component)((Object)this)));
            this.getFormulaEditor().setOwner(this.formulaDialog);
            this.formula.validateChildren();
        }
        return this.formulaDialog;
    }

    protected abstract FormulaWizardEditor getFormulaEditor();

    public void setTitle(String text) {
        this.labTitle.setText(text);
    }

    public String getTitle() {
        return this.labTitle.getText();
    }

    public void setContent(String text) {
        this.getTextArea().setText(text);
        this.getTextArea().setCaretPosition(0);
    }

    public String getContent() {
        return this.getTextArea().getText();
    }

    public void addButton(JComponent newBtn) {
        newBtn.setMinimumSize(new Dimension(26, 19));
        this.resetTitlePaneLayout(newBtn);
    }
}

