/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.dataprocess;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.data.modal.IDataDef;
import com.kingdee.bos.ctrl.data.modal.ProcessScript;
import com.kingdee.bos.ctrl.data.modal.types.ScriptType;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.DataSetBeanShellProcess;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.DataSetJProcess;
import com.kingdee.bos.ctrl.data.wizard.dataprocess.DataprocessResource;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DataSetProcess
extends KDPanel {
    protected KDCheckBox cbxUseJava;
    protected DataSetJProcess jProcess;
    protected DataSetBeanShellProcess bsProcess;
    protected IDataDef dataObj;
    protected KDPanel panCard;
    protected CardLayout cardLayout;

    public DataSetProcess() {
        this.initComponents();
        this.initListeners();
    }

    public boolean isUseBeanShell() {
        return !this.cbxUseJava.isSelected();
    }

    public void setEnableSwitchScriptType(boolean b, boolean remove) {
        this.cbxUseJava.setEnabled(b);
        if (!b && remove) {
            this.remove((Component)this.cbxUseJava);
        }
    }

    protected void initComponents() {
        this.jProcess = new DataSetJProcess();
        this.bsProcess = new DataSetBeanShellProcess();
        this.cbxUseJava = new KDCheckBox(DataprocessResource.getString("res_8") + "java" + DataprocessResource.getString("res_9"));
        TableLayout table = TableLayout.split((int)2, (int)1);
        this.setLayout((LayoutManager)table);
        table.rowStyle(0).setPriY(1);
        table.rowStyle(0).setMarginBottom(6);
        this.cardLayout = new CardLayout();
        this.panCard = new KDPanel((LayoutManager)this.cardLayout);
        this.panCard.setOpaque(false);
        this.panCard.add((Component)((Object)this.jProcess), (Object)"java");
        this.panCard.add((Component)((Object)this.bsProcess), (Object)"beanshell");
        this.add((Component)this.panCard, table.cell(0, 0));
        this.add((Component)this.cbxUseJava, table.cell(1, 0));
    }

    private void showCard(boolean showJ) {
        if (showJ) {
            this.cardLayout.show((Container)this.panCard, "java");
        } else {
            this.cardLayout.show((Container)this.panCard, "beanshell");
        }
        this.cbxUseJava.setSelected(showJ);
    }

    protected void initListeners() {
        this.cbxUseJava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetProcess.this.showCard(DataSetProcess.this.cbxUseJava.isSelected());
            }
        });
    }

    public final void updateDataObj(IDataDef dataObj) {
        ProcessScript newPs = null;
        newPs = this.cbxUseJava.isSelected() ? this.jProcess.makeProcessScript() : this.bsProcess.makeProcessScript();
        dataObj.setProcessScript(newPs);
    }

    public final void setDataObj(IDataDef dataObj) {
        this.dataObj = dataObj;
        this.jProcess.setDataObj(dataObj);
        this.bsProcess.setDataObj(dataObj);
        ProcessScript ps = dataObj.getProcessScript();
        boolean showB = ps != null && ps.getType() == ScriptType.BEANSHELL;
        this.showCard(!showB);
    }

    public final DataSetJProcess getJProcess() {
        return this.jProcess;
    }

    public final DataSetBeanShellProcess getBsProcess() {
        return this.bsProcess;
    }

    public static interface IProcessScriptMaker {
        public ProcessScript makeProcessScript();

        public void setDataObj(IDataDef var1);
    }
}

