/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.note;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.ui.ListView;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelectListener;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import com.kingdee.bos.ctrl.data.wizard.Wizard2Resource;
import com.kingdee.bos.ctrl.data.wizard.framework.IDataWizardModel;
import com.kingdee.bos.ctrl.data.wizard.framework.query.AbstractQueryWizardTabbedUI;
import com.kingdee.bos.ctrl.data.wizard.framework.query.IQueryWizardModel;
import com.kingdee.bos.ctrl.swing.DefaultKingdeeListCellRenderer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;

public class QuerySelectorWizardUI
extends AbstractQueryWizardTabbedUI {
    private CustomSelector _selector;

    public String getTabbedTitle() {
        return Wizard2Resource.getString("res_31");
    }

    @Override
    public void setModel(IDataWizardModel model) {
        super.setModel(model);
        if (model instanceof IQueryWizardModel && this._selector != null) {
            this._selector.addObjectSelectorUI(((IQueryWizardModel)model).getObjectSelector());
        }
    }

    @Override
    protected KDPanel createPanel() {
        this._selector = new CustomSelector();
        if (this.getModel() != null) {
            this._selector.addObjectSelectorUI(this.getModel().getObjectSelector());
        }
        return this._selector;
    }

    @Override
    protected void doShowModel2Ui() {
        this._selector.getSelectedList().removeAllElements();
        String tableExpr = this.getModel().getQuery().getContent();
        this._selector.addTable(tableExpr);
    }

    @Override
    public void syncUi2Model() {
        if (this._selector.getSelectedList().getElementCount() > 0) {
            String expr = ((ITable)this._selector.getSelectedList().getElement(0)).getExpr();
            this.getModel().getQuery().setContent(expr);
        } else {
            this.getModel().getQuery().setContent("");
        }
    }

    @Override
    public void syncModel2Ui() {
    }

    @Override
    public void preEvent(JComponent parentCtrl) {
        String tableExpr = this.getModel().getQuery().getContent();
        if (!StringUtil.isEmptyString((String)tableExpr) && this.getModel().getObjectSelector().getObject(tableExpr) == null) {
            StringBuffer sb = new StringBuffer(Wizard2Resource.getString("res_32"));
            sb.append(tableExpr);
            WindowUtil.msgboxError((Object)sb.toString(), (String)this.getTabbedTitle(), (Component)parentCtrl);
        }
    }

    private class CustomSelector
    extends NormalSelector {
        public CustomSelector() {
            this.setSupplyTitle(Wizard2Resource.getString("res_33"));
            this.setSelectedTitle(Wizard2Resource.getString("res_34"));
            this.enableSelectAll(false);
            this.enableDeleteAll(false);
            this.getSelectedList().setCellRenderer((ListCellRenderer)((Object)new Renderer()));
        }

        public void addObjectSelectorUI(IObjectSelector objectSelector) {
            this.setSupplyCtrlNoScroll(objectSelector.getUI());
            SupplySelectChangeHandler handler = new SupplySelectChangeHandler(objectSelector);
            objectSelector.setSelectListener((IObjectSelectListener)handler);
            this.syncSelectButton(objectSelector);
        }

        protected void onSelect() {
            String info = QuerySelectorWizardUI.this.getModel().getObjectSelector().getSelectedInfo();
            this.addTable(info);
        }

        public void addTable(String info) {
            MetaClass data = (MetaClass)QuerySelectorWizardUI.this.getModel().getObjectSelector().getObject(info);
            if (data != null) {
                Table tbl = new Table();
                tbl.copy((IDefObj)data);
                tbl.setName(FullPath.cutCategory((String)data.getName()));
                tbl.setExpr(info);
                this.getSelectedList().addElement((Object)tbl);
                this.getSelectedList().setSelectedValue((Object)tbl, true);
                this.syncSelectButton(null);
            }
        }

        protected boolean onDelete() {
            boolean result = super.onDelete();
            if (result) {
                this.syncSelectButton(QuerySelectorWizardUI.this.getModel().getObjectSelector());
            }
            return result;
        }

        protected boolean onDeleteAll() {
            boolean result = super.onDeleteAll();
            if (result) {
                this.syncSelectButton(QuerySelectorWizardUI.this.getModel().getObjectSelector());
            }
            return result;
        }

        protected void syncListViewButton() {
            super.syncListViewButton();
            this.getSelected().getButton(ListView.BUTTON_MOVE_UP).setEnabled(false);
            this.getSelected().getButton(ListView.BUTTON_MOVE_DOWN).setEnabled(false);
        }

        private void syncSelectButton(IObjectSelector objectSelector) {
            if (objectSelector == null) {
                this.enableSelect(false);
            } else {
                boolean isCanSelect = !StringUtil.isEmptyString((String)objectSelector.getSelectedInfo());
                boolean isSelected = this.getSelectedList().getElementCount() > 0;
                this.enableSelect(isCanSelect && !isSelected);
            }
        }

        class Renderer
        extends DefaultKingdeeListCellRenderer {
            Renderer() {
            }

            protected String getDrawingText(Object item) {
                if (item instanceof ITable) {
                    ITable table = (ITable)item;
                    StringBuffer sb = new StringBuffer();
                    sb.append(table.getAliasName());
                    sb.append(" \uff08");
                    sb.append(table.getExpr());
                    sb.append("\uff09");
                    return sb.toString();
                }
                return item.toString();
            }
        }

        class SupplySelectChangeHandler
        implements IObjectSelectListener {
            private IObjectSelector objectSelector;

            public SupplySelectChangeHandler(IObjectSelector objectSelector) {
                this.objectSelector = objectSelector;
            }

            public void selectChanged() {
                CustomSelector.this.syncSelectButton(this.objectSelector);
            }

            public void selectConfirm() {
            }
        }
    }
}

