/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.process;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.engine.KsqlTextVariantsSolver;
import com.kingdee.bos.ctrl.data.invoke.DataContext;
import com.kingdee.bos.ctrl.data.modal.Import;
import com.kingdee.bos.ctrl.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.data.process.IDataProcessModel;
import com.kingdee.bos.ctrl.kdf.expr.Parser;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class AbstractModelExecutor {
    private static final Logger log = LogUtil.getLogger(AbstractModelExecutor.class);
    private IDataProcessModel model;
    protected DataContext ctx;

    public IDataProcessModel getModel() {
        return this.model;
    }

    public void setModel(IDataProcessModel model) {
        this.model = model;
    }

    public DataContext getDataContext() {
        return this.ctx;
    }

    public void setDataContext(DataContext dataContext) {
        this.ctx = dataContext;
    }

    public Object getArgValue(String name) {
        return this.getDataContext().getParameters().get(name);
    }

    public final Object compExprVal(String expr) throws Exception {
        Parser parser = this.ctx.getFormulaEngine();
        parser.prepare(null, expr);
        Variant var = parser.parse();
        if (var.getVt() != 16) {
            return var.getValue();
        }
        throw new Exception("Expresssion error. expr=" + expr);
    }

    protected Object executeImport(String pathX, HashMap pathXArgs_Def) throws Exception {
        HashMap execArgs = new HashMap();
        Iterator keys = pathXArgs_Def.keySet().iterator();
        Iterator vals = pathXArgs_Def.values().iterator();
        while (keys.hasNext()) {
            Object pVal = vals.next();
            Parameter param = (Parameter)keys.next();
            if (pVal == null) continue;
            if (pVal instanceof Parameter) {
                pVal = this.getArgValue(param.getName());
            } else if (pVal instanceof String) {
                pVal = ParamUtil.isDataViewParam((Parameter)param) ? KsqlTextVariantsSolver.solve((String)((String)pVal), (HashMap)this.ctx.getParameters(), (boolean)true) : this.compExprVal((String)pVal);
            } else {
                throw new UnsupportedOperationException("unsupport parameter value:" + pVal + ",type:" + pVal.getClass());
            }
            execArgs.put(param.getName(), pVal);
        }
        Object obj = this.executeImport(pathX, execArgs, this.ctx);
        return obj;
    }

    public Object executeImport(String name, HashMap params, DataContext ctx) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executeImport: '" + name + "'"));
        }
        long t0 = System.currentTimeMillis();
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("executeMode", "RESULT_SET");
        Import importObj = ctx.getDataObject().getImports().get(name);
        if (importObj == null) {
            throw new Exception("Couldn't find import object: '" + name + "' in imports list!");
        }
        FullPath fp = FullPath.parse((String)importObj.getExpr());
        Object rv = ctx.getDataExecutor().execute(null, (Object)fp, params, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("executeImport token:" + (System.currentTimeMillis() - t0)));
        }
        return rv;
    }

    public abstract Object executeModel() throws Exception;
}

