/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.process.simple_gt;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.data.process.dataset.group.aggregate.Aggregates;
import com.kingdee.bos.ctrl.data.wizard.process.Process2Resource;
import com.kingdee.bos.ctrl.data.wizard.process.simple_gt.GroupTotalDefTree;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class SimpleGroupTotalDefPanel
extends KDPanel {
    private KDWorkButton btMoveUp;
    private KDWorkButton btMoveDown;
    private KDComboBox cbTotalMethods;
    private GroupTotalDefTree defTree;
    private boolean defGroup;

    public SimpleGroupTotalDefPanel(boolean defGroup) {
        this.defGroup = defGroup;
        this.initComponents(defGroup);
        this.initActionListeners();
    }

    public GroupTotalDefTree getDefTree() {
        return this.defTree;
    }

    private void initActionListeners() {
        KDWorkButton[] bts = new KDWorkButton[]{this.btMoveUp, this.btMoveDown};
        for (int i = 0; i < bts.length; ++i) {
            bts[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimpleGroupTotalDefPanel.this.defTree.moveCurrentNode(SimpleGroupTotalDefPanel.this.btMoveUp == e.getSource());
                }
            });
        }
        this.defTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path == null) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                SimpleGroupTotalDefPanel.this.btMoveUp.setEnabled(false);
                SimpleGroupTotalDefPanel.this.btMoveDown.setEnabled(false);
                if (!SimpleGroupTotalDefPanel.this.defGroup) {
                    SimpleGroupTotalDefPanel.this.cbTotalMethods.setSelectedIndex(-1);
                    SimpleGroupTotalDefPanel.this.cbTotalMethods.setEnabled(false);
                }
                if (node.isRoot()) {
                    return;
                }
                DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
                if (SimpleGroupTotalDefPanel.this.defGroup) {
                    if (!parent.isRoot()) {
                        SimpleGroupTotalDefPanel.this.btMoveUp.setEnabled(true);
                    }
                    if (SimpleGroupTotalDefPanel.this.defTree.hasSubGroupDef(node)) {
                        SimpleGroupTotalDefPanel.this.btMoveDown.setEnabled(true);
                    }
                } else if (!SimpleGroupTotalDefPanel.this.defTree.isGroupDefNode(node)) {
                    if (!parent.isRoot()) {
                        SimpleGroupTotalDefPanel.this.btMoveUp.setEnabled(true);
                    }
                    if (SimpleGroupTotalDefPanel.this.defTree.hasSubGroupDef(parent)) {
                        SimpleGroupTotalDefPanel.this.btMoveDown.setEnabled(true);
                    }
                    GroupTotalDefTree.NodeUserObject nodeObj = (GroupTotalDefTree.NodeUserObject)node.getUserObject();
                    SimpleGroupTotalDefPanel.this.cbTotalMethods.setEnabled(true);
                    SimpleGroupTotalDefPanel.this.cbTotalMethods.setSelectedItem((Object)nodeObj.totalMethod);
                }
            }
        });
        this.defTree.initRootNode();
        if (!this.defGroup) {
            this.cbTotalMethods.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getID() == 701 && e.getStateChange() == 1) {
                        String method = (String)e.getItem();
                        DefaultKingdeeTreeNode curNode = SimpleGroupTotalDefPanel.this.defTree.getCurrentNode();
                        GroupTotalDefTree.NodeUserObject nodeObj = (GroupTotalDefTree.NodeUserObject)curNode.getUserObject();
                        if (!Aggregates.isSupported((String)method, (DataType)nodeObj.columnRef.getDataType())) {
                            String msg = Process2Resource.getString("res_52");
                            MessageDialog.show((Component)((Object)SimpleGroupTotalDefPanel.this), (Object)msg, (String)Process2Resource.getString("res_53"), (int)-1);
                            SimpleGroupTotalDefPanel.this.cbTotalMethods.setSelectedItem((Object)Aggregates.getDefaultTotalMethod((DataType)nodeObj.columnRef.getDataType()));
                            return;
                        }
                        SimpleGroupTotalDefPanel.this.defTree.changeTotalMethod(method);
                    }
                }
            });
        }
    }

    private void initComponents(boolean defGroup) {
        this.btMoveUp = new KDWorkButton((Icon)Resource.ICON_MOVE_TOP);
        this.btMoveDown = new KDWorkButton((Icon)Resource.ICON_MOVE_DOWN);
        KDLabel label = new KDLabel(defGroup ? Process2Resource.getString("res_54") : Process2Resource.getString("res_55"));
        this.defTree = new GroupTotalDefTree(defGroup);
        if (!defGroup) {
            Object[] methods = new String[]{"max", "min", "sum", "count", "avg"};
            this.cbTotalMethods = new KDComboBox(methods);
        }
        TableLayout layout = TableLayout.split((int)(defGroup ? 2 : 3), (int)1);
        this.setLayout((LayoutManager)layout);
        Table tableLayout = layout.cell(0, 0).split(1, 3);
        this.add((Component)label, tableLayout.cell(0, 0));
        this.add((Component)this.btMoveUp, tableLayout.cell(0, 1));
        this.add((Component)this.btMoveDown, tableLayout.cell(0, 2));
        tableLayout.colStyle(0).setPriX(1);
        tableLayout.rowStyle(0).setHeight(20);
        this.add((Component)new KDScrollPane((Component)((Object)this.defTree)), layout.cell(1, 0));
        if (!defGroup) {
            layout.rowStyle(1).setMargin(0, 0, 0, 4);
            this.add((Component)this.cbTotalMethods, layout.cell(2, 0));
        }
        layout.rowStyle(1).setPriY(1);
        if (!defGroup) {
            this.btMoveUp.setVisible(false);
            this.btMoveDown.setVisible(false);
        }
    }
}

