/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.query;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.IColumnList;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.data.wizard.Wizard2Resource;
import com.kingdee.bos.ctrl.data.wizard.common.AbstractFieldSelector;
import com.kingdee.bos.ctrl.data.wizard.common.FieldEditorDialog;
import com.kingdee.bos.ctrl.data.wizard.formula.FormulaWizardEditor;
import com.kingdee.bos.ctrl.data.wizard.framework.IDataWizardModel;
import com.kingdee.bos.ctrl.data.wizard.framework.datadef.ICommonQueryWizardModel;
import com.kingdee.bos.ctrl.data.wizard.framework.query.AbstractQueryWizardTabbedUI;
import com.kingdee.bos.ctrl.data.wizard.framework.query.IQueryWizardModel;
import com.kingdee.bos.ctrl.data.wizard.util.WizardUtil;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FieldWizardUI
extends AbstractQueryWizardTabbedUI {
    private CustomSelector _selector;
    private TableChangedHandler _tableChangedHandler;

    public String getTabbedTitle() {
        return Wizard2Resource.getString("res_29");
    }

    @Override
    protected KDPanel createPanel() {
        this._selector = new CustomSelector(this.getModel());
        return this._selector;
    }

    @Override
    protected void doShowModel2Ui() {
        IColumnList queryColumns = this.getModel().getQuery().getColumns();
        this._selector.getSelectedList().removeAllElements();
        for (int i = 0; i < queryColumns.size(); ++i) {
            this._selector.getSelectedList().addElement(queryColumns.get(i));
        }
    }

    @Override
    public void syncUi2Model() {
        KDList fieldList = this._selector.getSelectedList();
        IColumnList list = this.getModel().getQuery().getColumns();
        list.clear();
        for (int i = 0; i < fieldList.getElementCount(); ++i) {
            Column column = (Column)fieldList.getElement(i);
            list.add(i, (Object)column);
        }
    }

    @Override
    public void syncModel2Ui() {
        this._selector.updateSupplyTree();
        this._selector.updateFormulaWizard();
    }

    @Override
    public void setModel(IDataWizardModel model) {
        super.setModel(model);
        if (this._tableChangedHandler == null) {
            this._tableChangedHandler = new TableChangedHandler();
        }
        model.removePropertyChangedListener(this._tableChangedHandler);
        model.addPropertyChangedListener(this._tableChangedHandler);
    }

    class CustomSelector
    extends AbstractFieldSelector {
        public CustomSelector(IQueryWizardModel model) {
            super(model);
        }

        @Override
        protected void updateSupplyTree(KDTree treSupply, IQueryWizardModel model) {
            DefaultKingdeeTreeNode oldRoot = (DefaultKingdeeTreeNode)treSupply.getModel().getRoot();
            DefaultKingdeeTreeNode newRoot = new DefaultKingdeeTreeNode();
            ITableList queryTables = model.getQuery().getTables();
            for (int i = 0; i < queryTables.size(); ++i) {
                ITable queryTable = (ITable)queryTables.get(i);
                DefaultKingdeeTreeNode nodeTable = null;
                boolean isExist = false;
                int tableNodeCount = oldRoot.getChildCount();
                for (int j = 0; j < tableNodeCount; ++j) {
                    DefaultKingdeeTreeNode nodeTableTemp = (DefaultKingdeeTreeNode)oldRoot.getChildAt(j);
                    MetaClass existTable = (MetaClass)nodeTableTemp.getUserObject();
                    if (!StringUtil.equals((String)queryTable.getName(), (String)existTable.getName()) || !StringUtil.equals((String)queryTable.getAlias(), (String)existTable.getAlias())) continue;
                    nodeTable = nodeTableTemp;
                    isExist = true;
                    break;
                }
                if (!isExist) {
                    MetaClass mc = WizardUtil.lookForMetaClass(queryTable, model);
                    if (mc == null) continue;
                    MetaClass mcTable = new MetaClass();
                    mcTable.copy((IDefObj)queryTable);
                    mcTable.setFields(mc.getFields());
                    nodeTable = new DefaultKingdeeTreeNode((Object)mcTable);
                    for (MetaField mf : mcTable.getFields()) {
                        nodeTable.add((MutableTreeNode)new DefaultKingdeeTreeNode((Object)mf));
                    }
                }
                newRoot.add(nodeTable);
            }
            TreePath path = treSupply.getSelectionPath();
            DefaultKingdeeTreeNode nodeOriSelected = null;
            if (path != null) {
                nodeOriSelected = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            }
            ((DefaultTreeModel)treSupply.getModel()).setRoot((TreeNode)newRoot);
            treSupply.expandAllNodes(true, (TreeNode)newRoot);
            if (newRoot.isNodeDescendant((DefaultMutableTreeNode)nodeOriSelected)) {
                treSupply.setSelectionNode(nodeOriSelected);
            } else {
                treSupply.setSelectionPath(null);
            }
            this.syncSelectButton();
        }

        @Override
        protected Column createObjectToSelect(MetaField metaField, MetaClass metaClass) {
            Column col = new Column();
            col.copy((IDefObj)metaField);
            col.setDataType(metaField.getType());
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            sb.append(metaClass.getName());
            sb.append("].[");
            sb.append(metaField.getName());
            sb.append("]");
            col.setExpr(sb.toString());
            return col;
        }

        @Override
        protected FieldEditorDialog createFieldEditor() {
            FieldEditorDialog fieldEditor = (FieldEditorDialog)((Object)WindowUtil.createWindow(FieldEditorDialog.class, (Component)((Object)this)));
            fieldEditor.setTitle(Wizard2Resource.getString("res_18"));
            fieldEditor.setBosQueryMode(false, false);
            return fieldEditor;
        }

        @Override
        protected FormulaWizardEditor createFormulaWizard() {
            FormulaWizardEditor formulaWizard = new FormulaWizardEditor();
            formulaWizard.addFieldSupplyGroup();
            formulaWizard.getFieldSupplyGroup().addNodeCurrentFields();
            formulaWizard.getFieldSupplyGroup().addNodeMetaFields();
            if (FieldWizardUI.this.getModel() instanceof ICommonQueryWizardModel) {
                formulaWizard.getFieldSupplyGroup().addNodeParamFields();
            }
            return formulaWizard;
        }

        @Override
        protected void updateFormulaWizard(FormulaWizardEditor formulaWizard) {
            formulaWizard.getFieldSupplyGroup().updateFieldSupplyGroup(this.getSelectedList(), false);
            ITable[] tables = (ITable[])FieldWizardUI.this.getModel().getQuery().getTables().toArray((Object[])new ITable[0]);
            List listMcs = WizardUtil.queryTables2MetaClasses(FieldWizardUI.this.getModel());
            MetaClass[] mcs = listMcs.toArray(new MetaClass[0]);
            formulaWizard.getFieldSupplyGroup().updateTableSupplyGroup(tables, mcs, false);
            if (FieldWizardUI.this.getModel() instanceof ICommonQueryWizardModel) {
                ICommonQueryWizardModel model = (ICommonQueryWizardModel)FieldWizardUI.this.getModel();
                List listParam = model.getCommonQuery().getParameters();
                formulaWizard.getFieldSupplyGroup().updateParamGroup(listParam);
            }
        }

        @Override
        protected void fireNameChanged(Column col, FieldEditorDialog editor) {
            if (!editor.getAlias().equalsIgnoreCase(col.getAlias())) {
                FieldWizardUI.this.getModel().firePropertyChanged(col, "field alias", col.getAlias(), editor.getAlias());
            }
            if (!editor.getID().equalsIgnoreCase(col.getName())) {
                FieldWizardUI.this.getModel().firePropertyChanged(col, "field name", col.getName(), editor.getID());
            }
        }
    }

    private class TableChangedHandler
    implements PropertyChangeListener {
        private TableChangedHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (FieldWizardUI.this._selector == null) {
                return;
            }
            if (evt.getPropertyName() == "table name") {
                this.changeTableName((String)evt.getOldValue(), (String)evt.getNewValue());
            }
        }

        private void changeTableName(String oldName, String newName) {
            int length = oldName.length();
            IColumnList queryColumns = FieldWizardUI.this.getModel().getQuery().getColumns();
            for (Column column : queryColumns) {
                String exprTableName;
                String expr = column.getExpr();
                if (expr.length() <= length + 1 || !StringUtil.equals((String)(exprTableName = expr.substring(1, 1 + length)), (String)oldName)) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(expr.substring(0, 1));
                sb.append(newName);
                sb.append(expr.substring(1 + length));
                column.setExpr(sb.toString());
            }
        }
    }
}

