/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.analysis;

import com.kingdee.bos.ctrl.lucene.analysis.Token;
import com.kingdee.bos.ctrl.lucene.analysis.Tokenizer;
import java.io.IOException;
import java.io.Reader;

public abstract class CharTokenizer
extends Tokenizer {
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 1024;
    private final char[] buffer = new char[255];
    private final char[] ioBuffer = new char[1024];

    public CharTokenizer(Reader input) {
        super(input);
    }

    protected abstract boolean isTokenChar(char var1);

    protected char normalize(char c) {
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Token next() throws IOException {
        int length = 0;
        int start = this.offset;
        while (true) {
            char c;
            ++this.offset;
            if (this.bufferIndex >= this.dataLen) {
                this.dataLen = this.input.read(this.ioBuffer);
                this.bufferIndex = 0;
            }
            if (this.dataLen == -1) {
                if (length > 0) return new Token(new String(this.buffer, 0, length), start, start + length);
                return null;
            }
            if (this.isTokenChar(c = this.ioBuffer[this.bufferIndex++])) {
                if (length == 0) {
                    start = this.offset - 1;
                }
                this.buffer[length++] = this.normalize(c);
                if (length != 255) continue;
                return new Token(new String(this.buffer, 0, length), start, start + length);
            }
            if (length > 0) return new Token(new String(this.buffer, 0, length), start, start + length);
        }
    }
}

