/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.index;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import java.io.IOException;

class MultiTermDocs
implements TermDocs {
    protected IndexReader[] readers;
    protected int[] starts;
    protected Term term;
    protected int base = 0;
    protected int pointer = 0;
    private TermDocs[] readerTermDocs;
    protected TermDocs current;

    public MultiTermDocs(IndexReader[] r, int[] s) {
        this.readers = r;
        this.starts = s;
        this.readerTermDocs = new TermDocs[r.length];
    }

    @Override
    public int doc() {
        return this.base + this.current.doc();
    }

    @Override
    public int freq() {
        return this.current.freq();
    }

    @Override
    public void seek(Term term) {
        this.term = term;
        this.base = 0;
        this.pointer = 0;
        this.current = null;
    }

    @Override
    public void seek(TermEnum termEnum) throws IOException {
        this.seek(termEnum.term());
    }

    @Override
    public boolean next() throws IOException {
        while (true) {
            if (this.current != null && this.current.next()) {
                return true;
            }
            if (this.pointer >= this.readers.length) break;
            this.base = this.starts[this.pointer];
            this.current = this.termDocs(this.pointer++);
        }
        return false;
    }

    @Override
    public int read(int[] docs, int[] freqs) throws IOException {
        int end;
        while (true) {
            if (this.current == null) {
                if (this.pointer < this.readers.length) {
                    this.base = this.starts[this.pointer];
                    this.current = this.termDocs(this.pointer++);
                    continue;
                }
                return 0;
            }
            end = this.current.read(docs, freqs);
            if (end != 0) break;
            this.current = null;
        }
        int b = this.base;
        int i = 0;
        while (i < end) {
            int n = i++;
            docs[n] = docs[n] + b;
        }
        return end;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        while (true) {
            if (this.current != null && this.current.skipTo(target - this.base)) {
                return true;
            }
            if (this.pointer >= this.readers.length) break;
            this.base = this.starts[this.pointer];
            this.current = this.termDocs(this.pointer++);
        }
        return false;
    }

    private TermDocs termDocs(int i) throws IOException {
        if (this.term == null) {
            return null;
        }
        TermDocs result = this.readerTermDocs[i];
        if (result == null) {
            result = this.readerTermDocs[i] = this.termDocs(this.readers[i]);
        }
        result.seek(this.term);
        return result;
    }

    protected TermDocs termDocs(IndexReader reader) throws IOException {
        return reader.termDocs();
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.readerTermDocs.length; ++i) {
            if (this.readerTermDocs[i] == null) continue;
            this.readerTermDocs[i].close();
        }
    }
}

