/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.ComplexExplanation;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Searcher;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import com.kingdee.bos.ctrl.lucene.util.ToStringUtils;
import java.util.Set;

public class MatchAllDocsQuery
extends Query {
    @Override
    protected Weight createWeight(Searcher searcher) {
        return new MatchAllDocsWeight(searcher);
    }

    @Override
    public void extractTerms(Set terms) {
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MatchAllDocsQuery");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MatchAllDocsQuery)) {
            return false;
        }
        MatchAllDocsQuery other = (MatchAllDocsQuery)o;
        return this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ 0x1AA71190;
    }

    private class MatchAllDocsWeight
    implements Weight {
        private Similarity similarity;
        private float queryWeight;
        private float queryNorm;

        public MatchAllDocsWeight(Searcher searcher) {
            this.similarity = searcher.getSimilarity();
        }

        public String toString() {
            return "weight(" + MatchAllDocsQuery.this + ")";
        }

        @Override
        public Query getQuery() {
            return MatchAllDocsQuery.this;
        }

        @Override
        public float getValue() {
            return this.queryWeight;
        }

        @Override
        public float sumOfSquaredWeights() {
            this.queryWeight = MatchAllDocsQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= this.queryNorm;
        }

        @Override
        public Scorer scorer(IndexReader reader) {
            return new MatchAllScorer(reader, this.similarity, this);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) {
            ComplexExplanation queryExpl = new ComplexExplanation(true, this.getValue(), "MatchAllDocsQuery, product of:");
            if (MatchAllDocsQuery.this.getBoost() != 1.0f) {
                queryExpl.addDetail(new Explanation(MatchAllDocsQuery.this.getBoost(), "boost"));
            }
            queryExpl.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            return queryExpl;
        }
    }

    private class MatchAllScorer
    extends Scorer {
        final IndexReader reader;
        int id;
        final int maxId;
        final float score;

        MatchAllScorer(IndexReader reader, Similarity similarity, Weight w) {
            super(similarity);
            this.reader = reader;
            this.id = -1;
            this.maxId = reader.maxDoc() - 1;
            this.score = w.getValue();
        }

        @Override
        public Explanation explain(int doc) {
            return null;
        }

        @Override
        public int doc() {
            return this.id;
        }

        @Override
        public boolean next() {
            while (this.id < this.maxId) {
                ++this.id;
                if (this.reader.isDeleted(this.id)) continue;
                return true;
            }
            return false;
        }

        @Override
        public float score() {
            return this.score;
        }

        @Override
        public boolean skipTo(int target) {
            this.id = target - 1;
            return this.next();
        }
    }
}

