/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.Filter;
import com.kingdee.bos.ctrl.lucene.search.PrefixGenerator;
import java.io.IOException;
import java.util.BitSet;

public class PrefixFilter
extends Filter {
    protected final Term prefix;

    public PrefixFilter(Term prefix) {
        this.prefix = prefix;
    }

    public Term getPrefix() {
        return this.prefix;
    }

    @Override
    public BitSet bits(IndexReader reader) throws IOException {
        final BitSet bitSet = new BitSet(reader.maxDoc());
        new PrefixGenerator(this.prefix){

            @Override
            public void handleDoc(int doc) {
                bitSet.set(doc);
            }
        }.generate(reader);
        return bitSet;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PrefixFilter(");
        buffer.append(this.prefix.toString());
        buffer.append(")");
        return buffer.toString();
    }
}

