/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import java.io.IOException;

public class ReqOptSumScorer
extends Scorer {
    private Scorer reqScorer;
    private Scorer optScorer;
    private boolean firstTimeOptScorer = true;

    public ReqOptSumScorer(Scorer reqScorer, Scorer optScorer) {
        super(null);
        this.reqScorer = reqScorer;
        this.optScorer = optScorer;
    }

    @Override
    public boolean next() throws IOException {
        return this.reqScorer.next();
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        return this.reqScorer.skipTo(target);
    }

    @Override
    public int doc() {
        return this.reqScorer.doc();
    }

    @Override
    public float score() throws IOException {
        int curDoc = this.reqScorer.doc();
        float reqScore = this.reqScorer.score();
        if (this.firstTimeOptScorer) {
            this.firstTimeOptScorer = false;
            if (!this.optScorer.skipTo(curDoc)) {
                this.optScorer = null;
                return reqScore;
            }
        } else {
            if (this.optScorer == null) {
                return reqScore;
            }
            if (this.optScorer.doc() < curDoc && !this.optScorer.skipTo(curDoc)) {
                this.optScorer = null;
                return reqScore;
            }
        }
        return this.optScorer.doc() == curDoc ? reqScore + this.optScorer.score() : reqScore;
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        Explanation res = new Explanation();
        res.setDescription("required, optional");
        res.addDetail(this.reqScorer.explain(doc));
        res.addDetail(this.optScorer.explain(doc));
        return res;
    }
}

