/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.FilteredTermEnum;
import com.kingdee.bos.ctrl.lucene.search.MultiTermQuery;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.TermQuery;
import com.kingdee.bos.ctrl.lucene.search.WildcardTermEnum;
import java.io.IOException;

public class WildcardQuery
extends MultiTermQuery {
    private boolean termContainsWildcard;

    public WildcardQuery(Term term) {
        super(term);
        this.termContainsWildcard = term.text().indexOf(42) != -1 || term.text().indexOf(63) != -1;
    }

    @Override
    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new WildcardTermEnum(reader, this.getTerm());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof WildcardQuery) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.termContainsWildcard) {
            return super.rewrite(reader);
        }
        return new TermQuery(this.getTerm());
    }
}

