/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.function;

import com.kingdee.bos.ctrl.lucene.search.Explanation;

public abstract class DocValues {
    private int nVals;
    private float minVal;
    private float maxVal;
    private float avgVal;
    private boolean computed = false;

    public DocValues(int nVals) {
        this.nVals = nVals;
    }

    private DocValues() {
    }

    public abstract float floatVal(int var1);

    public int intVal(int doc) {
        return (int)this.floatVal(doc);
    }

    public long longVal(int doc) {
        return (long)this.floatVal(doc);
    }

    public double doubleVal(int doc) {
        return this.floatVal(doc);
    }

    public String strVal(int doc) {
        return Float.toString(this.floatVal(doc));
    }

    public abstract String toString(int var1);

    public Explanation explain(int doc) {
        return new Explanation(this.floatVal(doc), this.toString(doc));
    }

    Object getInnerArray() {
        return new Object[0];
    }

    private void compute() {
        if (this.computed) {
            return;
        }
        this.minVal = Float.MAX_VALUE;
        this.maxVal = 0.0f;
        float sum = 0.0f;
        for (int i = 0; i < this.nVals; ++i) {
            float val = this.floatVal(i);
            sum += val;
            this.minVal = Math.min(this.minVal, val);
            this.maxVal = Math.max(this.maxVal, val);
        }
        this.avgVal = sum / (float)this.nVals;
        this.computed = true;
    }

    public float getMinValue() {
        this.compute();
        return this.minVal;
    }

    public float getMaxValue() {
        this.compute();
        return this.maxVal;
    }

    public float getAverageValue() {
        this.compute();
        return this.avgVal;
    }
}

