/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search.function;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.search.FieldCache;
import com.kingdee.bos.ctrl.lucene.search.function.DocValues;
import com.kingdee.bos.ctrl.lucene.search.function.ValueSource;
import java.io.IOException;

public class ReverseOrdFieldSource
extends ValueSource {
    public String field;
    private static final int hcode = ReverseOrdFieldSource.class.hashCode();

    public ReverseOrdFieldSource(String field) {
        this.field = field;
    }

    @Override
    public String description() {
        return "rord(" + this.field + ')';
    }

    @Override
    public DocValues getValues(IndexReader reader) throws IOException {
        FieldCache.StringIndex sindex = FieldCache.DEFAULT.getStringIndex(reader, this.field);
        final int[] arr = sindex.order;
        final int end = sindex.lookup.length;
        return new DocValues(arr.length){

            @Override
            public float floatVal(int doc) {
                return end - arr[doc];
            }

            @Override
            public int intVal(int doc) {
                return end - arr[doc];
            }

            @Override
            public String strVal(int doc) {
                return Integer.toString(this.intVal(doc));
            }

            @Override
            public String toString(int doc) {
                return ReverseOrdFieldSource.this.description() + '=' + this.strVal(doc);
            }

            @Override
            Object getInnerArray() {
                return arr;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != ReverseOrdFieldSource.class) {
            return false;
        }
        ReverseOrdFieldSource other = (ReverseOrdFieldSource)o;
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

