/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.store;

import com.kingdee.bos.ctrl.lucene.index.IndexFileNameFilter;
import com.kingdee.bos.ctrl.lucene.store.BufferedIndexInput;
import com.kingdee.bos.ctrl.lucene.store.BufferedIndexOutput;
import com.kingdee.bos.ctrl.lucene.store.Directory;
import com.kingdee.bos.ctrl.lucene.store.IndexInput;
import com.kingdee.bos.ctrl.lucene.store.IndexOutput;
import com.kingdee.bos.ctrl.lucene.store.LockFactory;
import com.kingdee.bos.ctrl.lucene.store.NativeFSLockFactory;
import com.kingdee.bos.ctrl.lucene.store.NoLockFactory;
import com.kingdee.bos.ctrl.lucene.store.SimpleFSLockFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.apache.commons.io.FilenameUtils;

public class FSDirectory
extends Directory {
    private static final Hashtable DIRECTORIES = new Hashtable();
    private static boolean disableLocks = false;
    public static final String LOCK_DIR = System.getProperty("com.kingdee.bos.ctrl.lucene.lockDir", System.getProperty("java.io.tmpdir"));
    private static Class IMPL;
    private static MessageDigest DIGESTER;
    private byte[] buffer = null;
    private File directory = null;
    private int refCount;
    private static final char[] HEX_DIGITS;

    public static void setDisableLocks(boolean doDisableLocks) {
        disableLocks = doDisableLocks;
    }

    public static boolean getDisableLocks() {
        return disableLocks;
    }

    public static FSDirectory getDirectory(String path) throws IOException {
        return FSDirectory.getDirectory(new File(path), null);
    }

    public static FSDirectory getDirectory(String path, LockFactory lockFactory) throws IOException {
        return FSDirectory.getDirectory(new File(path), lockFactory);
    }

    public static FSDirectory getDirectory(File file) throws IOException {
        return FSDirectory.getDirectory(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSDirectory getDirectory(File file, LockFactory lockFactory) throws IOException {
        FSDirectory dir;
        if ((file = new File(file.getCanonicalPath())).exists() && !file.isDirectory()) {
            throw new IOException(file + " not a directory");
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot create directory: " + file);
        }
        Object object = DIRECTORIES;
        synchronized (object) {
            dir = (FSDirectory)DIRECTORIES.get(file);
            if (dir == null) {
                try {
                    dir = (FSDirectory)IMPL.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot load FSDirectory class: " + e.toString(), e);
                }
                dir.init(file, lockFactory);
                DIRECTORIES.put(file, dir);
            } else if (lockFactory != null && lockFactory != dir.getLockFactory()) {
                throw new IOException("Directory was previously created with a different LockFactory instance; please pass null as the lockFactory instance and use setLockFactory to change it");
            }
        }
        object = dir;
        synchronized (object) {
            ++dir.refCount;
        }
        return dir;
    }

    public static FSDirectory getDirectory(String path, boolean create) throws IOException {
        return FSDirectory.getDirectory(new File(path), create);
    }

    public static FSDirectory getDirectory(File file, boolean create) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory(file, null);
        if (create) {
            dir.create();
        }
        return dir;
    }

    private void create() throws IOException {
        if (this.directory.exists()) {
            String[] files = this.directory.list(IndexFileNameFilter.getFilter());
            if (files == null) {
                throw new IOException("cannot read directory " + this.directory.getAbsolutePath() + ": list() returned null");
            }
            for (int i = 0; i < files.length; ++i) {
                File file = new File(this.directory, files[i]);
                if (file.delete()) continue;
                throw new IOException("Cannot delete " + file);
            }
        }
        this.lockFactory.clearLock("write.lock");
    }

    protected FSDirectory() {
    }

    private void init(File path, LockFactory lockFactory) throws IOException {
        this.directory = path;
        boolean doClearLockID = false;
        if (lockFactory == null) {
            if (disableLocks) {
                lockFactory = NoLockFactory.getNoLockFactory();
            } else {
                String lockClassName = System.getProperty("com.kingdee.bos.ctrl.lucene.store.FSDirectoryLockFactoryClass");
                if (lockClassName != null && !lockClassName.equals("")) {
                    Class<?> c;
                    try {
                        c = Class.forName(lockClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("unable to find LockClass " + lockClassName);
                    }
                    try {
                        lockFactory = (LockFactory)c.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw new IOException("IllegalAccessException when instantiating LockClass " + lockClassName);
                    }
                    catch (InstantiationException e) {
                        throw new IOException("InstantiationException when instantiating LockClass " + lockClassName);
                    }
                    catch (ClassCastException e) {
                        throw new IOException("unable to cast LockClass " + lockClassName + " instance to a LockFactory");
                    }
                    if (lockFactory instanceof NativeFSLockFactory) {
                        ((NativeFSLockFactory)lockFactory).setLockDir(path);
                    } else if (lockFactory instanceof SimpleFSLockFactory) {
                        ((SimpleFSLockFactory)lockFactory).setLockDir(path);
                    }
                } else {
                    lockFactory = new SimpleFSLockFactory(path);
                    doClearLockID = true;
                }
            }
        }
        this.setLockFactory(lockFactory);
        if (doClearLockID) {
            lockFactory.setLockPrefix(null);
        }
    }

    @Override
    public String[] list() {
        return this.directory.list(IndexFileNameFilter.getFilter());
    }

    @Override
    public boolean fileExists(String name) {
        File file = new File(this.directory, FilenameUtils.normalize((String)name));
        return file.exists();
    }

    @Override
    public long fileModified(String name) {
        File file = new File(this.directory, FilenameUtils.normalize((String)name));
        return file.lastModified();
    }

    public static long fileModified(File directory, String name) {
        File file = new File(directory, FilenameUtils.normalize((String)name));
        return file.lastModified();
    }

    @Override
    public void touchFile(String name) {
        File file = new File(this.directory, FilenameUtils.normalize((String)name));
        file.setLastModified(System.currentTimeMillis());
    }

    @Override
    public long fileLength(String name) {
        File file = new File(this.directory, FilenameUtils.normalize((String)name));
        return file.length();
    }

    @Override
    public void deleteFile(String name) throws IOException {
        File file = new File(this.directory, FilenameUtils.normalize((String)name));
        if (!file.delete()) {
            throw new IOException("Cannot delete " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void renameFile(String from, String to) throws IOException {
        File old = new File(this.directory, FilenameUtils.normalize((String)from));
        File nu = new File(this.directory, FilenameUtils.normalize((String)to));
        if (nu.exists() && !nu.delete()) {
            throw new IOException("Cannot delete " + nu);
        }
        if (!old.renameTo(nu)) {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                int len;
                in = new FileInputStream(old);
                out = new FileOutputStream(nu);
                if (this.buffer == null) {
                    this.buffer = new byte[1024];
                }
                while ((len = ((InputStream)in).read(this.buffer)) >= 0) {
                    ((OutputStream)out).write(this.buffer, 0, len);
                }
                old.delete();
            }
            catch (IOException ioe) {
                IOException newExc = new IOException("Cannot rename " + old + " to " + nu);
                newExc.initCause(ioe);
                throw newExc;
            }
            finally {
                block28: {
                    try {
                        if (in == null) break block28;
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Cannot close input stream: " + e.toString(), e);
                        }
                    }
                    finally {
                        if (out != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Cannot close output stream: " + e.toString(), e);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public IndexOutput createOutput(String name) throws IOException {
        File file = new File(this.directory, FilenameUtils.normalize((String)name));
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
        return new FSIndexOutput(file);
    }

    @Override
    public IndexInput openInput(String name) throws IOException {
        return new FSIndexInput(new File(this.directory, FilenameUtils.normalize((String)name)));
    }

    @Override
    public IndexInput openInput(String name, int bufferSize) throws IOException {
        return new FSIndexInput(new File(this.directory, FilenameUtils.normalize((String)name)), bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLockID() {
        byte[] digest;
        String dirName;
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        MessageDigest messageDigest = DIGESTER;
        synchronized (messageDigest) {
            digest = DIGESTER.digest(dirName.getBytes());
        }
        StringBuffer buf = new StringBuffer();
        buf.append("lucene-");
        for (int i = 0; i < digest.length; ++i) {
            byte b = digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (--this.refCount <= 0) {
            Hashtable hashtable = DIRECTORIES;
            synchronized (hashtable) {
                DIRECTORIES.remove(this.directory);
            }
        }
    }

    public File getFile() {
        return this.directory;
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.directory;
    }

    static {
        try {
            String name = System.getProperty("com.kingdee.bos.ctrl.lucene.FSDirectory.class", FSDirectory.class.getName());
            IMPL = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load FSDirectory class: " + e.toString(), e);
        }
        catch (SecurityException se) {
            try {
                IMPL = Class.forName(FSDirectory.class.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("cannot load default FSDirectory class: " + e.toString(), e);
            }
        }
        try {
            DIGESTER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.toString(), e);
        }
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    protected static class FSIndexOutput
    extends BufferedIndexOutput {
        RandomAccessFile file = null;
        private boolean isOpen;

        public FSIndexOutput(File path) throws IOException {
            this.file = new RandomAccessFile(path, "rw");
            this.isOpen = true;
        }

        @Override
        public void flushBuffer(byte[] b, int offset, int size) throws IOException {
            this.file.write(b, offset, size);
        }

        @Override
        public void close() throws IOException {
            if (this.isOpen) {
                super.close();
                this.file.close();
                this.isOpen = false;
            }
        }

        @Override
        public void seek(long pos) throws IOException {
            super.seek(pos);
            this.file.seek(pos);
        }

        @Override
        public long length() throws IOException {
            return this.file.length();
        }
    }

    protected static class FSIndexInput
    extends BufferedIndexInput {
        private final Descriptor file;
        boolean isClone;

        public FSIndexInput(File path) throws IOException {
            this(path, 1024);
        }

        public FSIndexInput(File path, int bufferSize) throws IOException {
            super(bufferSize);
            this.file = new Descriptor(path, "r");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            Descriptor descriptor = this.file;
            synchronized (descriptor) {
                int i;
                long position = this.getFilePointer();
                if (position != this.file.position) {
                    this.file.seek(position);
                    this.file.position = position;
                }
                int total = 0;
                do {
                    if ((i = this.file.read(b, offset + total, len - total)) == -1) {
                        throw new IOException("read past EOF");
                    }
                    this.file.position += (long)i;
                } while ((total += i) < len);
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.isClone) {
                this.file.close();
            }
        }

        @Override
        protected void seekInternal(long position) {
        }

        @Override
        public long length() {
            return this.file.length;
        }

        @Override
        public Object clone() {
            FSIndexInput clone = (FSIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        boolean isFDValid() throws IOException {
            return this.file.getFD().valid();
        }

        private static class Descriptor
        extends RandomAccessFile {
            private boolean isOpen = true;
            long position;
            final long length = this.length();

            public Descriptor(File file, String mode) throws IOException {
                super(file, mode);
            }

            @Override
            public void close() throws IOException {
                if (this.isOpen) {
                    this.isOpen = false;
                    super.close();
                }
            }

            protected void finalize() throws Throwable {
                try {
                    this.close();
                }
                finally {
                    super.finalize();
                }
            }
        }
    }
}

