/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;

public class TransientRepository
implements JackrabbitRepository,
SessionListener {
    private static final Logger logger = CommonSLF4JLogger.getLogger(TransientRepository.class);
    private static final int BUFFER_SIZE = 4096;
    private static final String DEFAULT_REPOSITORY_XML = "repository.xml";
    private static final String CONF_PROPERTY = "org.apache.jackrabbit.repository.conf";
    private static final String CONF_DEFAULT = "repository.xml";
    private static final String HOME_PROPERTY = "org.apache.jackrabbit.repository.home";
    private static final String HOME_DEFAULT = "repository";
    private final RepositoryFactory factory;
    private RepositoryImpl repository;
    private final Set sessions;
    private final Properties descriptors;

    public TransientRepository(RepositoryFactory factory) throws IOException {
        this.factory = factory;
        this.repository = null;
        this.sessions = new HashSet();
        this.descriptors = new Properties();
        try (InputStream in = RepositoryImpl.class.getResourceAsStream("repository.properties");){
            this.descriptors.load(in);
        }
    }

    public TransientRepository() throws IOException {
        this(System.getProperty(CONF_PROPERTY, "repository.xml"), System.getProperty(HOME_PROPERTY, HOME_DEFAULT));
    }

    public TransientRepository(final RepositoryConfig config) throws IOException {
        this(new RepositoryFactory(){

            @Override
            public RepositoryImpl getRepository() throws RepositoryException {
                return RepositoryImpl.create(config);
            }
        });
    }

    public TransientRepository(final String config, final String home) throws IOException {
        this(new RepositoryFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RepositoryImpl getRepository() throws RepositoryException {
                try {
                    File homeDir;
                    File configFile = new File(config);
                    if (!configFile.exists()) {
                        logger.info("Copying default configuration to " + config);
                        try (FileOutputStream output = new FileOutputStream(configFile);){
                            byte[] buffer = new byte[4096];
                            try (InputStream input = TransientRepository.class.getResourceAsStream("repository.xml");){
                                int n = input.read(buffer);
                                while (n != -1) {
                                    ((OutputStream)output).write(buffer, 0, n);
                                    n = input.read(buffer);
                                }
                            }
                        }
                    }
                    if (!(homeDir = new File(home)).exists()) {
                        logger.info("Creating repository home directory " + home);
                        homeDir.mkdirs();
                    }
                    RepositoryConfig rc = RepositoryConfig.create(config, home);
                    return RepositoryImpl.create(rc);
                }
                catch (IOException e) {
                    throw new RepositoryException("Automatic repository configuration failed", (Throwable)e);
                }
                catch (ConfigurationException e) {
                    throw new RepositoryException("Invalid repository configuration: " + config, (Throwable)((Object)e));
                }
            }
        });
    }

    private synchronized void startRepository() throws RepositoryException {
        assert (this.repository == null && this.sessions.isEmpty());
        logger.debug("Initializing transient repository");
        this.repository = this.factory.getRepository();
        logger.info("Transient repository initialized");
    }

    private synchronized void stopRepository() {
        assert (this.repository != null && this.sessions.isEmpty());
        logger.debug("Shutting down transient repository");
        this.repository.shutdown();
        logger.info("Transient repository shut down");
        this.repository = null;
    }

    public synchronized String[] getDescriptorKeys() {
        if (this.repository != null) {
            return this.repository.getDescriptorKeys();
        }
        ArrayList<?> keys = Collections.list(this.descriptors.propertyNames());
        Collections.sort(keys);
        return keys.toArray(new String[keys.size()]);
    }

    public synchronized String getDescriptor(String key) {
        if (this.repository != null) {
            return this.repository.getDescriptor(key);
        }
        return this.descriptors.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Session login(Credentials credentials, String workspaceName) throws RepositoryException {
        if (this.sessions.isEmpty()) {
            this.startRepository();
        }
        try {
            logger.debug("Opening a new session");
            Session session = this.repository.login(credentials, workspaceName);
            this.sessions.add(session);
            ((SessionImpl)session).addListener(this);
            logger.info("Session opened");
            Session session2 = session;
            return session2;
        }
        finally {
            if (this.sessions.isEmpty()) {
                this.stopRepository();
            }
        }
    }

    public Session login(Credentials credentials) throws RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(String workspaceName) throws RepositoryException {
        return this.login(null, workspaceName);
    }

    public Session login() throws RepositoryException {
        return this.login(null, null);
    }

    @Override
    public synchronized void shutdown() {
        for (Session session : new HashSet(this.sessions)) {
            session.logout();
        }
    }

    @Override
    public synchronized void loggedOut(SessionImpl session) {
        assert (this.sessions.contains(session));
        this.sessions.remove(session);
        logger.info("Session closed");
        if (this.sessions.isEmpty()) {
            this.repository.loggedOut(session);
            this.stopRepository();
        }
    }

    @Override
    public void loggingOut(SessionImpl session) {
    }

    public static interface RepositoryFactory {
        public RepositoryImpl getRepository() throws RepositoryException;
    }
}

