/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.local;

import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class FileUtil {
    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(File src, File dest) throws IOException {
        FileOutputStream fos;
        block13: {
            File destParent;
            if (!src.canRead()) {
                throw new IOException(src.getPath() + " can't be read from.");
            }
            if (src.isDirectory()) {
                if (dest.isFile()) {
                    throw new IOException("can't copy a folder to a file");
                }
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (!dest.canWrite()) {
                    throw new IOException("can't write to " + dest.getPath());
                }
                File[] children = src.listFiles();
                for (int i = 0; i < children.length; ++i) {
                    FileUtil.copy(children[i], new File(dest, children[i].getName()));
                }
                return;
            }
            if (dest.isDirectory()) {
                destParent = dest;
                dest = new File(destParent, src.getName());
            } else {
                destParent = dest.getParentFile();
            }
            if (!destParent.canWrite()) {
                throw new IOException("can't write to " + destParent.getPath());
            }
            FileInputStream fis = null;
            fos = null;
            try {
                fis = new FileInputStream(src);
                fos = new FileOutputStream(dest);
                byte[] buffer = new byte[8192];
                int read = 0;
                while ((read = fis.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                }
                if (null == fis) break block13;
            }
            catch (Throwable throwable) {
                if (null != fis) {
                    CloseUtil.close((Closeable[])new Closeable[]{fis});
                }
                if (null == fos) throw throwable;
                CloseUtil.close((Closeable[])new Closeable[]{fos});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{fis});
        }
        if (null == fos) return;
        CloseUtil.close((Closeable[])new Closeable[]{fos});
    }

    public static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                FileUtil.delete(children[i]);
            }
        }
        if (!f.delete()) {
            throw new IOException("Unable to delete " + f.getPath());
        }
    }
}

