/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.FileRecordIterator;
import org.apache.jackrabbit.core.journal.FileRecordLog;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.LockableFileRevision;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;

public class FileJournal
extends AbstractJournal {
    private static final String REVISION_NAME = "revision";
    private static final String LOG_EXTENSION = "log";
    private static final String DEFAULT_BASENAME = "journal";
    private static final int DEFAULT_MAXSIZE = 0x100000;
    private static Logger log = CommonSLF4JLogger.getLogger(FileJournal.class);
    private String directory;
    private String basename;
    private int maximumSize;
    private File rootDirectory;
    private File journalFile;
    private LockableFileRevision globalRevision;

    @Override
    public void init(String id, NamespaceResolver resolver) throws JournalException {
        super.init(id, resolver);
        if (this.directory == null) {
            String msg = "Directory not specified.";
            throw new JournalException(msg);
        }
        if (this.basename == null) {
            this.basename = DEFAULT_BASENAME;
        }
        if (this.maximumSize == 0) {
            this.maximumSize = 0x100000;
        }
        this.rootDirectory = new File(this.directory);
        if (!this.rootDirectory.exists() || !this.rootDirectory.isDirectory()) {
            String msg = "Directory specified does either not exist or is not a directory: " + this.directory;
            throw new JournalException(msg);
        }
        this.journalFile = new File(this.rootDirectory, this.basename + "." + LOG_EXTENSION);
        this.globalRevision = new LockableFileRevision(new File(this.rootDirectory, REVISION_NAME));
        log.info("FileJournal initialized at path: " + this.directory);
    }

    protected long getRevision() throws JournalException {
        return this.globalRevision.get();
    }

    @Override
    protected RecordIterator getRecords(long startRevision) throws JournalException {
        long stopRevision = this.getRevision();
        File[] logFiles = null;
        if (startRevision < stopRevision) {
            logFiles = this.rootDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(FileJournal.this.basename + ".");
                }
            });
            Arrays.sort(logFiles, new Comparator(){

                public int compare(Object o1, Object o2) {
                    File f1 = (File)o1;
                    File f2 = (File)o2;
                    return f1.compareTo(f2);
                }
            });
        }
        return new FileRecordIterator(logFiles, startRevision, stopRevision, this.getResolver(), this.getNamePathResolver());
    }

    @Override
    protected void doLock() throws JournalException {
        this.globalRevision.lock(false);
    }

    @Override
    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        try {
            FileRecordLog recordLog = new FileRecordLog(this.journalFile);
            if (recordLog.exceeds(this.maximumSize)) {
                this.switchLogs();
                recordLog = new FileRecordLog(this.journalFile);
            }
            if (recordLog.isNew()) {
                recordLog.init(this.globalRevision.get());
            }
            long revision = recordLog.append(this.getId(), record.getProducerId(), in, length);
            this.globalRevision.set(revision);
            record.setRevision(revision);
        }
        catch (IOException e) {
            String msg = "Unable to append new record to journal '" + this.journalFile + "'.";
            throw new JournalException(msg, e);
        }
    }

    @Override
    protected void doUnlock(boolean successful) {
        this.globalRevision.unlock();
    }

    @Override
    public void close() {
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getBasename() {
        return this.basename;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    private void switchLogs() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(FileJournal.this.basename + ".");
            }
        };
        File[] files = this.rootDirectory.listFiles(filter);
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return f2.compareTo(f1);
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String name = file.getName();
            int sep = name.lastIndexOf(46);
            if (sep == -1) continue;
            String ext = name.substring(sep + 1);
            if (ext.equals(LOG_EXTENSION)) {
                file.renameTo(new File(this.rootDirectory, name + ".1"));
                continue;
            }
            try {
                int version = Integer.parseInt(ext);
                String newName = name.substring(0, sep + 1) + String.valueOf(version + 1);
                file.renameTo(new File(this.rootDirectory, newName));
                continue;
            }
            catch (NumberFormatException e) {
                log.warn("Bogusly named journal file, skipped: " + file);
            }
        }
    }
}

