/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.core.journal.FileRecordLog;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.ReadRecord;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

class FileRecordIterator
implements RecordIterator {
    private File[] logFiles;
    private long revision;
    private long stopRevision;
    private NamespaceResolver resolver;
    private NamePathResolver npResolver;
    private FileRecordLog recordLog;
    private ReadRecord record;

    public FileRecordIterator(File[] logFiles, long startRevision, long stopRevision, NamespaceResolver resolver, NamePathResolver npResolver) {
        this.logFiles = logFiles;
        this.revision = startRevision;
        this.stopRevision = stopRevision;
        this.resolver = resolver;
        this.npResolver = npResolver;
    }

    @Override
    public boolean hasNext() {
        return this.revision < this.stopRevision;
    }

    @Override
    public Record nextRecord() throws NoSuchElementException, JournalException {
        if (!this.hasNext()) {
            String msg = "No next revision.";
            throw new NoSuchElementException(msg);
        }
        try {
            if (this.record != null) {
                this.record.close();
                this.record = null;
            }
        }
        catch (IOException e) {
            this.close();
            String msg = "Unable to skip over record.";
            throw new JournalException(msg, e);
        }
        if (this.recordLog != null && !this.recordLog.contains(this.revision)) {
            this.recordLog.close();
            this.recordLog = null;
        }
        try {
            if (this.recordLog == null) {
                this.recordLog = this.getRecordLog(this.revision);
            }
        }
        catch (IOException e) {
            String msg = "Unable to open record log with revision: " + this.revision;
            throw new JournalException(msg, e);
        }
        try {
            this.record = this.recordLog.read(this.resolver, this.npResolver);
            this.revision = this.record.getRevision();
            return this.record;
        }
        catch (IOException e) {
            String msg = "Unable to read record with revision: " + this.revision;
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void close() {
        if (this.recordLog != null) {
            this.recordLog.close();
        }
    }

    private FileRecordLog getRecordLog(long revision) throws IOException {
        for (int i = 0; i < this.logFiles.length; ++i) {
            FileRecordLog recordLog = new FileRecordLog(this.logFiles[i]);
            if (!recordLog.contains(revision)) continue;
            recordLog.seek(revision);
            return recordLog;
        }
        String msg = "No log file found containing revision: " + revision;
        throw new IOException(msg);
    }
}

