/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.BundleDbPersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.OraclePersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.slf4j.Logger;

public class Oracle9PersistenceManager
extends OraclePersistenceManager {
    static final String CVS_ID = "$URL: http://svn.apache.org/repos/asf/jackrabbit/tags/1.4/jackrabbit-core/src/main/java/org/apache/jackrabbit/core/persistence/bundle/Oracle9PersistenceManager.java $ $Rev: 575734 $ $Date: 2007-09-14 19:04:19 +0300 (Fri, 14 Sep 2007) $";
    private static Logger log = CommonSLF4JLogger.getLogger(Oracle9PersistenceManager.class);
    private Class blobClass;
    private Integer duractionSessionConstant;
    private Integer modeReadWriteConstant;

    @Override
    public void init(PMContext context) throws Exception {
        super.init(context);
        this.blobClass = this.connectionManager.getConnection().getClass().getClassLoader().loadClass("oracle.sql.BLOB");
        this.duractionSessionConstant = new Integer(this.blobClass.getField("DURATION_SESSION").getInt(null));
        this.modeReadWriteConstant = new Integer(this.blobClass.getField("MODE_READWRITE").getInt(null));
    }

    @Override
    protected BundleDbPersistenceManager.CloseableBLOBStore createDBBlobStore(PMContext context) throws Exception {
        return new OracleBLOBStore();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized void storeBundle(NodePropBundle bundle) throws ItemStateException {
        Blob blob = null;
        try {
            ByteArrayOutputStream out22 = new ByteArrayOutputStream(1024);
            DataOutputStream dout = new DataOutputStream(out22);
            this.binding.writeBundle(dout, bundle);
            dout.close();
            String sql = bundle.isNew() ? this.bundleInsertSQL : this.bundleUpdateSQL;
            blob = this.createTemporaryBlob(new ByteArrayInputStream(out22.toByteArray()));
            Object[] params = this.createParams(bundle.getId().getUUID(), blob, true);
            this.connectionManager.executeStmt(sql, params);
            if (blob == null) return;
        }
        catch (Exception e) {
            try {
                String msg = "failed to write bundle: " + bundle.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                if (blob == null) throw throwable;
                try {
                    this.freeTemporaryBlob(blob);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.freeTemporaryBlob(blob);
            return;
        }
        catch (Exception out22) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        Blob blob = null;
        try {
            boolean update22 = this.exists(refs.getId());
            String sql = update22 ? this.nodeReferenceUpdateSQL : this.nodeReferenceInsertSQL;
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(refs, (OutputStream)out);
            blob = this.createTemporaryBlob(new ByteArrayInputStream(out.toByteArray()));
            Object[] params = this.createParams(refs.getTargetId().getUUID(), blob, true);
            this.connectionManager.executeStmt(sql, params);
            if (blob == null) return;
        }
        catch (Exception e) {
            try {
                String msg = "failed to write property state: " + refs.getTargetId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                if (blob == null) throw throwable;
                try {
                    this.freeTemporaryBlob(blob);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.freeTemporaryBlob(blob);
            return;
        }
        catch (Exception update22) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Blob createTemporaryBlob(InputStream in) throws Exception {
        Method createTemporary = this.blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
        Object blob = createTemporary.invoke(null, this.connectionManager.getConnection(), Boolean.FALSE, this.duractionSessionConstant);
        Method open = this.blobClass.getMethod("open", Integer.TYPE);
        open.invoke(blob, this.modeReadWriteConstant);
        Method getBinaryOutputStream = this.blobClass.getMethod("getBinaryOutputStream", new Class[0]);
        OutputStream out = (OutputStream)getBinaryOutputStream.invoke(blob, null);
        try {
            int read;
            byte[] buf = new byte[8192];
            while ((read = in.read(buf, 0, buf.length)) > -1) {
                out.write(buf, 0, read);
            }
        }
        finally {
            try {
                out.flush();
            }
            catch (IOException read) {}
            out.close();
        }
        Method close = this.blobClass.getMethod("close", new Class[0]);
        close.invoke(blob, null);
        return (Blob)blob;
    }

    protected void freeTemporaryBlob(Object blob) throws Exception {
        Method freeTemporary = this.blobClass.getMethod("freeTemporary", new Class[0]);
        freeTemporary.invoke(blob, null);
    }

    class OracleBLOBStore
    extends BundleDbPersistenceManager.DbBlobStore {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public synchronized void put(String blobId, InputStream in, long size) throws Exception {
            Blob blob = null;
            try {
                PreparedStatement stmt = Oracle9PersistenceManager.this.connectionManager.executeStmt(this.blobSelectExistSQL, new Object[]{blobId});
                ResultSet rs = stmt.getResultSet();
                boolean exists = rs.next();
                Oracle9PersistenceManager.this.closeResultSet(rs);
                String sql = exists ? this.blobUpdateSQL : this.blobInsertSQL;
                blob = Oracle9PersistenceManager.this.createTemporaryBlob(in);
                Oracle9PersistenceManager.this.connectionManager.executeStmt(sql, new Object[]{blob, blobId});
                if (blob == null) return;
            }
            catch (Throwable throwable) {
                if (blob == null) throw throwable;
                try {
                    Oracle9PersistenceManager.this.freeTemporaryBlob(blob);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                Oracle9PersistenceManager.this.freeTemporaryBlob(blob);
                return;
            }
            catch (Exception exception) {}
        }
    }
}

