/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.persistence.bundle.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.bundle.util.ItemStateBinding;
import org.apache.jackrabbit.core.persistence.bundle.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.bundle.util.StringIndex;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.ResourceBasedBLOBStore;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;

public class BundleBinding
extends ItemStateBinding {
    static final String CVS_ID = "$URL: http://svn.apache.org/repos/asf/jackrabbit/tags/1.4/jackrabbit-core/src/main/java/org/apache/jackrabbit/core/persistence/bundle/util/BundleBinding.java $ $Rev: 605147 $ $Date: 2007-12-18 11:08:39 +0200 (Tue, 18 Dec 2007) $";
    private static Logger log = CommonSLF4JLogger.getLogger(BundleBinding.class);

    public BundleBinding(ErrorHandling errorHandling, BLOBStore blobStore, StringIndex nsIndex, StringIndex nameIndex, DataStore dataStore) {
        super(errorHandling, blobStore, nsIndex, nameIndex, dataStore);
    }

    public NodePropBundle readBundle(DataInputStream in, NodeId id) throws IOException {
        NodePropBundle bundle = new NodePropBundle(this, id);
        int index = in.readInt();
        int version = index >> 24 & 0xFF;
        String uri = this.nsIndex.indexToString(index &= 0xFFFFFF);
        String local = this.nameIndex.indexToString(in.readInt());
        Name nodeTypeName = NameFactoryImpl.getInstance().create(uri, local);
        bundle.setNodeTypeName(nodeTypeName);
        bundle.setParentId(this.readID(in));
        bundle.setNodeDefId(NodeDefId.valueOf(in.readUTF()));
        HashSet<Name> mixinTypeNames = new HashSet<Name>();
        Name name = this.readIndexedQName(in);
        while (name != null) {
            mixinTypeNames.add(name);
            name = this.readIndexedQName(in);
        }
        bundle.setMixinTypeNames(mixinTypeNames);
        name = this.readIndexedQName(in);
        while (name != null) {
            PropertyId pId = new PropertyId(bundle.getId(), name);
            NodePropBundle.PropertyEntry pState = this.readPropertyEntry(in, pId);
            bundle.addProperty(pState);
            name = this.readIndexedQName(in);
        }
        bundle.setReferenceable(in.readBoolean());
        NodeId childId = this.readID(in);
        while (childId != null) {
            bundle.addChildNodeEntry(this.readQName(in), childId);
            childId = this.readID(in);
        }
        if (version >= 1) {
            bundle.setModCount(this.readModCount(in));
        }
        return bundle;
    }

    public boolean checkBundle(DataInputStream in) {
        int version;
        try {
            int index = in.readInt();
            version = index >> 24 & 0xFF;
            String uri = this.nsIndex.indexToString(index &= 0xFFFFFF);
            String local = this.nameIndex.indexToString(in.readInt());
            Name nodeTypeName = NameFactoryImpl.getInstance().create(uri, local);
            log.info("Serialzation Version: " + version);
            log.info("NodeTypeName: " + nodeTypeName);
        }
        catch (IOException e) {
            log.error("Error while reading NodeTypeName: " + e);
            return false;
        }
        try {
            UUID parentUuid = this.readUUID(in);
            log.info("ParentUUID: " + parentUuid);
        }
        catch (IOException e) {
            log.error("Error while reading ParentUUID: " + e);
            return false;
        }
        try {
            String definitionId = in.readUTF();
            log.info("DefinitionId: " + definitionId);
        }
        catch (IOException e) {
            log.error("Error while reading DefinitionId: " + e);
            return false;
        }
        try {
            Name mixinName = this.readIndexedQName(in);
            while (mixinName != null) {
                log.info("MixinTypeName: " + mixinName);
                mixinName = this.readIndexedQName(in);
            }
        }
        catch (IOException e) {
            log.error("Error while reading MixinTypes: " + e);
            return false;
        }
        try {
            Name propName = this.readIndexedQName(in);
            while (propName != null) {
                log.info("PropertyName: " + propName);
                if (!this.checkPropertyState(in)) {
                    return false;
                }
                propName = this.readIndexedQName(in);
            }
        }
        catch (IOException e) {
            log.error("Error while reading property names: " + e);
            return false;
        }
        try {
            boolean hasUUID = in.readBoolean();
            log.info("hasUUID: " + hasUUID);
        }
        catch (IOException e) {
            log.error("Error while reading 'hasUUID': " + e);
            return false;
        }
        try {
            UUID cneUUID = this.readUUID(in);
            while (cneUUID != null) {
                Name cneName = this.readQName(in);
                log.info("ChildNodentry: " + cneUUID + ":" + cneName);
                cneUUID = this.readUUID(in);
            }
        }
        catch (IOException e) {
            log.error("Error while reading child node entry: " + e);
            return false;
        }
        if (version >= 1) {
            try {
                short modCount = this.readModCount(in);
                log.info("modCount: " + modCount);
            }
            catch (IOException e) {
                log.error("Error while reading mod cout: " + e);
                return false;
            }
        }
        return true;
    }

    public void writeBundle(DataOutputStream out, NodePropBundle bundle) throws IOException {
        long size = out.size();
        out.writeInt(0x1000000 | this.nsIndex.stringToIndex(bundle.getNodeTypeName().getNamespaceURI()));
        out.writeInt(this.nameIndex.stringToIndex(bundle.getNodeTypeName().getLocalName()));
        this.writeID(out, bundle.getParentId());
        out.writeUTF(bundle.getNodeDefId().toString());
        Iterator iter = bundle.getMixinTypeNames().iterator();
        while (iter.hasNext()) {
            this.writeIndexedQName(out, (Name)iter.next());
        }
        this.writeIndexedQName(out, null);
        for (Name pName : bundle.getPropertyNames()) {
            NodePropBundle.PropertyEntry pState = bundle.getPropertyEntry(pName);
            if (pState == null) {
                log.error("PropertyState missing in bundle: " + pName);
                continue;
            }
            this.writeIndexedQName(out, pName);
            this.writeState(out, pState);
        }
        this.writeIndexedQName(out, null);
        out.writeBoolean(bundle.isReferenceable());
        for (NodePropBundle.ChildNodeEntry entry : bundle.getChildNodeEntries()) {
            this.writeID(out, entry.getId());
            this.writeQName(out, entry.getName());
        }
        this.writeID(out, null);
        this.writeModCount(out, bundle.getModCount());
        bundle.setSize((long)out.size() - size);
    }

    public NodePropBundle.PropertyEntry readPropertyEntry(DataInputStream in, PropertyId id) throws IOException {
        NodePropBundle.PropertyEntry entry = new NodePropBundle.PropertyEntry(id);
        int type = in.readInt();
        entry.setModCount((short)(type >> 16 & 0xFFFF));
        entry.setType(type &= 0xFFFF);
        entry.setMultiValued(in.readBoolean());
        entry.setPropDefId(PropDefId.valueOf(in.readUTF()));
        int count = in.readInt();
        InternalValue[] values = new InternalValue[count];
        String[] blobIds = new String[count];
        for (int i = 0; i < count; ++i) {
            InternalValue val;
            switch (type) {
                case 2: {
                    int size = in.readInt();
                    if (InternalValue.USE_DATA_STORE && size == -2) {
                        val = InternalValue.create(this.dataStore, in.readUTF());
                        break;
                    }
                    if (size == -1) {
                        blobIds[i] = in.readUTF();
                        try {
                            if (this.blobStore instanceof ResourceBasedBLOBStore) {
                                val = InternalValue.create(((ResourceBasedBLOBStore)this.blobStore).getResource(blobIds[i]));
                                break;
                            }
                            val = InternalValue.create(this.blobStore.get(blobIds[i]));
                            break;
                        }
                        catch (IOException e) {
                            if (this.errorHandling.ignoreMissingBlobs()) {
                                log.warn("Ignoring error while reading blob-resource: " + e);
                                val = InternalValue.create(new byte[0]);
                                break;
                            }
                            throw e;
                        }
                        catch (Exception e) {
                            throw new IOException("Unable to create property value: " + e.toString());
                        }
                    }
                    byte[] data = new byte[size];
                    in.readFully(data);
                    val = InternalValue.create(data);
                    break;
                }
                case 4: {
                    val = InternalValue.create(in.readDouble());
                    break;
                }
                case 3: {
                    val = InternalValue.create(in.readLong());
                    break;
                }
                case 6: {
                    val = InternalValue.create(in.readBoolean());
                    break;
                }
                case 7: {
                    val = InternalValue.create(this.readQName(in));
                    break;
                }
                case 9: {
                    val = InternalValue.create(this.readUUID(in));
                    break;
                }
                default: {
                    int len = in.readInt();
                    byte[] bytes = new byte[len];
                    for (int pos = 0; pos < len; pos += in.read(bytes, pos, len - pos)) {
                    }
                    val = InternalValue.valueOf(new String(bytes, "UTF-8"), type);
                }
            }
            values[i] = val;
        }
        entry.setValues(values);
        entry.setBlobIds(blobIds);
        return entry;
    }

    public boolean checkPropertyState(DataInputStream in) {
        int count;
        int type;
        try {
            type = in.readInt();
            short modCount = (short)(type >> 16 | 0xFFFF);
            log.info("  PropertyType: " + PropertyType.nameFromValue((int)(type &= 0xFFFF)));
            log.info("  ModCount: " + modCount);
        }
        catch (IOException e) {
            log.error("Error while reading property type: " + e);
            return false;
        }
        try {
            boolean isMV = in.readBoolean();
            log.info("  MultiValued: " + isMV);
        }
        catch (IOException e) {
            log.error("Error while reading multivalued: " + e);
            return false;
        }
        try {
            String defintionId = in.readUTF();
            log.info("  DefinitionId: " + defintionId);
        }
        catch (IOException e) {
            log.error("Error while reading definition id: " + e);
            return false;
        }
        try {
            count = in.readInt();
            log.info("  num values: " + count);
        }
        catch (IOException e) {
            log.error("Error while reading number of values: " + e);
            return false;
        }
        block38: for (int i = 0; i < count; ++i) {
            switch (type) {
                case 2: {
                    int size;
                    try {
                        size = in.readInt();
                        log.info("  binary size: " + size);
                    }
                    catch (IOException e) {
                        log.error("Error while reading size of binary: " + e);
                        return false;
                    }
                    if (InternalValue.USE_DATA_STORE && size == -2) {
                        try {
                            String s = in.readUTF();
                            log.info("  global data store id: " + s);
                            continue block38;
                        }
                        catch (IOException e) {
                            log.error("Error while reading blob id: " + e);
                            return false;
                        }
                    }
                    if (size == -1) {
                        try {
                            String s = in.readUTF();
                            log.info("  blobid: " + s);
                            continue block38;
                        }
                        catch (IOException e) {
                            log.error("Error while reading blob id: " + e);
                            return false;
                        }
                    }
                    byte[] data = new byte[size];
                    try {
                        in.readFully(data);
                        log.info("  binary: " + data.length + " bytes");
                        continue block38;
                    }
                    catch (IOException e) {
                        log.error("Error while reading inlined binary: " + e);
                        return false;
                    }
                }
                case 4: {
                    try {
                        double d = in.readDouble();
                        log.info("  double: " + d);
                        continue block38;
                    }
                    catch (IOException e) {
                        log.error("Error while reading double value: " + e);
                        return false;
                    }
                }
                case 3: {
                    try {
                        double l = in.readLong();
                        log.info("  long: " + l);
                        continue block38;
                    }
                    catch (IOException e) {
                        log.error("Error while reading long value: " + e);
                        return false;
                    }
                }
                case 6: {
                    try {
                        boolean b = in.readBoolean();
                        log.info("  boolean: " + b);
                        continue block38;
                    }
                    catch (IOException e) {
                        log.error("Error while reading boolean value: " + e);
                        return false;
                    }
                }
                case 7: {
                    try {
                        Name name = this.readQName(in);
                        log.info("  name: " + name);
                        continue block38;
                    }
                    catch (IOException e) {
                        log.error("Error while reading name value: " + e);
                        return false;
                    }
                }
                case 9: {
                    try {
                        UUID uuid = this.readUUID(in);
                        log.info("  reference: " + uuid);
                        continue block38;
                    }
                    catch (IOException e) {
                        log.error("Error while reading reference value: " + e);
                        return false;
                    }
                }
                default: {
                    int len;
                    try {
                        len = in.readInt();
                        log.info("  size of string value: " + len);
                    }
                    catch (IOException e) {
                        log.error("Error while reading size of string value: " + e);
                        return false;
                    }
                    try {
                        byte[] bytes = new byte[len];
                        for (int pos = 0; pos < len; pos += in.read(bytes, pos, len - pos)) {
                        }
                        log.info("  string: " + new String(bytes, "UTF-8"));
                        continue block38;
                    }
                    catch (IOException e) {
                        log.error("Error while reading string value: " + e);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void writeState(DataOutputStream out, NodePropBundle.PropertyEntry state) throws IOException {
        out.writeInt(state.getType() | state.getModCount() << 16);
        out.writeBoolean(state.isMultiValued());
        out.writeUTF(state.getPropDefId().toString());
        values = state.getValues();
        out.writeInt(values.length);
        block30: for (i = 0; i < values.length; ++i) {
            val = values[i];
            switch (state.getType()) {
                case 2: {
                    if (InternalValue.USE_DATA_STORE && this.dataStore != null) {
                        out.writeInt(-2);
                        try {
                            val.store(this.dataStore);
                        }
                        catch (RepositoryException e) {
                            msg = "Error while storing blob. id=" + state.getId() + " idx=" + i + " size=" + val.getBLOBFileValue().getLength();
                            BundleBinding.log.error(msg, (Throwable)e);
                            throw new IOException(msg);
                        }
                        out.writeUTF(val.toString());
                        continue block30;
                    }
                    blobVal = val.getBLOBFileValue();
                    size = blobVal.getLength();
                    if (size < 0L) {
                        BundleBinding.log.warn("Blob has negative size. Potential loss of data. id={} idx={}", (Object)state.getId(), (Object)String.valueOf(i));
                        out.writeInt(0);
                        values[i] = InternalValue.create(new byte[0]);
                        blobVal.discard();
                        continue block30;
                    }
                    if (size <= this.minBlobSize) ** GOTO lbl59
                    out.writeInt(-1);
                    blobId = state.getBlobId(i);
                    if (blobId != null) ** GOTO lbl57
                    try {
                        in = blobVal.getStream();
                        try {
                            blobId = this.blobStore.createId(state.getId(), i);
                            this.blobStore.put(blobId, in, size);
                            state.setBlobId(blobId, i);
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException var11_15) {}
                        }
                    }
                    catch (Exception e) {
                        msg = "Error while storing blob. id=" + state.getId() + " idx=" + i + " size=" + size;
                        BundleBinding.log.error(msg, (Throwable)e);
                        throw new IOException(msg);
                    }
                    try {
                        values[i] = this.blobStore instanceof ResourceBasedBLOBStore ? InternalValue.create(((ResourceBasedBLOBStore)this.blobStore).getResource(blobId)) : InternalValue.create(this.blobStore.get(blobId));
                    }
                    catch (Exception e) {
                        BundleBinding.log.error("Error while reloading blob. truncating. id=" + state.getId() + " idx=" + i + " size=" + size, (Throwable)e);
                        values[i] = InternalValue.create(new byte[0]);
                    }
                    blobVal.discard();
lbl57:
                    // 2 sources

                    out.writeUTF(blobId);
                    continue block30;
lbl59:
                    // 1 sources

                    out.writeInt((int)size);
                    data = new byte[(int)size];
                    try {
                        in = blobVal.getStream();
                        try {
                            pos = 0;
                            while ((long)pos < size) {
                                n = in.read(data, pos, (int)size - pos);
                                if (n < 0) {
                                    throw new EOFException();
                                }
                                pos += n;
                            }
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException pos) {}
                        }
                    }
                    catch (Exception e) {
                        msg = "Error while storing blob. id=" + state.getId() + " idx=" + i + " size=" + size;
                        BundleBinding.log.error(msg, (Throwable)e);
                        throw new IOException(msg);
                    }
                    out.write(data, 0, data.length);
                    values[i] = InternalValue.create(data);
                    blobVal.discard();
                    continue block30;
                }
                case 4: {
                    out.writeDouble(val.getDouble());
                    continue block30;
                }
                case 3: {
                    out.writeLong(val.getLong());
                    continue block30;
                }
                case 6: {
                    out.writeBoolean(val.getBoolean());
                    continue block30;
                }
                case 7: {
                    this.writeQName(out, val.getQName());
                    continue block30;
                }
                case 9: {
                    this.writeUUID(out, val.getUUID());
                    continue block30;
                }
                default: {
                    bytes = val.toString().getBytes("UTF-8");
                    out.writeInt(bytes.length);
                    out.write(bytes);
                }
            }
        }
    }
}

