/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.NodeId;
import org.slf4j.Logger;

public class LRUNodeIdCache {
    static final String CVS_ID = "$URL: http://svn.apache.org/repos/asf/jackrabbit/tags/1.4/jackrabbit-core/src/main/java/org/apache/jackrabbit/core/persistence/bundle/util/LRUNodeIdCache.java $ $Rev: 517150 $ $Date: 2007-03-12 11:42:12 +0200 (Mon, 12 Mar 2007) $";
    private static Logger log = CommonSLF4JLogger.getLogger(LRUNodeIdCache.class);
    private long maxSize = 10240L;
    private long hits = 0L;
    private long misses = 0L;
    private final LinkedMap missing = new LinkedMap();

    public boolean contains(NodeId id) {
        Object o = this.missing.remove((Object)id);
        if (o == null) {
            ++this.misses;
        } else {
            this.missing.put((Object)id, (Object)id);
            ++this.hits;
        }
        if (log.isInfoEnabled() && (this.hits + this.misses) % 10000L == 0L) {
            log.info("num=" + this.missing.size() + "/" + this.maxSize + " hits=" + this.hits + " miss=" + this.misses);
        }
        return o != null;
    }

    public void put(NodeId id) {
        if (!this.missing.containsKey((Object)id)) {
            if ((long)this.missing.size() == this.maxSize) {
                this.missing.remove(0);
            }
            this.missing.put((Object)id, (Object)id);
        }
    }

    public boolean remove(NodeId id) {
        return this.missing.remove((Object)id) != null;
    }

    public void clear() {
        this.missing.clear();
    }
}

