/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.persistence.bundle.util.StringIndex;

public class NamespaceIndex
implements StringIndex {
    static final String CVS_ID = "$URL: http://svn.apache.org/repos/asf/jackrabbit/tags/1.4/jackrabbit-core/src/main/java/org/apache/jackrabbit/core/persistence/bundle/util/NamespaceIndex.java $ $Rev: 517150 $ $Date: 2007-03-12 11:42:12 +0200 (Mon, 12 Mar 2007) $";
    private final NamespaceRegistryImpl nsReg;

    public NamespaceIndex(NamespaceRegistryImpl nsReg) {
        this.nsReg = nsReg;
    }

    @Override
    public int stringToIndex(String uri) {
        try {
            return this.nsReg.getURIIndex(uri);
        }
        catch (NamespaceException e) {
            throw new IllegalStateException("URI not valid? " + e.toString());
        }
    }

    @Override
    public String indexToString(int idx) {
        try {
            return this.nsReg.getURI(idx);
        }
        catch (NamespaceException e) {
            throw new IllegalStateException("URIIndex not valid? " + e.toString());
        }
    }
}

